/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.url.UrlTools;
import eu.javaexperience.web.AbstractContext;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestContext
extends AbstractContext {
    protected final HttpServletRequest request;
    protected final HttpServletResponse response;
    protected Map<String, Object> env = new SmallMap();

    public RequestContext(HttpServletRequest req, HttpServletResponse resp) {
        this.request = req;
        this.response = resp;
        this.requestURL = new PreparedURL(req);
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public Map<String, Object> getEnv() {
        return this.env;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        HttpServletRequest req = this.getRequest();
        sb.append("<RequestContext>\n");
        sb.append("\tMethod:");
        sb.append(req.getMethod());
        sb.append("\n");
        sb.append("\tRequest URL: ");
        sb.append(this.getRequestUrl().toUrl().toString());
        sb.append("\n");
        sb.append("\tRequestParameters: ");
        sb.append(UrlTools.renderRequestParams((Map)this.getRequest().getParameterMap()));
        sb.append("\n");
        sb.append("\tUserAgent: ");
        sb.append(req.getHeader("User-Agent"));
        sb.append("\n");
        sb.append("\tIP: ");
        sb.append(req.getRemoteAddr());
        sb.append("\n");
        sb.append("</RequestContext>");
        return sb.toString();
    }
}

