/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.Format;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.HttpTools;
import eu.javaexperience.web.MIME;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.dispatch.url.URLNode;
import eu.javaexperience.web.facility.SiteFacilityTools;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;

public class AttachFileUrlNode
extends URLNode {
    protected final AbstractFile rootPath;
    protected final boolean listDir;
    protected String allowed_other_sites = null;
    protected boolean followSymlinks = true;

    public void allowOtherSite(String allow) {
        this.allowed_other_sites = allow;
    }

    public void setFollowSymlinks(boolean follow) {
        this.followSymlinks = follow;
    }

    public boolean isFollowingSymlinks() {
        return !this.followSymlinks;
    }

    protected static final String renderFileRow(AbstractFile c) {
        String name = c.getFileName();
        return AttachFileUrlNode.renderRow("td", "<a href=\"./" + name + (c.isDirectory() ? "/" : "") + "\">" + Format.shortenStringIfLongerThan((String)name, (int)20) + (c.isDirectory() ? "/" : "") + "</a>", Format.sqlTimestamp((Date)new Date(c.lastModified())), c.isDirectory() ? c.listFiles().length + " files" : FileTools.toBytesKbMbGbOrTb((long)c.getSize()));
    }

    protected static String renderRow(String tag, String ... cols) {
        StringBuilder sb = new StringBuilder();
        sb.append("<tr>");
        for (String col : cols) {
            sb.append("<");
            sb.append(tag);
            sb.append(">");
            sb.append(col);
            sb.append("</");
            sb.append(tag);
            sb.append(">");
        }
        sb.append("</tr>");
        return sb.toString();
    }

    public AttachFileUrlNode(String nodeName, AbstractFile localDir, boolean listDir) {
        super(nodeName);
        try {
            this.rootPath = localDir.getCanonicalFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.listDir = listDir;
    }

    public AttachFileUrlNode(String nodeName, boolean caseSenitive, AbstractFile localDir, boolean listDir) {
        super(nodeName, caseSenitive);
        try {
            this.rootPath = localDir.getCanonicalFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.listDir = listDir;
    }

    public AttachFileUrlNode(String nodeName, Pattern regex, AbstractFile localDir, boolean listDir) {
        super(nodeName, regex);
        try {
            this.rootPath = localDir.getCanonicalFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.listDir = listDir;
    }

    @Override
    public boolean dispatch(Context ctx) {
        PreparedURL url = ctx.getRequestUrl();
        StringBuilder sb = new StringBuilder();
        StringBuilder webFile = new StringBuilder();
        String rootUrl = this.rootPath.getUrl();
        sb.append(rootUrl);
        String separator = this.rootPath.getFileSystem().getFileSeparator();
        for (int i = 0; i < url.getRemainElementNum(); ++i) {
            webFile.append(separator);
            webFile.append(url.getNextURLElement(i));
        }
        sb.append((CharSequence)webFile);
        try {
            long mod;
            String fstr;
            AbstractFile f = this.rootPath.getFileSystem().fromUri(sb.toString());
            if (null == f || !f.exists()) {
                return false;
            }
            if (this.followSymlinks) {
                f = f.getCanonicalFile();
            }
            if ((fstr = f.getUrl()).indexOf(rootUrl) != 0) {
                return false;
            }
            if (null != this.allowed_other_sites) {
                ctx.getResponse().addHeader("Access-Control-Allow-Origin", this.allowed_other_sites);
            }
            if (SiteFacilityTools.isContentModified(ctx, mod = HttpTools.getWebDate(f.lastModified()))) {
                HttpServletResponse resp = ctx.getResponse();
                SiteFacilityTools.setItemLastModified(ctx, mod);
                if (f.isDirectory() && this.listDir) {
                    AbstractFile parent;
                    StringBuilder c = new StringBuilder();
                    c.append("<html><head><meta charset=\"utf-8\"><title>");
                    c.append("Listting directory: ");
                    c.append(webFile.toString());
                    c.append("</title></head><body><table>");
                    sb.append(AttachFileUrlNode.renderRow("th", "File name", "Last modify", "Size"));
                    AbstractFile files = f.listFiles();
                    sb.append(AttachFileUrlNode.renderRow("td", ".", Format.sqlTimestamp((Date)new Date(f.lastModified())), f.listFiles().length + " file(s)"));
                    if (!this.rootPath.equals(f) && null != (parent = f.getParentFile())) {
                        int ps = 0;
                        AbstractFile[] afs = parent.listFiles();
                        if (null != afs) {
                            ps = afs.length;
                        }
                        sb.append(AttachFileUrlNode.renderRow("td", "<a href=\"../\">../</a>", ps + " file(s)"));
                    }
                    for (AbstractFile file : files) {
                        c.append(AttachFileUrlNode.renderFileRow(file));
                    }
                    SiteFacilityTools.finishWithMimeSend(ctx, MIME.html, c.toString());
                } else {
                    MIME mime = MIME.recogniseFileExtension(fstr);
                    int len = (int)f.getSize();
                    resp.setContentLength(len);
                    resp.setContentType(mime.mime);
                    try (InputStream is = f.openRead();){
                        IOTools.copyStream((InputStream)is, (OutputStream)ctx.getResponse().getOutputStream());
                    }
                    ctx.finishOperation();
                }
                return true;
            }
            SiteFacilityTools.sendItemNotModified(ctx);
        }
        catch (Exception e) {
            Mirror.throwSoftOrHardButAnyway((Throwable)e);
        }
        return true;
    }
}

