/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web;

import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.regex.RegexTools;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.url.UrlTools;
import eu.javaexperience.web.Context;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class WebTools {
    public static final String EMAIL_REGEX = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    public static final Pattern EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    protected static Pattern SELECT_NON_SEO_CHARS = Pattern.compile("[^a-z0-9-]");
    protected static Pattern SELECT_SEO_CHARS_FOR_DASH = Pattern.compile("[- _]");

    public static boolean isValidEmail(String email) {
        return EMAIL_PATTERN.matcher(email).find();
    }

    public static String asSeoName(String str) {
        str = str.toLowerCase();
        str = StringTools.deAccent((String)str);
        str = RegexTools.MATCH_WHITESPACES.matcher(str).replaceAll(" ");
        str = SELECT_SEO_CHARS_FOR_DASH.matcher(str).replaceAll("-");
        str = SELECT_NON_SEO_CHARS.matcher(str).replaceAll("");
        return str;
    }

    public static void main(String[] args) {
        System.out.println(WebTools.asSeoName("16 db \u00e4rv\u00edzt\u0171r\u0151_t\u00fck\u00f6R-F\u0170R\u0150G\u00e9p"));
    }

    public static void acceptPostRequests(Context ctx, @MayNull Map<String, String[]> postRequestParams) {
        try {
            HttpServletRequest request = ctx.getRequest();
            ServletInputStream is = request.getInputStream();
            int n = request.getContentLength();
            int ava = is.available();
            if (n <= 0 && ava > 0) {
                n = is.available();
            }
            byte[] data = null;
            if (n > 0) {
                data = new byte[n];
                IOTools.readFull((InputStream)is, (byte[])data);
            } else {
                data = IOTools.loadAllAvailableFromInputStream((InputStream)is);
            }
            try {
                if (null != postRequestParams) {
                    UrlTools.processArgsRequest((String)new String(data), postRequestParams);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            request.setAttribute("data", (Object)data);
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
    }
}

