/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch;

import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.dispatch.SubdispatchVariator;
import eu.javaexperience.dispatch.WithMatchDispatcher;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetByTools;
import eu.javaexperience.patterns.behavioral.cor.link.CorChainLink;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.CorMatchSubdispatch;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.dispatch.url.URLNodePattern;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

public class WebDispatchTools {
    public static final GetBy1<URLNodePattern, String> PATH_START_MATCHER = new GetBy1<URLNodePattern, String>(){

        public URLNodePattern getBy(final String pathNode) {
            return new URLNodePattern(){

                @Override
                public boolean match(Context ctx) {
                    PreparedURL url = ctx.getRequestUrl();
                    String elem = url.getCurrentURLElement();
                    return pathNode.equals(elem);
                }
            };
        }
    };
    public static final GetBy1<URLNodePattern, String> PATH_IS = new GetBy1<URLNodePattern, String>(){

        public URLNodePattern getBy(final String path) {
            return new URLNodePattern(){

                @Override
                public boolean match(Context ctx) {
                    PreparedURL url = ctx.getRequestUrl();
                    return path.equals(url.getPath());
                }
            };
        }
    };
    public static final GetBy1<URLNodePattern, String> DOMAIN_MATCHER_PERPARATOR = new GetBy1<URLNodePattern, String>(){

        public URLNodePattern getBy(final String domain) {
            return new URLNodePattern(){

                @Override
                public boolean match(Context ctx) {
                    return ctx.getRequestUrl().toUrl().getHost().equals(domain);
                }
            };
        }
    };
    protected static final GetBy1<URLNodePattern, String> PATH_REGEX_MATCHER = new GetBy1<URLNodePattern, String>(){

        public URLNodePattern getBy(String a) {
            final Pattern patt = Pattern.compile(a);
            return new URLNodePattern(){

                @Override
                public boolean match(Context ctx) {
                    URL url = ctx.getRequestUrl().toUrl();
                    return patt.matcher(url.getPath()).find();
                }
            };
        }
    };

    public static <CTX extends Context> CorMatchSubdispatch<CTX> createWith(Dispatcher<CTX> ... disp) {
        CorMatchSubdispatch ret = new CorMatchSubdispatch();
        SubdispatchVariator var = ret.getDispatchVariator();
        for (Dispatcher<CTX> d : disp) {
            var.addDispatcher(d);
        }
        return ret;
    }

    @SafeVarargs
    public static <T, CTX extends Context> CorMatchSubdispatch<CTX> createWithPreparator(GetBy1<URLNodePattern, T> processor, Map.Entry<T, ? extends Dispatcher<CTX>> ... ents) {
        CorMatchSubdispatch ret = new CorMatchSubdispatch();
        SubdispatchVariator var = ret.getDispatchVariator();
        for (Map.Entry<T, Dispatcher<CTX>> entry : ents) {
            final URLNodePattern patt = (URLNodePattern)processor.getBy(entry.getKey());
            if (null == patt) continue;
            WithMatchDispatcher node = new WithMatchDispatcher<CTX>(){

                public boolean isMatch(CTX ctx) {
                    if (patt.match((Context)ctx)) {
                        ctx.getRequestUrl().jumpNextURLElement();
                        return true;
                    }
                    return false;
                }
            };
            node.getDispatchVariator().addDispatcher(entry.getValue());
            var.addDispatcher((Dispatcher)node);
        }
        return ret;
    }

    public static <CTX extends Context> CorMatchSubdispatch<CTX> createWithMatcher(Map.Entry<URLNodePattern, Dispatcher<CTX>> ... ents) {
        return WebDispatchTools.createWithPreparator(GetByTools.getPassTrought(), ents);
    }

    public static <CTX extends Context> CorMatchSubdispatch<CTX> createWithPathNodeStart(Map.Entry<String, ? extends Dispatcher<CTX>> ... ents) {
        return WebDispatchTools.createWithPreparator(PATH_START_MATCHER, ents);
    }

    public static <CTX extends Context> CorMatchSubdispatch<CTX> createWithDomain(Map.Entry<String, ? extends Dispatcher<CTX>> ... ents) {
        return WebDispatchTools.createWithPreparator(DOMAIN_MATCHER_PERPARATOR, ents);
    }

    public static CorChainLink<Context> createWithPathRegex(KeyVal<String, Dispatcher<Context>> keyVal) {
        return WebDispatchTools.createWithPreparator(PATH_REGEX_MATCHER, new Map.Entry[]{keyVal});
    }

    public static CorChainLink<Context> exactPath(final URLNodePattern pattern, final Dispatcher<Context> dispatcher) {
        return new CorChainLink<Context>(){

            public boolean dispatch(Context ctx) {
                if (pattern.match(ctx)) {
                    dispatcher.dispatch((Object)ctx);
                }
                return false;
            }
        };
    }

    public static Dispatcher<Context> wrap(final HttpServlet servlet) {
        return new Dispatcher<Context>(){

            public boolean dispatch(Context ctx) {
                try {
                    servlet.service((ServletRequest)ctx.getRequest(), (ServletResponse)ctx.getResponse());
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
                return true;
            }
        };
    }
}

