/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.HttpTools;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.dispatch.url.SimpleCachedContentUrlNode;
import eu.javaexperience.web.dispatch.url.URLLink;
import eu.javaexperience.web.dispatch.url.URLSalt;
import eu.javaexperience.web.facility.SiteFacilityTools;
import java.util.ArrayList;

public abstract class CachedSaltedContentUrlNode
extends SimpleCachedContentUrlNode {
    protected byte[] data = new byte[0];
    protected long lastModified;
    protected String mime;
    protected boolean checkModifiedOnRequest;
    protected boolean redirectToSalt;
    protected EventMediator<CachedSaltedContentUrlNode> onRefreshed = new EventMediator();
    public final URLSalt salt;

    public EventMediator<CachedSaltedContentUrlNode> getRefreshListener() {
        return this.onRefreshed;
    }

    public CachedSaltedContentUrlNode(String name, String mime) {
        super(name);
        this.lastModified = this.getLastModified();
        this.salt = new URLSalt(this, HttpTools.toCacheSaltHexa(this.lastModified)){

            @Override
            public String getSalt() {
                if (CachedSaltedContentUrlNode.this.checkModifiedOnRequest) {
                    CachedSaltedContentUrlNode.this.checkModificationRefreshIfNeeded();
                }
                return super.getSalt();
            }
        };
        this.addChild(this.salt);
        this.addChild(this.salt);
        this.mime = mime;
    }

    public boolean isCheckModifiedOnAccess() {
        return this.checkModifiedOnRequest;
    }

    public void setCheckModifiedOnRequest(boolean check) {
        this.checkModifiedOnRequest = check;
    }

    public boolean isRedirectToSalt() {
        return this.redirectToSalt;
    }

    public void setRedirectToSalt(boolean redirect) {
        this.redirectToSalt = redirect;
    }

    public abstract byte[] loadContent();

    public abstract long determineLastModified();

    @Override
    public long getLastModified() {
        if (this.checkModifiedOnRequest) {
            this.lastModified = this.determineLastModified();
            return this.lastModified;
        }
        return this.lastModified;
    }

    public boolean checkModificationRefreshIfNeeded() {
        long lastMod = this.determineLastModified();
        if (this.lastModified < lastMod) {
            this.refresh();
            return true;
        }
        return false;
    }

    public CachedSaltedContentUrlNode refresh() {
        this.callbackInvalidate();
        this.lastModified = this.determineLastModified();
        this.data = this.transform(this.loadContent());
        this.salt.setName(HttpTools.toCacheSaltHexa(this.lastModified));
        this.eventRefreshed();
        return this;
    }

    public void callbackInvalidate() {
    }

    protected void eventRefreshed() {
        this.onRefreshed.dispatchEvent((Object)this);
        this.callbackRefreshed();
    }

    protected void callbackRefreshed() {
    }

    public String getSaltedUrl() {
        return this.salt.getCanonicalURL();
    }

    protected byte[] transform(byte[] in) {
        return in;
    }

    @Override
    public byte[] getContent() {
        if (this.checkModifiedOnRequest) {
            this.checkModificationRefreshIfNeeded();
        }
        return this.data;
    }

    @Override
    public String getMimeType() {
        return this.mime;
    }

    @Override
    public String getCanonicalURL() {
        return this.appendRawURLPath(new ArrayList<URLLink>(), false, true);
    }

    @Override
    public boolean dispatch(Context ctx) {
        PreparedURL url = ctx.getRequestUrl();
        this.tryDispatchSubNodes(ctx);
        if (url.hasNextURLElement() || !this.salt.getNodeName().equals(url.getCurrentURLElement())) {
            SiteFacilityTools.httpRedirect(ctx, url.getUrl(url.getUrlPointer(), false) + "/" + this.salt.getNodeName(), true);
            return true;
        }
        ctx.getResponse().setContentType(this.getMimeType());
        return super.dispatch(ctx);
    }
}

