/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.MultiUrlNodePattern;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.dispatch.url.URLNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;

public abstract class JavaInstanceUrlNode
extends URLNode {
    protected final Map<String, Method> meths = new SmallMap();

    public boolean invoke(String name, Context arg) throws Throwable {
        try {
            Method m = this.meths.get(name);
            if (m != null) {
                m.invoke((Object)this, arg);
                return true;
            }
            return false;
        }
        catch (InvocationTargetException tar) {
            throw tar.getCause();
        }
    }

    public Method getMethodByName(String name) {
        return this.meths.get(name);
    }

    public JavaInstanceUrlNode(String nodeName) {
        super(nodeName, true);
    }

    public JavaInstanceUrlNode() {
        super("");
        this.nodeName = this.getClass().getSimpleName();
        this.pattern = MultiUrlNodePattern.simpleCaseSensitiveString(this.getClass().getSimpleName());
        this.loadFunction();
    }

    protected void loadFunction() {
        for (Method m : Mirror.getClassData(this.getClass()).getAllMethods()) {
            Class<?>[] params;
            if (Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers()) || 1 != (params = m.getParameterTypes()).length || !Context.class.isAssignableFrom(params[0])) continue;
            this.meths.put(m.getName(), m);
        }
    }

    protected abstract boolean beforeCall(Context var1, Method var2);

    protected abstract void afterCall(Context var1, Method var2);

    protected abstract void backward(Context var1);

    protected abstract boolean endpoint(Context var1);

    protected abstract boolean access(Context var1);

    @Override
    public boolean dispatch(Context ctx) {
        if (!this.access(ctx)) {
            return false;
        }
        PreparedURL url = ctx.getRequestUrl();
        try {
            if (!url.isEndOfPath()) {
                String name = url.getCurrentURLElement();
                Method m = this.getMethodByName(name);
                if (m != null) {
                    if (!this.beforeCall(ctx, m)) {
                        return false;
                    }
                    m.invoke((Object)this, ctx);
                    this.afterCall(ctx, m);
                }
                boolean sub = this.tryDispatchSubNodes(ctx);
                this.backward(ctx);
                return sub;
            }
            return this.endpoint(ctx);
        }
        catch (Throwable e) {
            Mirror.propagateAnyway((Throwable)e);
            return true;
        }
    }
}

