/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.dispatch.url.TldUrlNode;
import eu.javaexperience.web.dispatch.url.URLNode;
import eu.javaexperience.web.dispatch.url.URLNodeTools;
import java.net.URL;

public abstract class StartsWithUrlNode
extends TldUrlNode {
    protected final PreparedURL matcher;
    protected boolean resetPointer;
    protected URLNode[] seoPath;
    protected boolean allow_partial_match = false;

    public StartsWithUrlNode(URL starts, boolean resetPointer) {
        super("");
        this.matcher = new PreparedURL(starts);
        this.seoPath = URLNodeTools.createFrom(this.matcher);
        this.seoPath[this.seoPath.length - 1].addChild(this);
        this.resetPointer = resetPointer;
    }

    public void modifyCanonocalPath(PreparedURL matcher) {
        this.seoPath[this.seoPath.length - 1].removeChild(this);
        this.seoPath = URLNodeTools.createFrom(matcher);
        this.seoPath[this.seoPath.length - 1].addChild(this);
    }

    @Override
    public boolean dispatch(Context ctx) {
        PreparedURL req = ctx.getRequestUrl();
        if (req.path.length < this.matcher.path.length || !this.allow_partial_match && req.domainSize != this.matcher.domainSize) {
            return false;
        }
        String[] a = this.matcher.path;
        String[] b = req.path;
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        if (this.resetPointer) {
            req.pathPointer = req.domainSize;
        }
        return this.onMatch(ctx);
    }

    public abstract boolean onMatch(Context var1);

    public boolean getAllowPartialMatch() {
        return this.allow_partial_match;
    }

    public void setAllowPartialMatch(boolean allow_partial_match) {
        this.allow_partial_match = allow_partial_match;
    }
}

