/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.features;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.text.Format;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.features.WebSocket;
import eu.javaexperience.web.service.hooks.ServiceProcessHooks;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebSocketEndpoint
implements WebSocket {
    protected final InputStream is;
    protected final OutputStream os;
    protected String key;
    protected ArrayList<SimplePublish1<WebSocketEndpoint>> onDisconnect = new ArrayList();
    protected byte[] packedBuffer = new byte[1024];
    public static final String RFC_6455_MAGIC_STRING = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    public WebSocketEndpoint(InputStream is, OutputStream os) {
        this.is = is;
        this.os = os;
    }

    public String keyKey() {
        return this.key;
    }

    public void addOnDisconnectListener(SimplePublish1<WebSocketEndpoint> dc) {
        this.onDisconnect.add(dc);
    }

    public boolean hasOnDisconnectListener(SimplePublish1<WebSocketEndpoint> dc) {
        return this.onDisconnect.contains(dc);
    }

    public boolean removeOnDisconnectListener(SimplePublish1<WebSocketEndpoint> dc) {
        return this.onDisconnect.remove(dc);
    }

    protected void raiseOnDisconnectListeners() {
        for (SimplePublish1<WebSocketEndpoint> eps : this.onDisconnect) {
            try {
                eps.publish((Object)this);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data) throws IOException {
        OutputStream outputStream = this.os;
        synchronized (outputStream) {
            long length = data.length;
            int rawDataIndex = -1;
            rawDataIndex = length <= 125L ? 2 : (length >= 126L && length <= 65535L ? 4 : 10);
            byte[] frame = new byte[10];
            frame[0] = -127;
            if (rawDataIndex == 2) {
                frame[1] = (byte)length;
            } else if (rawDataIndex == 4) {
                frame[1] = 126;
                frame[2] = (byte)(length >> 8 & 0xFFFFFFFFFFFFFFFFL);
                frame[3] = (byte)(length & 0xFFFFFFFFFFFFFFFFL);
            } else {
                frame[1] = 127;
                frame[2] = (byte)(length >> 56 & 0xFFFFFFFFFFFFFFFFL);
                frame[3] = (byte)(length >> 48 & 0xFFFFFFFFFFFFFFFFL);
                frame[4] = (byte)(length >> 40 & 0xFFFFFFFFFFFFFFFFL);
                frame[5] = (byte)(length >> 32 & 0xFFFFFFFFFFFFFFFFL);
                frame[6] = (byte)(length >> 24 & 0xFFFFFFFFFFFFFFFFL);
                frame[7] = (byte)(length >> 16 & 0xFFFFFFFFFFFFFFFFL);
                frame[8] = (byte)(length >> 8 & 0xFFFFFFFFFFFFFFFFL);
                frame[9] = (byte)(length & 0xFFFFFFFFFFFFFFFFL);
            }
            this.os.write(frame, 0, rawDataIndex);
            this.os.write(data);
            this.os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] receive() throws IOException {
        InputStream inputStream = this.is;
        synchronized (inputStream) {
            int pEp = 0;
            boolean fin = false;
            while (!fin) {
                byte b = (byte)this.is.read();
                fin = (b & 0x80) != 0;
                boolean rsv1 = (b & 0x40) != 0;
                boolean rsv2 = (b & 0x20) != 0;
                boolean rsv3 = (b & 0x10) != 0;
                byte opcode = (byte)(b & 0xF);
                b = (byte)this.is.read();
                boolean masked = (b & 0x80) != 0;
                int payloadLength = 0x7F & b;
                int byteCount = 0;
                if (payloadLength == 127) {
                    byteCount = 8;
                    payloadLength = 0;
                } else if (payloadLength == 126) {
                    byteCount = 2;
                    payloadLength = 0;
                }
                for (int i = byteCount; i > 0; --i) {
                    int val = this.is.read();
                    if (val < 0) {
                        throw new RuntimeException("Endpoint closed");
                    }
                    payloadLength |= (val & 0xFF) << 8 * (i - 1);
                }
                byte[] maskingKey = null;
                if (masked) {
                    int count;
                    maskingKey = new byte[4];
                    for (int i = 0; i < 4; i += count) {
                        count = this.is.read(maskingKey, i, maskingKey.length - i);
                        if (count >= 0) continue;
                        throw new RuntimeException("Endpoint closed");
                    }
                }
                if (pEp + payloadLength > this.packedBuffer.length) {
                    this.packedBuffer = Arrays.copyOf(this.packedBuffer, pEp + payloadLength);
                }
                int start = pEp;
                int i = 0;
                while (i < payloadLength) {
                    int len = this.is.read(this.packedBuffer, pEp, payloadLength - i);
                    if (len < 0) {
                        throw new RuntimeException("Endpoint closed");
                    }
                    i += len;
                    pEp += len;
                }
                if (!masked) continue;
                if (null == maskingKey) {
                    throw new NullPointerException("maskingKey is null");
                }
                for (i = 0; i < payloadLength; ++i) {
                    int n = start + i;
                    this.packedBuffer[n] = (byte)(this.packedBuffer[n] ^ maskingKey[i % 4]);
                }
            }
            return Arrays.copyOf(this.packedBuffer, pEp);
        }
    }

    public void finishConnection() {
        IOTools.silentClose((InputStream)this.is);
        IOTools.silentClose((OutputStream)this.os);
        this.raiseOnDisconnectListeners();
    }

    @Override
    public void close() throws IOException {
        IOTools.silentClose((InputStream)this.is);
        IOTools.silentClose((OutputStream)this.os);
    }

    public void fillHeaders(Map<String, String> dst) throws UnsupportedEncodingException {
        String enc = this.key + RFC_6455_MAGIC_STRING;
        MessageDigest cript = null;
        try {
            cript = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        cript.reset();
        cript.update(enc.getBytes("utf8"));
        dst.put("Connection", "Upgrade");
        dst.put("Upgrade", "websocket");
        dst.put("Sec-WebSocket-Accept", Format.base64Encode((byte[])cript.digest()));
    }

    public static WebSocketEndpoint upgradeHttpRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String key = req.getHeader("Sec-WebSocket-Key");
        if (null == key) {
            throw new RuntimeException("Websocket upgrade failed, no Sec-WebSocket-Key specified in request header");
        }
        String enc = key + RFC_6455_MAGIC_STRING;
        MessageDigest cript = null;
        try {
            cript = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        cript.reset();
        cript.update(enc.getBytes("utf8"));
        resp.setStatus(101);
        resp.addHeader("Connection", "Upgrade");
        resp.addHeader("Upgrade", "websocket");
        resp.addHeader("Sec-WebSocket-Accept", Format.base64Encode((byte[])cript.digest()));
        ServletOutputStream os = resp.getOutputStream();
        os.flush();
        WebSocketEndpoint ret = new WebSocketEndpoint((InputStream)req.getInputStream(), (OutputStream)os);
        ret.key = key;
        return ret;
    }

    public static WebSocket upgradeRequest(Context ctx) throws IOException {
        GetBy1<WebSocket, Context> uw;
        ServiceProcessHooks hooks = ctx.getProcessHooks();
        if (null != hooks && null != (uw = hooks.upgradeWebsocket())) {
            return (WebSocket)uw.getBy((Object)ctx);
        }
        return WebSocketEndpoint.upgradeHttpRequest(ctx.getRequest(), ctx.getResponse());
    }
}

