/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.session;

import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.Session;
import eu.javaexperience.web.SessionManager;
import eu.javaexperience.web.session.SessionTools;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class InMemorySessionManager
implements SessionManager {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("InMemorySessionManager"));
    protected ConcurrentMap<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    public final SimpleCall sessionDestroyer = this::housekeep;

    @Override
    public void destroySession(String str) {
        Session sess;
        if (LOG.mayLog((LoggingDetailLevel)LogLevel.DEBUG)) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"`%s`.destroySession(`%s`)", (Object)this, (Object)str);
        }
        if ((sess = (Session)this.sessions.remove(str)) != null) {
            sess.invalidate();
        }
    }

    @Override
    public String registerSession(Session sess) {
        if (LOG.mayLog((LoggingDetailLevel)LogLevel.DEBUG)) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"`%s`.registerSession(`%s`)", (Object)this, (Object)sess);
        }
        return SessionTools.assignSessionId(sess, this.sessions);
    }

    @Override
    public String getSessionStringBySession(Session sess) {
        for (Map.Entry kv : this.sessions.entrySet()) {
            if (!sess.equals(kv.getValue())) continue;
            return (String)kv.getKey();
        }
        return null;
    }

    public Session getSiteObjectSession(String cookieName, HttpServletRequest req) {
        Cookie[] co = req.getCookies();
        if (co != null) {
            for (Cookie c : co) {
                if (!cookieName.equals(c.getName())) continue;
                return (Session)this.sessions.get(c.getValue());
            }
        }
        return null;
    }

    @Override
    public Session getSessionById(String id) {
        return (Session)this.sessions.get(id);
    }

    @Override
    public void destroySession(Context ctx) {
        String id;
        Session sess = ctx.getSession();
        if (null != sess && null != (id = sess.getId())) {
            this.destroySession(id);
        }
    }

    @Override
    public Set<Map.Entry<String, Session>> listAllSession() {
        return this.sessions.entrySet();
    }

    @Override
    public void addSessionWithId(String sessionCookieValue, Session sess) {
        if (LOG.mayLog((LoggingDetailLevel)LogLevel.DEBUG)) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"`%s`.addSessionWithId(`%s`, `%s`)", (Object)this, (Object)sessionCookieValue, (Object)sess);
        }
        this.sessions.put(sessionCookieValue, sess);
    }

    @Override
    public void housekeep() {
        if (LOG.mayLog((LoggingDetailLevel)LogLevel.MEASURE)) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"`%s`.housekeep()", (Object)this);
        }
        for (Map.Entry kv : this.sessions.entrySet()) {
            Session sess = (Session)kv.getValue();
            if (sess == null || sess.validUntil() <= -1L || sess.validUntil() < System.currentTimeMillis()) continue;
            this.sessions.remove(kv.getKey());
            try {
                sess.invalidate();
            }
            catch (Exception e) {
                LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.WARNING, (Throwable)e, (String)"Exception while invalidationg session `%s` ", (Object)sess);
            }
        }
    }
}

