/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.session;

import eu.javaexperience.collection.enumerations.EnumerationFromIterator;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.Session;
import eu.javaexperience.web.service.hooks.ServiceProcessHooks;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class SessionImpl
implements Session {
    protected String id;
    protected ServiceProcessHooks hooks;
    protected final long creationTime;
    protected long lastAccess;
    protected boolean isNew = true;
    protected int validLADT = 3600000;
    protected final Map<String, Object> env;

    public SessionImpl(ServiceProcessHooks hooks) {
        this(hooks, (Map<String, Object>)new SmallMap());
    }

    public SessionImpl(ServiceProcessHooks hooks, Map<String, Object> params) {
        this.hooks = hooks;
        this.lastAccess = this.creationTime = System.currentTimeMillis();
        this.env = params;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public long updateUseSession(Context ctx) {
        SimplePublish2<Session, Context> pub;
        long prev = this.lastAccess;
        this.lastAccess = System.currentTimeMillis();
        this.isNew = false;
        ServiceProcessHooks hooks = this.hooks;
        if (null != hooks && null != (pub = hooks.onSessionRefreshLastUse())) {
            pub.publish((Object)this, (Object)ctx);
        }
        return prev;
    }

    @Override
    public long validUntil() {
        if (this.validLADT < 0) {
            return -1L;
        }
        return this.lastAccess + (long)this.validLADT;
    }

    public long getLastAccessedTime() {
        return this.lastAccess;
    }

    public void setMaxInactiveInterval(int interval) {
        this.validLADT = interval * 1000;
    }

    public int getMaxInactiveInterval() {
        return this.validLADT;
    }

    public Object getAttribute(String name) {
        return this.env.get(name);
    }

    public Object getValue(String name) {
        return this.env.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new EnumerationFromIterator(this.env.keySet());
    }

    public String[] getValueNames() {
        return this.env.keySet().toArray(Mirror.emptyStringArray);
    }

    public void setAttribute(String name, Object value) {
        Object o = this.env.put(name, value);
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
        if (o instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)o).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, o));
        }
    }

    public void putValue(String name, Object value) {
        this.env.put(name, value);
    }

    public void removeAttribute(String name) {
        Object o = this.env.remove(name);
        if (o instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)o).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, o));
        }
    }

    public void removeValue(String name) {
        this.env.remove(name);
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public Map<String, Object> getEnv() {
        return this.env;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    @Override
    public ServiceProcessHooks getProcessHooks() {
        return this.hooks;
    }

    @Override
    public void setServiceProcessHooks(ServiceProcessHooks hooks) {
        this.hooks = hooks;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

