/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.session;

import eu.javaexperience.text.StringTools;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.HttpTools;
import eu.javaexperience.web.Session;
import eu.javaexperience.web.SessionManager;
import eu.javaexperience.web.facility.SiteFacilityTools;
import eu.javaexperience.web.session.SessionImpl;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.Cookie;

public class SessionTools {
    public static Session tryAssignSession(SessionManager manager, String sessionCookieName, Context ctx) {
        String req_id = SiteFacilityTools.getCookieValue(ctx, sessionCookieName);
        if (null == req_id) {
            return null;
        }
        Session session = manager.getSessionById(req_id);
        if (null != session) {
            ctx.setSession(session);
        }
        return session;
    }

    public static Session sessionStart(SessionManager manager, String sessionCookieName, Context ctx) {
        String[] req_ids = HttpTools.getCookieValues(ctx, sessionCookieName);
        Session session = null;
        if (null != req_ids && req_ids.length > 0) {
            String req_id;
            String[] stringArray = req_ids;
            int n = stringArray.length;
            for (int i = 0; i < n && null == (session = manager.getSessionById(req_id = stringArray[i])); ++i) {
            }
        }
        if (null == session) {
            if (null != req_ids && req_ids.length > 0 && null != req_ids[0] && req_ids.length > 10) {
                session = SessionTools.getOrCreateBySession(manager, req_ids[0]);
            }
            if (null == session) {
                session = SessionTools.createSession(manager);
            }
            Cookie c = new Cookie(sessionCookieName, session.getId());
            c.setPath("/");
            c.setMaxAge(600);
            ctx.getResponse().addCookie(c);
        }
        ctx.setSession(session);
        session.updateUseSession(ctx);
        return session;
    }

    public static final String assignSessionId(Session session, ConcurrentMap<String, Session> map) {
        String sess;
        Session ret;
        while ((ret = map.putIfAbsent(sess = StringTools.randomString((int)25), session)) != null) {
        }
        session.setId(sess);
        return sess;
    }

    public static Session createSession(SessionManager manager) {
        SessionImpl session = new SessionImpl(null);
        String id = manager.registerSession(session);
        session.setId(id);
        return session;
    }

    public static Session getOrCreateBySession(SessionManager sessionManager, String sessId) {
        Session sess = sessionManager.getSessionById(sessId);
        if (null == sess) {
            sess = new SessionImpl(null);
            sess.setId(sessId);
            sessionManager.addSessionWithId(sessId, sess);
        }
        return sess;
    }
}

