/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.template;

import eu.javaexperience.collection.PublisherCollection;
import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.FileSystemTools;
import eu.javaexperience.file.fs.os.OsFile;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.regex.RegexTools;
import eu.javaexperience.web.template.Template;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateManagerTools {
    public static File toFile(File dir, String name, String fullExtension) {
        String[] elems = RegexTools.SLASHES.split(name);
        StringBuilder sb = new StringBuilder();
        sb.append(dir.toString());
        for (int i = 0; i < elems.length - 1; ++i) {
            sb.append("/");
            sb.append(elems[i]);
        }
        sb.append("/");
        sb.append(elems[elems.length - 1]);
        sb.append(".");
        sb.append(fullExtension);
        return new File(sb.toString());
    }

    public static AbstractFile toFile(AbstractFile dir, String name, String fullExtension) {
        String[] elems = RegexTools.SLASHES.split(name);
        StringBuilder sb = new StringBuilder();
        sb.append(dir.getUrl());
        for (int i = 0; i < elems.length - 1; ++i) {
            sb.append("/");
            sb.append(elems[i]);
        }
        sb.append("/");
        sb.append(elems[elems.length - 1]);
        sb.append(".");
        sb.append(fullExtension);
        return dir.getFileSystem().fromUri(sb.toString());
    }

    public static <T> void parseAndPrepareViewInto(Map<String, T> destination, GetBy1<T, String> parser, String viewName, String content) throws IOException {
        destination.put(viewName, parser.getBy((Object)content));
    }

    public static <T> Map<String, T> loadViewsFromDirRecursiveRaw(Map<String, T> ret, GetBy1<T, String> parser, File dir, String extension) {
        return TemplateManagerTools.loadViewsFromDirRecursiveRaw(ret, parser, (AbstractFile)new OsFile(dir), extension);
    }

    public static <T> Map<String, T> loadViewsFromDirRecursiveRaw(final Map<String, T> ret, final GetBy1<T, String> parser, AbstractFile dir, final String extension) {
        final int start = RegexTools.SLASHES_LINUX_WINDOWS.split(dir.getUrl()).length;
        FileSystemTools.find((AbstractFile)dir, (Collection)new PublisherCollection<AbstractFile>(){

            public boolean add(AbstractFile file) {
                String t;
                Pattern p = Pattern.compile("\\/(?<teil>[^/]+)\\." + extension + "$");
                Matcher m = p.matcher(file.toString());
                if (m.find() && null != (t = m.group("teil"))) {
                    String[] paths = RegexTools.SLASHES_LINUX_WINDOWS.split(file.toString());
                    StringBuilder tn = new StringBuilder();
                    for (int i = start; i < paths.length - 1; ++i) {
                        if (tn.length() > 0) {
                            tn.append("/");
                        }
                        tn.append(paths[i]);
                    }
                    if (tn.length() > 0) {
                        tn.append("/");
                    }
                    tn.append(t);
                    try {
                        TemplateManagerTools.parseAndPrepareViewInto(ret, parser, tn.toString(), IOTools.getFileContents((AbstractFile)file));
                    }
                    catch (Exception e) {
                        System.err.println(file);
                        e.printStackTrace();
                    }
                }
                return true;
            }
        });
        return ret;
    }

    public static <T extends Template> Map<String, T> loadRecursiveWithDevelopementReload(File dir, GetBy1<T, String> parser, String extension) {
        return TemplateManagerTools.loadRecursiveWithDevelopementReload((AbstractFile)new OsFile(dir), parser, extension);
    }

    public static <T extends Template> Map<String, T> loadRecursiveWithDevelopementReload(final AbstractFile dir, final GetBy1<T, String> parser, final String extension) {
        final Map views = TemplateManagerTools.loadViewsFromDirRecursiveRaw(new ConcurrentHashMap(), parser, dir, extension);
        final HashMap mods = new HashMap();
        OneShotMap rt = new OneShotMap<String, T>(null, null){

            public T get(Object key) {
                AbstractFile f = TemplateManagerTools.toFile(dir, key.toString(), extension);
                Long l = (Long)mods.get(f);
                long mod = f.lastModified();
                if (null == l || l < mod) {
                    try {
                        TemplateManagerTools.parseAndPrepareViewInto(views, parser, key.toString(), IOTools.getFileContents((AbstractFile)f));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    mods.put(f, mod);
                }
                return (Template)views.get(key);
            }
        };
        return rt;
    }
}

