/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.template;

import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.exceptions.OperationSuccessfullyEnded;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.patterns.behavioral.cor.link.CorChainLink;
import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.Format;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.MIME;
import eu.javaexperience.web.RequestContext;
import eu.javaexperience.web.SessionManager;
import eu.javaexperience.web.WebTools;
import eu.javaexperience.web.dispatch.DefaultDispatchStructure;
import eu.javaexperience.web.facility.SiteFacilityTools;
import eu.javaexperience.web.session.InMemorySessionManager;
import eu.javaexperience.web.session.SessionTools;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebsiteTemplate
extends HttpServlet
implements ExternalDataAttached {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("WebsiteTemplate"));
    protected final DefaultDispatchStructure dds = new DefaultDispatchStructure();
    protected final GetBy2<Context, HttpServletRequest, HttpServletResponse> createContext;
    protected final EventMediator<Map.Entry<WebsiteTemplate, Context>> initContext;
    protected final SessionManager sessionManager;
    protected final String sessionCookieName;
    protected final SimplePublish1<Context> handle404;
    protected final SimplePublish1<Context> handleApp;
    protected final SimplePublish2<Context, Throwable> exceptionHandler;
    protected SmallMap<String, Object> extra;

    public WebsiteTemplate(WebsiteTemplateTemplateBuilder builder) {
        this.createContext = builder.createContext;
        this.handle404 = builder.handle404;
        this.handleApp = builder.handleApp;
        this.sessionManager = builder.sessionManager;
        this.sessionCookieName = builder.sessionCookieName;
        this.initContext = new EventMediator();
        this.exceptionHandler = builder.exceptionHandler;
        for (SimplePublish1 l : builder.initContext.getListeners()) {
            this.initContext.addEventListener(l);
        }
        this.dds.getChains().getChainByName("pre").addLink((CorChainLink)new CorChainLink<Context>(){

            public boolean dispatch(Context ctx) {
                if (WebsiteTemplate.this.initContext.hasListener()) {
                    KeyVal kv = new KeyVal((Object)WebsiteTemplate.this, (Object)ctx);
                    WebsiteTemplate.this.initContext.dispatchEvent((Object)kv);
                }
                return false;
            }
        });
        this.dds.getChains().getChainByName("app").addLink((CorChainLink)new CorChainLink<Context>(){

            public boolean dispatch(Context ctx) {
                if (null != WebsiteTemplate.this.handleApp) {
                    WebsiteTemplate.this.handleApp.publish((Object)ctx);
                }
                return false;
            }
        });
        this.dds.getChains().getChainByName("last").addLink((CorChainLink)new CorChainLink<Context>(){

            public boolean dispatch(Context ctx) {
                if (null != WebsiteTemplate.this.handle404) {
                    WebsiteTemplate.this.handle404.publish((Object)ctx);
                }
                return false;
            }
        });
    }

    public EventMediator<Map.Entry<WebsiteTemplate, Context>> getContextInitializers() {
        return this.initContext;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public DefaultDispatchStructure getDispatchStructure() {
        return this.dds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context ctx = (Context)this.createContext.getBy((Object)req, (Object)resp);
        try {
            SiteFacilityTools.setCurrentContext(ctx);
            this.dds.getChains().dispatch((Object)ctx);
        }
        catch (OperationSuccessfullyEnded s) {
            return;
        }
        catch (Throwable e) {
            LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.WARNING, (Throwable)e, (String)"Exception while handling http request ");
            this.exceptionHandler.publish((Object)ctx, (Object)e);
        }
        finally {
            resp.flushBuffer();
            SiteFacilityTools.setCurrentContext(null);
        }
    }

    public synchronized Map<String, Object> getExtraDataMap() {
        if (null == this.extra) {
            this.extra = new SmallMap();
        }
        return this.extra;
    }

    public static class WebsiteTemplateTemplateBuilder {
        public static final SimplePublish2<Context, Throwable> DEFAULT_EXCEPTION_HANDLER = (ctx, e) -> {
            ctx.getResponse().setStatus(500);
            ctx.getResponse().setContentType("text/plain; charset=utf-8");
            try {
                ctx.getResponse().getOutputStream().write(Format.getPrintedStackTrace((Throwable)e).getBytes());
            }
            catch (IOException e1) {
                Mirror.propagateAnyway((Throwable)e1);
            }
        };
        public static final GetBy2<Context, HttpServletRequest, HttpServletResponse> DEFAULT_CONTEXT_CREATOR = (req, resp) -> new RequestContext((HttpServletRequest)req, (HttpServletResponse)resp);
        public SessionManager sessionManager = null;
        public String sessionCookieName = "jvx-session";
        public GetBy2<Context, HttpServletRequest, HttpServletResponse> createContext = DEFAULT_CONTEXT_CREATOR;
        public EventMediator<Map.Entry<WebsiteTemplate, Context>> initContext = new EventMediator();
        public SimplePublish1<Context> handleApp;
        public SimplePublish1<Context> handle404;
        public SimplePublish2<Context, Throwable> exceptionHandler = DEFAULT_EXCEPTION_HANDLER;

        public WebsiteTemplateTemplateBuilder defaultSessionManagement() {
            this.sessionManager = new InMemorySessionManager();
            return this;
        }

        public WebsiteTemplateTemplateBuilder default404Handler() {
            this.handle404 = ctx -> {
                ctx.getResponse().setStatus(404);
                SiteFacilityTools.finishWithMimeSend(ctx, MIME.plain, "404");
            };
            return this;
        }

        public WebsiteTemplateTemplateBuilder addPostLoader() {
            this.initContext.addEventListener(ent -> WebTools.acceptPostRequests((Context)ent.getValue(), null));
            return this;
        }

        public WebsiteTemplateTemplateBuilder addSessionStarter() {
            this.initContext.addEventListener(ent -> {
                WebsiteTemplate wt = (WebsiteTemplate)((Object)((Object)ent.getKey()));
                if (null != wt.getSessionManager() && null != wt.getSessionCookieName()) {
                    SessionTools.sessionStart(wt.getSessionManager(), wt.getSessionCookieName(), (Context)ent.getValue());
                }
            });
            return this;
        }

        public WebsiteTemplateTemplateBuilder withDefaults() {
            this.addPostLoader();
            this.addSessionStarter();
            this.default404Handler();
            this.defaultSessionManagement();
            return this;
        }

        public static WebsiteTemplateTemplateBuilder createDefaults() {
            WebsiteTemplateTemplateBuilder ret = new WebsiteTemplateTemplateBuilder();
            ret.withDefaults();
            return ret;
        }
    }
}

