/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.web;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.RpcSession;
import eu.javaexperience.rpc.RpcTools;
import eu.javaexperience.rpc.SimpleRpcRequest;
import eu.javaexperience.rpc.SimpleRpcSession;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcDefaultProtocol;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcProtocolHandler;
import eu.javaexperience.rpc.codegen.AstInterfaceGenerator;
import eu.javaexperience.rpc.codegen.JavaRpcInterfaceGenerator;
import eu.javaexperience.rpc.codegen.JavascriptRpcSourceGenerator;
import eu.javaexperience.rpc.codegen.PhpRpcInterfaceGenerator;
import eu.javaexperience.rpc.codegen.RpcSourceBuilder;
import eu.javaexperience.rpc.http.RpcHttpTools;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.url.UrlTools;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.MIME;
import eu.javaexperience.web.dispatch.url.JavaClassURLNode;
import eu.javaexperience.web.facility.SiteFacilityTools;
import eu.javaexperience.web.features.WebSocket;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RpcUrlNode<R extends RpcRequest, S extends RpcSession>
extends JavaClassURLNode {
    protected final BidirectionalRpcProtocolHandler<S> protocol;
    protected final GetBy1<S, Context> getSession;
    protected final GetBy2<R, DataObject, S> wrapRequest;
    protected final Map<String, RpcSourceBuilder> targetLanguages = new HashMap<String, RpcSourceBuilder>(){
        {
            this.put("javascript", JavascriptRpcSourceGenerator.BASIC_JAVASCRIPT_SOURCE_BUILDER);
            this.put("php", PhpRpcInterfaceGenerator.BASIC_PHP_SOURCE_BUILDER);
            this.put("java", JavaRpcInterfaceGenerator.BASIC_JAVA_SOURCE_BUILDER);
            this.put("ast", AstInterfaceGenerator.BASIC_AST_SOURCE_BUILDER);
        }
    };
    protected final SimplePublish2<Boolean, WebSocket> websocketEvent = new SimplePublish2<Boolean, WebSocket>(){

        public void publish(Boolean a, WebSocket b) {
            RpcUrlNode.this.onWebsocketConnection(a, b);
        }
    };

    public RpcUrlNode(String nodeName, BidirectionalRpcProtocolHandler<S> proto, GetBy1<S, Context> getSession, GetBy2<R, DataObject, S> wrapRequest) {
        super(nodeName);
        this.protocol = proto;
        this.getSession = getSession;
        this.wrapRequest = wrapRequest;
    }

    public static RpcUrlNode<SimpleRpcRequest, SimpleRpcSession> createSimple(String nodeName, final String usePostfix, final RpcFacility ... apis) {
        final GetBy1 dispatcher = RpcTools.createSimpleNamespaceDispatcherWithDiscoverApi((RpcFacility[])apis);
        BidirectionalRpcDefaultProtocol PROTOCOL = BidirectionalRpcDefaultProtocol.DEFAULT_PROTOCOL_HANDLER_WITH_CLASS;
        RpcUrlNode<SimpleRpcRequest, SimpleRpcSession> ret = new RpcUrlNode<SimpleRpcRequest, SimpleRpcSession>(nodeName, (BidirectionalRpcProtocolHandler)PROTOCOL, RpcHttpTools.generateGetOrCreateSessionGetter("RPC_SESSION_OF_" + nodeName, (RpcProtocolHandler)PROTOCOL), RpcHttpTools.WRAP_SIMPLE_RPC_REQUEST){

            @Override
            protected void fillApis(List<RpcFacility> dst, Context req, boolean all) {
                CollectionTools.copyInto((Object[])apis, dst);
            }

            @Override
            protected GetBy1<DataObject, SimpleRpcRequest> getDispatcher(Context ctx) {
                return dispatcher;
            }

            @Override
            protected String formatApiName(RpcFacility node) {
                if (null == usePostfix) {
                    return node.getRpcName();
                }
                return node.getRpcName() + usePostfix;
            }

            @Override
            protected String extractApiName(String name) {
                if (null == usePostfix) {
                    return name;
                }
                return StringTools.getSubstringBeforeLastString((String)name, (String)usePostfix);
            }
        };
        return ret;
    }

    protected RpcSourceBuilder getLang(Context ctx) {
        RpcSourceBuilder ret;
        String lang = ctx.getRequest().getParameter("lang");
        if (null == lang) {
            SiteFacilityTools.finishWithElementSend((Context)ctx, (String)("Specify one language (GET parameter \"lang\")! Available languages: " + CollectionTools.toString(this.targetLanguages.keySet())));
        }
        if (null == (ret = this.targetLanguages.get(lang))) {
            SiteFacilityTools.finishWithElementSend((Context)ctx, (String)("Select a correct one of the available languages (GET parameter \"lang\"): " + CollectionTools.toString(this.targetLanguages.keySet())));
        }
        return ret;
    }

    public String formatApis(Collection<? extends RpcFacility> apis, RpcSourceBuilder lang, Map<String, String> opts) {
        StringBuilder sb = new StringBuilder();
        for (RpcFacility rpcFacility : apis) {
            sb.append(lang.buildRpcClientSource(this.formatApiName(rpcFacility), rpcFacility.getWrappedFunctions(), opts));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    protected void source(Context ctx) {
        SmallMap opts = new SmallMap();
        UrlTools.fillMultiMap((Map)opts, (Map)ctx.getRequest().getParameterMap());
        ArrayList<RpcFacility> apis = new ArrayList<RpcFacility>();
        this.fillApis(apis, ctx, false);
        if (0 == apis.size()) {
            this.fillApis(apis, ctx, false);
            ArrayList<String> strs = new ArrayList<String>();
            for (RpcFacility api : apis) {
                strs.add(this.formatApiName(api));
            }
            SiteFacilityTools.finishWithElementSend((Context)ctx, (String)("Specify one api (GET parameter \"api\")! Available apis: " + CollectionTools.toString(strs)));
        }
        SiteFacilityTools.finishWithMimeSend((Context)ctx, (String)this.formatApis(apis, this.getLang(ctx), (Map<String, String>)opts), (MIME)MIME.javascript);
    }

    protected String[] getRequestedApis(Context ctx) {
        Object[] req = ctx.getRequest().getParameterValues("api");
        if (null == req) {
            req = Mirror.emptyStringArray;
        }
        req = (String[])ArrayTools.withoutNulls((Object[])req);
        for (int i = 0; i < req.length; ++i) {
            req[i] = this.extractApiName((String)req[i]);
        }
        return req;
    }

    protected abstract void fillApis(List<RpcFacility> var1, Context var2, boolean var3);

    protected abstract GetBy1<DataObject, R> getDispatcher(Context var1);

    protected String formatApiName(RpcFacility node) {
        return node.getRpcName();
    }

    protected String extractApiName(String name) {
        return name;
    }

    protected void ajax(Context ctx) throws IOException {
        RpcHttpTools.serveRpcAjaxRequest(ctx, this.wrapRequest, this.getSession, this.protocol, this.getDispatcher(ctx));
    }

    public DataObject serveRequest(Context ctx, DataObject req) {
        return RpcHttpTools.dispatchSingleRequest(req, ctx, this.wrapRequest, this.getSession, this.protocol, this.getDispatcher(ctx));
    }

    public void websocket(Context ctx) throws NoSuchAlgorithmException, IOException {
        RpcHttpTools.handleWebsocketRequest(ctx, this.wrapRequest, this.getSession, this.protocol, this.getDispatcher(ctx), this.websocketEvent);
    }

    protected void onWebsocketConnection(boolean true_connect_false_dc, WebSocket ws) {
    }

    public boolean dispatch(Context ctx) {
        String next = ctx.getRequestUrl().getCurrentURLElement();
        if (null != next) {
            try {
                switch (next) {
                    case "source": {
                        this.source(ctx);
                    }
                    case "ajax": {
                        this.ajax(ctx);
                    }
                    case "websocket": {
                        this.websocket(ctx);
                    }
                }
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        }
        return super.dispatch(ctx);
    }

    protected boolean beforeCall(Context ctx, Method m) {
        return false;
    }

    protected void afterCall(Context ctx, Method m) {
    }

    protected void backward(Context ctx) {
    }

    protected boolean endpoint(Context ctx) {
        return false;
    }

    protected boolean access(Context ctx) {
        return true;
    }

    public List<RpcFacility> getApis() {
        ArrayList<RpcFacility> ret = new ArrayList<RpcFacility>();
        this.fillApis(ret, null, true);
        return ret;
    }
}

