package eu.javaexperience.webtest;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.openqa.selenium.WebDriver;

import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.text.StringTools;

public class WebDriverTestContext implements ExternalDataAttached, Closeable
{
	protected WebDriver driver;
	protected String rootDomain;
	protected PortalSupport portalSupport;
	protected String testAssetFileRoot;
	
	protected int defaultPollWaitMs = 100;
	protected int defaultPollWaitCount = 200;
	
	public WebDriverTestContext
	(
		WebDriver driver,
		String rootDomain,
		PortalSupport ps,
		String testAssetFileRoot
	)
	{
		this.driver = driver;
		this.rootDomain = rootDomain;
		this.portalSupport = ps;
		this.testAssetFileRoot = testAssetFileRoot;
	}
	
	public int getPollWaitMilisec()
	{
		return defaultPollWaitMs;
	}
	
	public int getPollWaitMaxCount()
	{
		return defaultPollWaitCount;
	}
	
	public String getRootDomain()
	{
		return rootDomain;
	}
	
	public PortalSupport getPortalSupport()
	{
		return portalSupport;
	}
	
	public WebDriver getWebDriver()
	{
		return driver;
	}
	
	public String getTestAssetFileRoot()
	{
		return testAssetFileRoot;
	}
	
	protected Map<String, Object> extraData;
	@Override
	public Map<String, Object> getExtraDataMap()
	{
		if(null == extraData)
		{
			extraData = new HashMap<>();
		}
		return extraData;
	}

	public Object getExtra(String key)
	{
		return getExtraDataMap().get(key);
	}
	
	public Object getExtra(Enum key)
	{
		return getExtraDataMap().get(key.name());
	}
	
	public String getExtraString(String key)
	{
		return StringTools.toStringOrNull(getExtraDataMap().get(key));
	}
	
	public String getExtraString(Enum key)
	{
		return StringTools.toStringOrNull(getExtraDataMap().get(key.name()));
	}
	
	public void destroy()
	{
		//driver.close();
		driver.quit();
	}

	@Override
	public void close() throws IOException
	{
		destroy();
	}

	public void closeOnExit()
	{
		Runtime.getRuntime().addShutdownHook(new Thread()
		{
			@Override
			public void run()
			{
				IOTools.silentClose(WebDriverTestContext.this);
			}
		});
	}
}
