package eu.javaexperience.webtest;

import org.openqa.selenium.WebElement;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;

public class WebTestFunctions
{
	public static GetBy1<Boolean, WebElement> isText(final GetBy1<Boolean, String> text)
	{
		return new GetBy1<Boolean, WebElement>()
		{
			@Override
			public Boolean getBy(WebElement a)
			{
				return text.getBy(a.getText());
			}
		};
	}
	
	public static <T> SimplePublish1<WebDriverTestContext> visitUrl(final String url)
	{
		return new SimplePublish1<WebDriverTestContext>()
		{
			@Override
			public void publish(WebDriverTestContext a)
			{
				a.driver.navigate().to(url);
			}
		};
	}
}
