package eu.javaexperience.webtest;

import java.io.File;
import java.util.Collection;
import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.verify.WeightedValidationReportEntry;

public class WebTestTools
{
	public static <T> void checkAfterEveryActor
	(
		WebDriverTestContext ctx,
		Collection<WeightedValidationReportEntry<T>> errors,
		SimplePublish2<WebDriverTestContext, Collection<WeightedValidationReportEntry<T>>> checker,
		SimplePublish1<WebDriverTestContext>... actors
	)
	{
		for(SimplePublish1<WebDriverTestContext> act:actors)
		{
			act.publish(ctx);
			checker.publish(ctx, errors);
		}
	}
	
	public static WebElement querySelector(SearchContext elem, String selector)
	{
		try
		{
			return elem.findElement(By.cssSelector(selector));
		}
		catch(Exception e)
		{
			return null;
		}
	}
	
	public static List<WebElement> querySelectorAll(SearchContext elem, String selector)
	{
		try
		{
			return elem.findElements(By.cssSelector(selector));
		}
		catch(Exception e)
		{
			return null;
		}
	}
	
	public static void clickSelectOption(WebDriver wd, String root, String name, String optionValue)
	{
		wd.findElement(By.cssSelector(root+" select[name='"+name+"']")).click();
		wd.findElement(By.cssSelector(root+" select[name='"+name+"'] option[value='"+optionValue+"']")).click();
	}
	
	public static void clickSelectOption(WebDriver wd, String selectSelector, String optionValue)
	{
		wd.findElement(By.cssSelector(selectSelector)).click();
		wd.findElement(By.cssSelector(selectSelector+" option[value='"+optionValue+"']")).click();
	}
	
	public static void clickRadio(WebDriver wd, String baseSelector, String name, String value)
	{
		wd.findElement(By.cssSelector(baseSelector+" input[name='"+name+"'][value='"+value+"']")).click();
	}
	
	public static void setCheckboxSelection(WebDriver wd, String cssSelector, boolean selected)
	{
		WebElement el = wd.findElement(By.cssSelector(cssSelector));
		if(el.isSelected() != selected)
		{
			el.click();
		}
	}
	
	public static boolean isAlertPresent(WebDriver env)
	{
		try
		{
			env.switchTo().alert();
			return true;
		}
		catch (Exception e)
		{
			return false;
		}
	}

	public static void clickSelector(WebDriver driver, String cssSelector)
	{
		driver.findElement(By.cssSelector(cssSelector)).click();
	}

	public static void setUploadedFile(WebDriver driver, String cssSelector, File file)
	{
		driver.findElement(By.cssSelector(cssSelector)).sendKeys(file.toString());
	}

	public static void goPath(WebDriverTestContext ctx, String url)
	{
		ctx.getWebDriver().navigate().to("http://"+ctx.getRootDomain()+"/"+url);
	}

	public static String getCookie(WebDriverTestContext ctx, String name)
	{
		return ctx.getWebDriver().manage().getCookieNamed(name).getValue();
	}

	public static void refresh(WebDriverTestContext ctx)
	{
		ctx.getWebDriver().navigate().refresh();
	}

	public static void destroy(WebDriverTestContext ctx)
	{
		ctx.getWebDriver().close();
	}
	
	public static int clickElementsWithText(WebDriver driver, String cssSelector, GetBy1<Boolean, String> test)
	{
		int c = 0;
		for(WebElement e:driver.findElements(By.cssSelector(cssSelector)))
		{
			if(Boolean.TRUE == test.getBy(e.getText()))
			{
				e.click();
				++c;
			}
		}
		return c;
	}
	
	public static boolean tryClickFirstElementsWithText(WebDriver driver, String cssSelector, GetBy1<Boolean, String> test)
	{
		for(WebElement e:driver.findElements(By.cssSelector(cssSelector)))
		{
			if(Boolean.TRUE == test.getBy(e.getText()))
			{
				e.click();
				return true;
			}
		}
		
		return false;
	}

	public static int tryClickElementsWithAttr
	(
		WebDriver driver,
		String cssSelector,
		String attrName,
		GetBy1<Boolean, String> value
	)
	{
		int c = 0;
		for(WebElement e:driver.findElements(By.cssSelector(cssSelector)))
		{
			String val = e.getAttribute(attrName);
			if(Boolean.TRUE == value.getBy(val))
			{
				e.click();
				++c;
			}
		}
		return c;

	}

	public static void setInputText(WebDriverTestContext ctx, String cssSelector, String value)
	{
		WebElement target = querySelector(ctx.getWebDriver(), cssSelector);
		if(null != target)
		{
			target.clear();
			target.sendKeys(value);
		}
	}

	public static boolean waitUntil(int waitMs, int waitCount, SimpleGet<Boolean> waitForTrue)
	{
		int w = 0;
		
		if(Boolean.TRUE == waitForTrue.get())
		{
			return true;
		}
		
		while(w < waitCount)
		{
			try
			{
				Thread.sleep(waitMs);
			}
			catch(Exception e)
			{
				Mirror.propagateAnyway(e);
			}
			
			if(Boolean.TRUE == waitForTrue.get())
			{
				return true;
			}
			
			++w;
		}
		
		return false;
	}
	
	public static boolean waitUntil(WebDriverTestContext ctx, SimpleGet<Boolean> waitForTrue)
	{
		return waitUntil(ctx.getPollWaitMilisec(), ctx.getPollWaitMaxCount(), waitForTrue);
	}
	
	public static void setUploadFileFromRepo(WebDriverTestContext ctx, String selector, String repoFile)
	{
		setUploadedFile(ctx.getWebDriver(), selector, new File(ctx.getTestAssetFileRoot()+"/"+repoFile));
	}

	public static boolean waitElementAppears(final WebDriverTestContext ctx, int waitMs, int waitCount, final String cssSelector)
	{
		return WebTestTools.waitUntil(100, 200, new SimpleGet<Boolean>()
		{
			@Override
			public Boolean get()
			{
				return null != WebTestTools.querySelector(ctx.getWebDriver(), cssSelector);
			}
		});
	}

	public static void waitComplete(final WebDriverTestContext env, int waitMs, int waitCount)
	{
		waitUntil(waitMs, waitCount, new SimpleGet<Boolean>()
		{
			@Override
			public Boolean get()
			{
				return Boolean.TRUE == ((JavascriptExecutor)env.getWebDriver()).executeScript("return document.readyState === \"complete\"");
			}
		}
		);
	}
	
	public static void waitToClickToOrDie(final WebDriverTestContext ctx, final String selector, String dieMessage)
	{
		waitToClickToOrDie(ctx, selector, ctx.getPollWaitMilisec(), ctx.getPollWaitMaxCount(), dieMessage);
	}
	
	public static void waitToClickToOrDie(final WebDriverTestContext ctx, final String selector, int waitMs, int waitCount, String dieMessage)
	{
		waitUntilOrDie
		(
			ctx,
			new SimpleGet<Boolean>()
			{
				@Override
				public Boolean get()
				{
					return null != querySelector(ctx.getWebDriver(), selector);
				}
			},
			dieMessage
		);
		
		clickSelector(ctx.getWebDriver(), selector);
	}

	public static String timeoutBlahBlah(WebDriverTestContext ctx)
	{
		return "after waiting "+ctx.getPollWaitMaxCount()+" times "+ctx.getPollWaitMilisec()+" ms.";
	}

	public static void waitUntilOrDie
	(
		WebDriverTestContext env,
		SimpleGet<Boolean> condition,
		int waitMs,
		int waitCount,
		String dieMessage
	)
	{
		if(!waitUntil(waitMs, waitCount, condition))
		{
			throw new RuntimeException(dieMessage);
		}
	}
	
	public static void waitUntilOrDie
	(
		WebDriverTestContext env,
		SimpleGet<Boolean> condition,
		String dieMessage
	)
	{
		waitUntilOrDie(env, condition, env.getPollWaitMilisec(), env.getPollWaitMaxCount(), dieMessage);
	}

	public static void waitComplete(WebDriverTestContext env)
	{
		waitComplete(env, env.getPollWaitMilisec(), env.getPollWaitMaxCount());
	}

	public static void clickSelector(WebDriverTestContext env, String cssSelector)
	{
		clickSelector(env.getWebDriver(), cssSelector);
	}

	public static WebElement querySelector(WebDriverTestContext env, String selector)
	{
		return querySelector(env.getWebDriver(), selector);
	}

	public static void click(WebDriverTestContext ctx, String selector)
	{
		ctx.getWebDriver().findElement(By.cssSelector(selector)).click();
	}
	
	public static void ensureElementExists(WebDriverTestContext ctx, String selector)
	{
		ctx.getWebDriver().findElement(By.cssSelector(selector));
	}
	
	public static void setContent(WebDriverTestContext ctx, String selector, String content)
	{
		WebElement elem = ctx.getWebDriver().findElement(By.cssSelector(selector));
		
		switch(elem.getTagName().toUpperCase())
		{
			case "TEXTAREA":
			case "INPUT":
			{
				String type = elem.getAttribute("type");
				if(null != type)
				{
					type = type.toLowerCase();
				}
				
				if("checkbox".equals(type))
				{
					elem.click();
					return;
				}
				else
				{
					elem.sendKeys(content);
				}
				break;
			}
			case "OPTION":
			{
				clickSelectOption(ctx.getWebDriver(), selector, content);
			}
			
			default: elem.sendKeys(content);break;
		}
		
	}

	public static void visit(WebDriverTestContext ctx, String url)
	{
		ctx.getWebDriver().navigate().to(url);
	}

	/*public static int getSelectionCheckedIndex(WebDriverTestContext env, String selector)
	{
		WebElement elem = querySelector(env.getWebDriver(), selector);
		
		if(null == elem)
		{
			throw new RuntimeException("");
		}
		
		if(!"select".equals(elem.getTagName().toLowerCase()))
		{
			
		}
		
		return 0;
	}*/
}
