/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webtest;

import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.webtest.WebDriverEnvConfig;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class WebDriverSource {
    protected WebDriverEnvConfig config;

    public WebDriverSource(WebDriverEnvConfig config) {
        this.config = config;
    }

    public WebDriver newDriver(AvailableWebDrivers drv, WebDriverConfiguration cfg) {
        switch (drv) {
            case Chrome: {
                return this.newChromeDriver(cfg);
            }
            case Firefox: {
                return this.newFirefoxDriver(cfg);
            }
            case HtmlUnit: {
                return this.newHtmlUnitDriver(cfg);
            }
        }
        throw new UnimplementedCaseException((Enum)drv);
    }

    public WebDriver newFirefoxDriver(WebDriverConfiguration cfg) {
        System.setProperty("webdriver.gecko.driver", this.config.geckoDrivePath);
        System.setProperty("webdriver.firefox.bin", this.config.firefoxBinPath);
        FirefoxOptions profile = new FirefoxOptions();
        if (null != cfg && null != cfg.proxy) {
            profile.setCapability("network.proxy.type", (Object)1);
            String addr = cfg.proxy.address().toString();
            String host = StringTools.getSubstringAfterFirstString((String)StringTools.getSubstringBeforeFirstString((String)addr, (String)":"), (String)"/");
            Integer port = ParsePrimitive.tryParseInt((String)StringTools.getSubstringAfterLastString((String)addr, (String)":"));
            profile.setCapability("network.proxy.http", host);
            profile.setCapability("network.proxy.http_port", (Object)port);
            profile.setCapability("network.proxy.socks", host);
            profile.setCapability("network.proxy.socks_port", (Object)port);
        }
        return new FirefoxDriver(profile);
    }

    public WebDriver newChromeDriver(WebDriverConfiguration cfg) {
        System.setProperty("webdriver.chrome.driver", this.config.chromeDrivePath);
        ChromeOptions options = new ChromeOptions();
        if (null != cfg) {
            Proxy p;
            if (null != cfg.proxy && (p = cfg.proxy).type() != Proxy.Type.DIRECT) {
                options.addArguments(new String[]{"--proxy-server=" + p.type().toString().toLowerCase() + "://" + p.address()});
            }
            if (cfg.headless) {
                options.addArguments(new String[]{"headless"});
            }
        }
        return new ChromeDriver(options);
    }

    public WebDriver newHtmlUnitDriver(WebDriverConfiguration cfg) {
        return new HtmlUnitDriver(true);
    }

    public static void main(String[] args) throws Throwable {
        WebDriverEnvConfig env = new WebDriverEnvConfig();
        WebDriverSource src = new WebDriverSource(env);
        WebDriverConfiguration cfg = new WebDriverConfiguration();
        cfg.proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(Inet4Address.getByName("127.0.0.1"), 9050));
        src.newFirefoxDriver(cfg);
        while (true) {
            Thread.sleep(50000L);
        }
    }

    public static class WebDriverConfiguration {
        public Proxy proxy;
        public boolean headless;
    }

    public static enum WebDriverOptions {
        Extension,
        Proxy;

    }

    public static enum AvailableWebDrivers {
        Chrome,
        Firefox,
        HtmlUnit;

    }
}

