/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webtest;

import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.webtest.PortalSupport;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;

public class WebDriverTestContext
implements ExternalDataAttached,
Closeable {
    protected WebDriver driver;
    protected String rootDomain;
    protected PortalSupport portalSupport;
    protected String testAssetFileRoot;
    protected int defaultPollWaitMs = 100;
    protected int defaultPollWaitCount = 200;
    protected Map<String, Object> extraData;

    public WebDriverTestContext(WebDriver driver, String rootDomain, PortalSupport ps, String testAssetFileRoot) {
        this.driver = driver;
        this.rootDomain = rootDomain;
        this.portalSupport = ps;
        this.testAssetFileRoot = testAssetFileRoot;
    }

    public int getPollWaitMilisec() {
        return this.defaultPollWaitMs;
    }

    public int getPollWaitMaxCount() {
        return this.defaultPollWaitCount;
    }

    public String getRootDomain() {
        return this.rootDomain;
    }

    public PortalSupport getPortalSupport() {
        return this.portalSupport;
    }

    public WebDriver getWebDriver() {
        return this.driver;
    }

    public String getTestAssetFileRoot() {
        return this.testAssetFileRoot;
    }

    public Map<String, Object> getExtraDataMap() {
        if (null == this.extraData) {
            this.extraData = new HashMap<String, Object>();
        }
        return this.extraData;
    }

    public Object getExtra(String key) {
        return this.getExtraDataMap().get(key);
    }

    public Object getExtra(Enum key) {
        return this.getExtraDataMap().get(key.name());
    }

    public String getExtraString(String key) {
        return StringTools.toStringOrNull((Object)this.getExtraDataMap().get(key));
    }

    public String getExtraString(Enum key) {
        return StringTools.toStringOrNull((Object)this.getExtraDataMap().get(key.name()));
    }

    public void destroy() {
        this.driver.quit();
    }

    @Override
    public void close() throws IOException {
        this.destroy();
    }

    public void closeOnExit() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                IOTools.silentClose((Closeable)WebDriverTestContext.this);
            }
        });
    }
}

