/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webtest;

import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.verify.WeightedValidationReportEntry;
import eu.javaexperience.webtest.WebDriverTestContext;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebTestTools {
    public static <T> void checkAfterEveryActor(WebDriverTestContext ctx, Collection<WeightedValidationReportEntry<T>> errors, SimplePublish2<WebDriverTestContext, Collection<WeightedValidationReportEntry<T>>> checker, SimplePublish1<WebDriverTestContext> ... actors) {
        for (SimplePublish1<WebDriverTestContext> act : actors) {
            act.publish((Object)ctx);
            checker.publish((Object)ctx, errors);
        }
    }

    public static WebElement querySelector(SearchContext elem, String selector) {
        try {
            return elem.findElement(By.cssSelector((String)selector));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<WebElement> querySelectorAll(SearchContext elem, String selector) {
        try {
            return elem.findElements(By.cssSelector((String)selector));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void clickSelectOption(WebDriver wd, String root, String name, String optionValue) {
        wd.findElement(By.cssSelector((String)(root + " select[name='" + name + "']"))).click();
        wd.findElement(By.cssSelector((String)(root + " select[name='" + name + "'] option[value='" + optionValue + "']"))).click();
    }

    public static void clickSelectOption(WebDriver wd, String selectSelector, String optionValue) {
        wd.findElement(By.cssSelector((String)selectSelector)).click();
        wd.findElement(By.cssSelector((String)(selectSelector + " option[value='" + optionValue + "']"))).click();
    }

    public static void clickRadio(WebDriver wd, String baseSelector, String name, String value) {
        wd.findElement(By.cssSelector((String)(baseSelector + " input[name='" + name + "'][value='" + value + "']"))).click();
    }

    public static void setCheckboxSelection(WebDriver wd, String cssSelector, boolean selected) {
        WebElement el = wd.findElement(By.cssSelector((String)cssSelector));
        if (el.isSelected() != selected) {
            el.click();
        }
    }

    public static boolean isAlertPresent(WebDriver env) {
        try {
            env.switchTo().alert();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void clickSelector(WebDriver driver, String cssSelector) {
        driver.findElement(By.cssSelector((String)cssSelector)).click();
    }

    public static void setUploadedFile(WebDriver driver, String cssSelector, File file) {
        driver.findElement(By.cssSelector((String)cssSelector)).sendKeys(new CharSequence[]{file.toString()});
    }

    public static void goPath(WebDriverTestContext ctx, String url) {
        ctx.getWebDriver().navigate().to("http://" + ctx.getRootDomain() + "/" + url);
    }

    public static String getCookie(WebDriverTestContext ctx, String name) {
        return ctx.getWebDriver().manage().getCookieNamed(name).getValue();
    }

    public static void refresh(WebDriverTestContext ctx) {
        ctx.getWebDriver().navigate().refresh();
    }

    public static void destroy(WebDriverTestContext ctx) {
        ctx.getWebDriver().close();
    }

    public static int clickElementsWithText(WebDriver driver, String cssSelector, GetBy1<Boolean, String> test) {
        int c = 0;
        for (WebElement e : driver.findElements(By.cssSelector((String)cssSelector))) {
            if (Boolean.TRUE != test.getBy((Object)e.getText())) continue;
            e.click();
            ++c;
        }
        return c;
    }

    public static boolean tryClickFirstElementsWithText(WebDriver driver, String cssSelector, GetBy1<Boolean, String> test) {
        for (WebElement e : driver.findElements(By.cssSelector((String)cssSelector))) {
            if (Boolean.TRUE != test.getBy((Object)e.getText())) continue;
            e.click();
            return true;
        }
        return false;
    }

    public static int tryClickElementsWithAttr(WebDriver driver, String cssSelector, String attrName, GetBy1<Boolean, String> value) {
        int c = 0;
        for (WebElement e : driver.findElements(By.cssSelector((String)cssSelector))) {
            String val = e.getAttribute(attrName);
            if (Boolean.TRUE != value.getBy((Object)val)) continue;
            e.click();
            ++c;
        }
        return c;
    }

    public static void setInputText(WebDriverTestContext ctx, String cssSelector, String value) {
        WebElement target = WebTestTools.querySelector((SearchContext)ctx.getWebDriver(), cssSelector);
        if (null != target) {
            target.clear();
            target.sendKeys(new CharSequence[]{value});
        }
    }

    public static boolean waitUntil(int waitMs, int waitCount, SimpleGet<Boolean> waitForTrue) {
        if (Boolean.TRUE == waitForTrue.get()) {
            return true;
        }
        for (int w = 0; w < waitCount; ++w) {
            try {
                Thread.sleep(waitMs);
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
            }
            if (Boolean.TRUE != waitForTrue.get()) continue;
            return true;
        }
        return false;
    }

    public static boolean waitUntil(WebDriverTestContext ctx, SimpleGet<Boolean> waitForTrue) {
        return WebTestTools.waitUntil(ctx.getPollWaitMilisec(), ctx.getPollWaitMaxCount(), waitForTrue);
    }

    public static void setUploadFileFromRepo(WebDriverTestContext ctx, String selector, String repoFile) {
        WebTestTools.setUploadedFile(ctx.getWebDriver(), selector, new File(ctx.getTestAssetFileRoot() + "/" + repoFile));
    }

    public static boolean waitElementAppears(final WebDriverTestContext ctx, int waitMs, int waitCount, final String cssSelector) {
        return WebTestTools.waitUntil(100, 200, new SimpleGet<Boolean>(){

            public Boolean get() {
                return null != WebTestTools.querySelector((SearchContext)ctx.getWebDriver(), cssSelector);
            }
        });
    }

    public static void waitComplete(final WebDriverTestContext env, int waitMs, int waitCount) {
        WebTestTools.waitUntil(waitMs, waitCount, new SimpleGet<Boolean>(){

            public Boolean get() {
                return Boolean.TRUE == ((JavascriptExecutor)env.getWebDriver()).executeScript("return document.readyState === \"complete\"", new Object[0]);
            }
        });
    }

    public static void waitToClickToOrDie(WebDriverTestContext ctx, String selector, String dieMessage) {
        WebTestTools.waitToClickToOrDie(ctx, selector, ctx.getPollWaitMilisec(), ctx.getPollWaitMaxCount(), dieMessage);
    }

    public static void waitToClickToOrDie(final WebDriverTestContext ctx, final String selector, int waitMs, int waitCount, String dieMessage) {
        WebTestTools.waitUntilOrDie(ctx, new SimpleGet<Boolean>(){

            public Boolean get() {
                return null != WebTestTools.querySelector((SearchContext)ctx.getWebDriver(), selector);
            }
        }, dieMessage);
        WebTestTools.clickSelector(ctx.getWebDriver(), selector);
    }

    public static String timeoutBlahBlah(WebDriverTestContext ctx) {
        return "after waiting " + ctx.getPollWaitMaxCount() + " times " + ctx.getPollWaitMilisec() + " ms.";
    }

    public static void waitUntilOrDie(WebDriverTestContext env, SimpleGet<Boolean> condition, int waitMs, int waitCount, String dieMessage) {
        if (!WebTestTools.waitUntil(waitMs, waitCount, condition)) {
            throw new RuntimeException(dieMessage);
        }
    }

    public static void waitUntilOrDie(WebDriverTestContext env, SimpleGet<Boolean> condition, String dieMessage) {
        WebTestTools.waitUntilOrDie(env, condition, env.getPollWaitMilisec(), env.getPollWaitMaxCount(), dieMessage);
    }

    public static void waitComplete(WebDriverTestContext env) {
        WebTestTools.waitComplete(env, env.getPollWaitMilisec(), env.getPollWaitMaxCount());
    }

    public static void clickSelector(WebDriverTestContext env, String cssSelector) {
        WebTestTools.clickSelector(env.getWebDriver(), cssSelector);
    }

    public static WebElement querySelector(WebDriverTestContext env, String selector) {
        return WebTestTools.querySelector((SearchContext)env.getWebDriver(), selector);
    }

    public static void click(WebDriverTestContext ctx, String selector) {
        ctx.getWebDriver().findElement(By.cssSelector((String)selector)).click();
    }

    public static void ensureElementExists(WebDriverTestContext ctx, String selector) {
        ctx.getWebDriver().findElement(By.cssSelector((String)selector));
    }

    public static void setContent(WebDriverTestContext ctx, String selector, String content) {
        WebElement elem = ctx.getWebDriver().findElement(By.cssSelector((String)selector));
        switch (elem.getTagName().toUpperCase()) {
            case "TEXTAREA": 
            case "INPUT": {
                String type = elem.getAttribute("type");
                if (null != type) {
                    type = type.toLowerCase();
                }
                if ("checkbox".equals(type)) {
                    elem.click();
                    return;
                }
                elem.sendKeys(new CharSequence[]{content});
                break;
            }
            case "OPTION": {
                WebTestTools.clickSelectOption(ctx.getWebDriver(), selector, content);
            }
            default: {
                elem.sendKeys(new CharSequence[]{content});
            }
        }
    }

    public static void visit(WebDriverTestContext ctx, String url) {
        ctx.getWebDriver().navigate().to(url);
    }
}

