/*
 * Decompiled with CFR 0.152.
 */
package awt;

import awt.FullscreenOptions;
import doom.CommandVariable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.swing.JFrame;
import mochadoom.Engine;
import mochadoom.Loggers;

public class DoomFrame<Window extends Component>
extends JFrame
implements FullscreenOptions {
    private static final long serialVersionUID = -4130528877723831825L;
    private final Window content;
    private volatile Graphics2D g2d;
    final Supplier<? extends Image> imageSupplier;
    final FullscreenOptions.Dimension dim;
    private final boolean showFPS = Engine.getCVM().bool(CommandVariable.SHOWFPS);
    private long lastTime = System.currentTimeMillis();
    private int frames = 0;

    DoomFrame(FullscreenOptions.Dimension dim, Window content, Supplier<? extends Image> imageSupplier) throws HeadlessException {
        this.dim = dim;
        this.content = content;
        this.imageSupplier = imageSupplier;
        this.init();
    }

    private void init() {
        this.setFocusTraversalKeysEnabled(false);
        this.setDefaultCloseOperation(3);
        this.setTitle(Engine.getEngine().getWindowTitle(0.0));
    }

    public void turnOn() {
        this.add((Component)this.content);
        ((Component)this.content).setFocusTraversalKeysEnabled(false);
        if (this.content instanceof Container) {
            this.setContentPane((Container)this.content);
        } else {
            this.getContentPane().setPreferredSize(((Component)this.content).getPreferredSize());
        }
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
        this.requestFocus();
        ((Component)this.content).requestFocusInWindow();
    }

    public void renewGraphics() {
        Graphics2D localG2d = this.g2d;
        this.g2d = null;
        if (localG2d != null) {
            localG2d.dispose();
        }
    }

    public void update() {
        if (!((Component)this.content).isDisplayable()) {
            return;
        }
        Graphics2D localG2d = this.getGraphics2D();
        if (localG2d == null) {
            Loggers.getLogger(DoomFrame.class.getName()).log(Level.INFO, "Starting or switching fullscreen, have no Graphics2d yet, skipping paint");
        } else {
            this.draw(this.g2d, this.imageSupplier.get(), this.dim, this);
            if (this.showFPS) {
                ++this.frames;
                long now = System.currentTimeMillis();
                long lambda = now - this.lastTime;
                if (lambda >= 100L) {
                    this.setTitle(Engine.getEngine().getWindowTitle((double)this.frames * 1000.0 / (double)lambda));
                    this.frames = 0;
                    this.lastTime = now;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Graphics2D getGraphics2D() {
        Graphics2D localG2d = this.g2d;
        if (localG2d != null) return localG2d;
        Class<DoomFrame> clazz = DoomFrame.class;
        synchronized (DoomFrame.class) {
            localG2d = this.g2d;
            if (localG2d != null) return localG2d;
            this.g2d = localG2d = (Graphics2D)((Component)this.content).getGraphics();
            localG2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            localG2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            localG2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localG2d;
        }
    }
}

