/*
 * Decompiled with CFR 0.152.
 */
package awt;

import awt.DoomWindowController;
import awt.EventHandler;
import doom.CommandVariable;
import doom.event_t;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JPanel;
import mochadoom.Engine;

public interface DoomWindow<E extends Component> {
    public static GraphicsDevice getDefaultDevice() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    public static DoomWindowController<CanvasWindow, EventHandler> createCanvasWindowController(Supplier<Image> imageSource, Consumer<? super event_t> doomEventConsume, int width, int height) {
        GraphicsDevice device = DoomWindow.getDefaultDevice();
        return new DoomWindowController<CanvasWindow, EventHandler>(EventHandler.class, device, imageSource, doomEventConsume, new CanvasWindow(DoomWindow.getDefaultDevice().getDefaultConfiguration()), width, height);
    }

    public static DoomWindowController<JPanelWindow, EventHandler> createJPanelWindowController(Supplier<Image> imageSource, Consumer<? super event_t> doomEventConsume, int width, int height) {
        return new DoomWindowController<JPanelWindow, EventHandler>(EventHandler.class, DoomWindow.getDefaultDevice(), imageSource, doomEventConsume, new JPanelWindow(), width, height);
    }

    default public boolean handleGeom() {
        int x = 0;
        int y = 0;
        int xsign = 32;
        int ysign = 32;
        if (Engine.getCVM().present(CommandVariable.GEOM)) {
            try {
                String eval = Engine.getCVM().get(CommandVariable.GEOM, String.class, 0).get().trim();
                StringTokenizer tk = new StringTokenizer(eval, "-+ ");
                xsign = 1;
                ysign = 1;
                for (int i = 0; i < eval.length(); ++i) {
                    if (eval.charAt(i) != '-') continue;
                    if (i == 0) {
                        xsign = -1;
                        continue;
                    }
                    ysign = -1;
                }
                if (tk.countTokens() == 2) {
                    x = xsign * Integer.parseInt(tk.nextToken());
                    y = ysign * Integer.parseInt(tk.nextToken());
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static final class CanvasWindow
    extends Canvas
    implements DoomWindow<CanvasWindow> {
        private static final long serialVersionUID = 1180777361390303859L;

        private CanvasWindow(GraphicsConfiguration config) {
            super(config);
        }
    }

    public static final class JPanelWindow
    extends JPanel
    implements DoomWindow<JPanelWindow> {
        private static final long serialVersionUID = 4031722796186278753L;

        private JPanelWindow() {
            this.init();
        }

        private void init() {
            this.setDoubleBuffered(true);
            this.setOpaque(true);
            this.setBackground(Color.BLACK);
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    }
}

