/*
 * Decompiled with CFR 0.152.
 */
package awt;

import awt.EventBase;
import awt.EventObserver;
import g.Signals;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public enum EventHandler implements EventBase<EventHandler>
{
    KEY_PRESS(401, mapper -> {
        mapper.map(EventBase.ActionMode.REVERT, EventObserver::cancelKeys);
        mapper.map(EventBase.ActionMode.PERFORM, EventObserver::sendKeyDowns);
        mapper.map(EventBase.ActionMode.DEPEND, (observer, event) -> {
            if (Signals.getScanCode((KeyEvent)event) == Signals.ScanCode.SC_PRTSCRN) {
                observer.feed(Signals.ScanCode.SC_PRTSCRN.doomEventDown);
            }
        });
    }, EventBase.ActionMode.REVERT, EventBase.ActionMode.PERFORM, EventBase.ActionMode.DEPEND),
    KEY_RELEASE(402, mapper -> mapper.map(EventBase.ActionMode.PERFORM, EventObserver::sendKeyUps), EventBase.ActionMode.PERFORM),
    KEY_TYPE(400, mapper -> mapper.map(EventBase.ActionMode.PERFORM, EventObserver::sendKeyUps), EventBase.ActionMode.PERFORM),
    MOUSE_PRESS(501, mapper -> {
        mapper.map(EventBase.ActionMode.REVERT, EventObserver::cancelMouse);
        mapper.map(EventBase.ActionMode.PERFORM, (observer, ev) -> {
            observer.mouseEvent.buttonOn((MouseEvent)ev);
            observer.mouseEvent.y = 0;
            observer.mouseEvent.x = 0;
            if (observer.mouseEvent.processed) {
                observer.mouseEvent.resetNotify();
                observer.feed(observer.mouseEvent);
            }
        });
    }, EventBase.ActionMode.REVERT, EventBase.ActionMode.PERFORM),
    MOUSE_RELEASE(502, mapper -> mapper.map(EventBase.ActionMode.PERFORM, (observer, ev) -> {
        observer.mouseEvent.buttonOff((MouseEvent)ev);
        observer.mouseEvent.y = 0;
        observer.mouseEvent.x = 0;
        if (observer.mouseEvent.processed) {
            observer.mouseEvent.resetNotify();
            observer.feed(observer.mouseEvent);
        }
    }), EventBase.ActionMode.PERFORM),
    MOUSE_CLICK(500, mapper -> mapper.map(EventBase.ActionMode.PERFORM, EventObserver::centreCursor), new EventBase.ActionMode[0]),
    MOUSE_MOVE(503, mapper -> mapper.map(EventBase.ActionMode.PERFORM, EventHandler.mouseMoveAction(false)), EventBase.ActionMode.PERFORM),
    MOUSE_DRAG(506, mapper -> mapper.map(EventBase.ActionMode.PERFORM, EventHandler.mouseMoveAction(true)), EventBase.ActionMode.PERFORM),
    WINDOW_ACTIVATE(205, EventBase.ActionMode.PERFORM, EventBase.ActionMode.CAUSE),
    WINDOW_DEICONIFY(204, EventBase.ActionMode.PERFORM),
    COMPONENT_RESIZE(101, EventBase.ActionMode.PERFORM),
    MOUSE_ENTER(504, mapper -> mapper.map(EventBase.ActionMode.PERFORM, EventObserver::centreCursor), new EventBase.ActionMode[0]),
    WINDOW_OPEN(200, mapper -> mapper.map(EventBase.ActionMode.PERFORM, EventObserver::centreCursor), EventBase.ActionMode.PERFORM),
    WINDOW_GAIN_FOCUS(207, new EventBase.ActionMode[0]),
    WINDOW_LOSE_FOCUS(208, mapper -> mapper.map(EventBase.ActionMode.PERFORM, EventObserver::restoreCursor), EventBase.ActionMode.PERFORM),
    COMPONENT_MOVE(100, EventBase.ActionMode.PERFORM),
    MOUSE_EXIT(505, EventBase.ActionMode.PERFORM),
    RELATIONS(relationMapper -> {
        relationMapper.map(EventBase.RelationType.DEPEND, EventBase.Relate((Enum)KEY_RELEASE, (Enum[])new EventHandler[]{KEY_PRESS}));
        relationMapper.map(EventBase.RelationType.DISABLE, EventBase.Relate((Enum)WINDOW_OPEN, (Enum[])new EventHandler[]{WINDOW_OPEN}));
        relationMapper.map(EventBase.RelationType.ENABLE, EventBase.Relate((Enum)WINDOW_OPEN, (Enum[])new EventHandler[]{WINDOW_LOSE_FOCUS, KEY_PRESS, KEY_RELEASE, KEY_TYPE, MOUSE_ENTER, MOUSE_MOVE, MOUSE_DRAG, MOUSE_PRESS, MOUSE_RELEASE}));
        relationMapper.map(EventBase.RelationType.CAUSE, EventBase.Relate((Enum)WINDOW_ACTIVATE, (Enum[])new EventHandler[]{WINDOW_ACTIVATE}));
        relationMapper.map(EventBase.RelationType.CAUSE, EventBase.Relate((Enum)WINDOW_DEICONIFY, (Enum[])new EventHandler[]{WINDOW_ACTIVATE}));
        relationMapper.map(EventBase.RelationType.CAUSE, EventBase.Relate((Enum)COMPONENT_RESIZE, (Enum[])new EventHandler[]{WINDOW_ACTIVATE}));
        relationMapper.map(EventBase.RelationType.REVERT, EventBase.Relate((Enum)WINDOW_LOSE_FOCUS, (Enum[])new EventHandler[]{KEY_PRESS, MOUSE_PRESS}));
        relationMapper.map(EventBase.RelationType.DISABLE, EventBase.Relate((Enum)WINDOW_LOSE_FOCUS, (Enum[])new EventHandler[]{WINDOW_LOSE_FOCUS, KEY_PRESS, KEY_RELEASE, KEY_TYPE, MOUSE_MOVE, MOUSE_DRAG, MOUSE_PRESS, MOUSE_RELEASE, MOUSE_ENTER}));
        relationMapper.map(EventBase.RelationType.ENABLE, EventBase.Relate((Enum)WINDOW_LOSE_FOCUS, (Enum[])new EventHandler[]{WINDOW_GAIN_FOCUS, MOUSE_CLICK}));
        relationMapper.map(EventBase.RelationType.ENABLE, EventBase.Relate((Enum)MOUSE_CLICK, (Enum[])new EventHandler[]{WINDOW_LOSE_FOCUS, KEY_PRESS, KEY_RELEASE, KEY_TYPE, MOUSE_ENTER, MOUSE_MOVE, MOUSE_DRAG, MOUSE_PRESS, MOUSE_RELEASE}));
        relationMapper.map(EventBase.RelationType.DISABLE, EventBase.Relate((Enum)MOUSE_CLICK, (Enum[])new EventHandler[]{WINDOW_GAIN_FOCUS, MOUSE_CLICK}));
        relationMapper.map(EventBase.RelationType.ENABLE, EventBase.Relate((Enum)WINDOW_GAIN_FOCUS, (Enum[])new EventHandler[]{WINDOW_LOSE_FOCUS, KEY_PRESS, KEY_RELEASE, KEY_TYPE, MOUSE_ENTER}));
        relationMapper.map(EventBase.RelationType.DISABLE, EventBase.Relate((Enum)WINDOW_GAIN_FOCUS, (Enum[])new EventHandler[]{WINDOW_GAIN_FOCUS}));
        relationMapper.map(EventBase.RelationType.ENABLE, EventBase.Relate((Enum)MOUSE_ENTER, (Enum[])new EventHandler[]{MOUSE_MOVE, MOUSE_DRAG, MOUSE_PRESS, MOUSE_RELEASE}));
        relationMapper.map(EventBase.RelationType.DISABLE, EventBase.Relate((Enum)MOUSE_ENTER, (Enum[])new EventHandler[]{MOUSE_ENTER}));
        relationMapper.map(EventBase.RelationType.DISABLE, EventBase.Relate((Enum)COMPONENT_MOVE, (Enum[])new EventHandler[]{MOUSE_MOVE, MOUSE_DRAG, MOUSE_PRESS, MOUSE_RELEASE, MOUSE_ENTER}));
        relationMapper.map(EventBase.RelationType.ENABLE, EventBase.Relate((Enum)COMPONENT_MOVE, (Enum[])new EventHandler[]{MOUSE_CLICK}));
    });

    final int eventId;
    final Set<EventBase.ActionMode> enabled;
    final Map<EventBase.ActionMode, EventBase.EventAction<EventHandler>> actions;
    final Map<EventBase.RelationType, Set<EventHandler>> adjustments;
    final Map<EventBase.RelationType, Set<EventHandler>> cooperations;

    public static void menuCaptureChanges(EventObserver<EventHandler> observer, boolean capture) {
        if (capture) {
            observer.enableAction(MOUSE_MOVE, EventBase.ActionMode.PERFORM);
            observer.enableAction(MOUSE_DRAG, EventBase.ActionMode.PERFORM);
            observer.enableAction(MOUSE_PRESS, EventBase.ActionMode.PERFORM);
            observer.enableAction(MOUSE_RELEASE, EventBase.ActionMode.PERFORM);
            observer.enableAction(MOUSE_ENTER, EventBase.ActionMode.PERFORM);
            observer.disableAction(MOUSE_CLICK, EventBase.ActionMode.PERFORM);
            observer.centreCursor(null);
        } else {
            observer.disableAction(MOUSE_MOVE, EventBase.ActionMode.PERFORM);
            observer.disableAction(MOUSE_DRAG, EventBase.ActionMode.PERFORM);
            observer.disableAction(MOUSE_PRESS, EventBase.ActionMode.PERFORM);
            observer.disableAction(MOUSE_RELEASE, EventBase.ActionMode.PERFORM);
            observer.disableAction(MOUSE_ENTER, EventBase.ActionMode.PERFORM);
            observer.enableAction(MOUSE_CLICK, EventBase.ActionMode.PERFORM);
            observer.restoreCursor(null);
        }
    }

    public static void fullscreenChanges(EventObserver<EventHandler> observer, boolean fullscreen) {
        observer.cancelKeys(null);
        if (fullscreen) {
            observer.mapRelation(COMPONENT_RESIZE, EventBase.RelationType.ENABLE, new EventHandler[]{WINDOW_OPEN, WINDOW_LOSE_FOCUS, KEY_PRESS, KEY_RELEASE, KEY_TYPE, MOUSE_ENTER, MOUSE_MOVE, MOUSE_DRAG, MOUSE_PRESS, MOUSE_RELEASE});
            observer.disableAction(COMPONENT_MOVE, EventBase.ActionMode.PERFORM);
        } else {
            observer.unmapRelation(COMPONENT_RESIZE, EventBase.RelationType.ENABLE, new EventHandler[0]);
            observer.disableAction(WINDOW_LOSE_FOCUS, EventBase.ActionMode.PERFORM);
            observer.disableAction(COMPONENT_MOVE, EventBase.ActionMode.PERFORM);
            observer.mapAction(WINDOW_ACTIVATE, EventBase.ActionMode.PERFORM, (ob, ev) -> {
                observer.unmapAction(WINDOW_ACTIVATE, EventBase.ActionMode.PERFORM);
                observer.enableAction(WINDOW_LOSE_FOCUS, EventBase.ActionMode.PERFORM);
                observer.enableAction(COMPONENT_MOVE, EventBase.ActionMode.PERFORM);
            });
        }
    }

    private static EventBase.EventAction<EventHandler> mouseMoveAction(boolean isDrag) {
        return (observer, ev) -> {
            if (observer.mouseEvent.robotMove) {
                observer.mouseEvent.robotMove = false;
                return;
            }
            int centreX = observer.component.getWidth() >> 1;
            int centreY = observer.component.getHeight() >> 1;
            if (observer.component.isShowing() && EventObserver.MOUSE_ROBOT.isPresent()) {
                Point offset = observer.component.getLocationOnScreen();
                observer.mouseEvent.moveIn((MouseEvent)ev, EventObserver.MOUSE_ROBOT.get(), offset, centreX, centreY, isDrag);
            } else {
                observer.mouseEvent.moveIn((MouseEvent)ev, centreX, centreY, isDrag);
            }
            if (observer.mouseEvent.processed) {
                observer.mouseEvent.resetNotify();
                observer.feed(observer.mouseEvent);
            }
        };
    }

    private EventHandler(Consumer<EventBase.RelationMapper<EventHandler>> relationMapper) {
        this.eventId = -1;
        this.actions = Collections.emptyMap();
        this.adjustments = Collections.emptyMap();
        this.cooperations = Collections.emptyMap();
        this.enabled = Collections.emptySet();
        relationMapper.accept((type, relations) -> Stream.of(relations).forEach(relation -> (type.affection == EventBase.RelationAffection.COOPERATES ? ((EventHandler)relation.sourceHandler).cooperations : ((EventHandler)relation.sourceHandler).adjustments).compute(type, (t, set) -> {
            (set == null ? (set = new HashSet()) : set).add(relation.targetHandler);
            return set;
        })));
    }

    private EventHandler(int eventId, EventBase.ActionMode ... enableModes) {
        this(eventId, (Consumer<EventBase.ActionMapper<EventHandler>>)null, enableModes);
    }

    private EventHandler(int eventId, Consumer<EventBase.ActionMapper<EventHandler>> actionMapper, EventBase.ActionMode ... enableModes) {
        this.eventId = eventId;
        this.actions = new EnumMap<EventBase.ActionMode, EventBase.EventAction<EventHandler>>(EventBase.ActionMode.class);
        this.enabled = EnumSet.noneOf(EventBase.ActionMode.class);
        this.enabled.addAll(Arrays.asList(enableModes));
        this.adjustments = new EnumMap<EventBase.RelationType, Set<EventHandler>>(EventBase.RelationType.class);
        this.cooperations = new EnumMap<EventBase.RelationType, Set<EventHandler>>(EventBase.RelationType.class);
        if (actionMapper != null) {
            actionMapper.accept(this.actions::put);
        }
    }

    @Override
    public Set<EventBase.ActionMode> defaultEnabledActions() {
        return this.enabled;
    }

    @Override
    public Map<EventBase.ActionMode, EventBase.EventAction<EventHandler>> allActions() {
        return this.actions;
    }

    @Override
    public Map<EventBase.RelationType, Set<EventHandler>> cooperations() {
        return this.cooperations;
    }

    @Override
    public Map<EventBase.RelationType, Set<EventHandler>> adjustments() {
        return this.adjustments;
    }

    @Override
    public int getAsInt() {
        return this.eventId;
    }
}

