/*
 * Decompiled with CFR 0.152.
 */
package boom;

import boom.mapnode_v4_t;
import boom.mapseg_znod_t;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import utils.GenericCopy;
import w.CacheableDoomObject;

public class ZNodeSegs
implements CacheableDoomObject {
    private static final byte[] DeepBSPHeader = new byte[]{120, 78, 100, 52, 0, 0, 0, 0};
    byte[] header;
    mapseg_znod_t[] nodes;
    int numnodes;

    public boolean formatOK() {
        return Arrays.equals(this.header, DeepBSPHeader);
    }

    public mapseg_znod_t[] getNodes() {
        return this.nodes;
    }

    @Override
    public void unpack(ByteBuffer buf) throws IOException {
        int length = buf.capacity();
        if (length < 8) {
            return;
        }
        this.numnodes = (length - 8) / mapnode_v4_t.sizeOf();
        if (length < 1) {
            return;
        }
        buf.get(this.header);
        this.nodes = (mapseg_znod_t[])GenericCopy.malloc(mapseg_znod_t::new, mapseg_znod_t[]::new, length);
        for (int i = 0; i < length; ++i) {
            this.nodes[i].unpack(buf);
        }
    }
}

