/*
 * Decompiled with CFR 0.152.
 */
package data;

public final class Tables {
    public static final String rcsid = "$Id:";
    public static final double PI = 3.141592657;
    public static final int BITSPRECISION = 12;
    public static final int FINEANGLES = 8192;
    public static final int FINETANS = 4096;
    public static final int QUARTERMARK = 2048;
    public static final int FINEMASK = 8191;
    public static final long ANGLEMODULE = 0x100000000L;
    public static final long BITS32 = 0xFFFFFFFFL;
    public static final int BITS31 = Integer.MAX_VALUE;
    public static final int ANGLETOFINESHIFT = 19;
    public static final long ANG45 = 0x20000000L;
    public static final long ANG90 = 0x40000000L;
    public static final long ANG180 = 0x80000000L;
    public static final long ANG270 = 0xC0000000L;
    public static final int SLOPERANGE = 2048;
    public static final int SLOPEBITS = 11;
    public static final int DBITS = 5;
    public static final int[] finesine = new int[10240];
    public static final int[] finecosine = new int[8192];
    public static final int[] finetangent = new int[8192];
    public static final int[] tantoangle = new int[2049];

    public static final int SlopeDiv(long num, long den) {
        if (den < 512L) {
            return 2048;
        }
        int ans = (int)((num << 3) / (den >>> 8));
        return ans <= 2048 ? ans : 2048;
    }

    public static final int finesine(int angle) {
        return finesine[angle >>> 19];
    }

    public static final int finesine(long angle) {
        return finesine[(int)((angle & 0xFFFFFFFFL) >>> 19)];
    }

    public static final int finecosine(int angle) {
        return finecosine[angle >>> 19];
    }

    public static final int finecosine(long angle) {
        return finecosine[(int)((angle & 0xFFFFFFFFL) >>> 19)];
    }

    public static final boolean GE(int bam0, int bam1) {
        if (bam0 == bam1) {
            return true;
        }
        if (bam0 < 0 && bam1 >= 0) {
            return true;
        }
        if (bam0 >= 0 && bam1 < 0) {
            return false;
        }
        return (bam0 &= Integer.MAX_VALUE) > (bam1 &= Integer.MAX_VALUE);
    }

    public static final boolean GT(int bam0, int bam1) {
        if (bam0 < 0 && bam1 >= 0) {
            return true;
        }
        if (bam0 >= 0 && bam1 < 0) {
            return false;
        }
        return (bam0 &= Integer.MAX_VALUE) > (bam1 &= Integer.MAX_VALUE);
    }

    public static final int BAMDiv(int bam0, int bam1) {
        if (bam0 >= 0) {
            return bam0 / bam1;
        }
        if (bam1 >= 0) {
            return (int)((0xFFFFFFFFL & (long)bam0) / (long)bam1);
        }
        return (int)((0xFFFFFFFFL & (long)bam0) / (0xFFFFFFFFL & (long)bam1));
    }

    public static final int toBAMIndex(long angle) {
        return (int)((angle & 0xFFFFFFFFL) >>> 19);
    }

    public static final int toFineTanIndex(long angle) {
        return (int)((angle & Integer.MAX_VALUE) >>> 19);
    }

    public static final int toBAMIndex(int angle) {
        return angle >>> 19;
    }

    public static final long addAngles(long a, long b) {
        return a + b & 0xFFFFFFFFL;
    }

    public static void InitTables() {
        int t;
        float a;
        int i;
        for (i = 0; i < 4096; ++i) {
            a = (float)(((double)(i - 2048) + 0.5) * 3.141592657 * 2.0) / 8192.0f;
            float fv = (float)(65536.0 * Math.tan(a));
            Tables.finetangent[i] = t = (int)fv;
        }
        for (i = 0; i < 10240; ++i) {
            a = (float)(((double)i + 0.5) * 3.141592657 * 2.0) / 8192.0f;
            Tables.finesine[i] = t = (int)(65536.0 * Math.sin(a));
            if (i < 2048) continue;
            Tables.finecosine[i - 2048] = t;
        }
        for (i = 4096; i < 8192; ++i) {
            Tables.finetangent[i] = finesine[i - 4096];
        }
        for (i = 0; i <= 2048; ++i) {
            a = (float)(Math.atan((double)i / 2048.0) / 6.283185314);
            Tables.tantoangle[i] = t = (int)(4.2949673E9f * a);
        }
    }

    private Tables() {
    }
}

