/*
 * Decompiled with CFR 0.152.
 */
package defines;

import defines.GameMode;
import defines.Language_t;
import doom.DoomMain;
import java.util.logging.Level;
import mochadoom.Loggers;
import utils.C2JUtils;

public enum DoomVersion {
    DOOM2F_WAD("doom2f.wad"),
    DOOM2_WAD("doom2.wad"),
    PLUTONIA_WAD("plutonia.wad"),
    TNT_WAD("tnt.wad"),
    XBLA_WAD("xbla.wad"),
    DOOMU_WAD("doomu.wad"),
    UDOOM_WAD("udoom.wad"),
    DOOM_WAD("doom.wad"),
    DOOM1_WAD("doom1.wad"),
    FREEDM_WAD("freedm.wad"),
    FREEDOOM1_WAD("freedoom1.wad"),
    FREEDOOM2_WAD("freedoom2.wad");

    public final String wadFileName;

    private DoomVersion(String wadFileName) {
        this.wadFileName = wadFileName;
    }

    public static String tryAllWads(DoomMain<?, ?> DOOM, String doomwaddir) {
        for (DoomVersion v : DoomVersion.values()) {
            String vFullPath = doomwaddir + '/' + v.wadFileName;
            if (!C2JUtils.testReadAccess(vFullPath)) continue;
            DOOM.setGameMode(GameMode.forVersion(v));
            if (v == DOOM2F_WAD) {
                DOOM.language = Language_t.french;
                System.out.println("French version\n");
            }
            return vFullPath;
        }
        return null;
    }

    public static GameMode tryOnlyOne(String iwad, String doomwaddir) {
        try {
            DoomVersion v = DoomVersion.valueOf(iwad.trim().toUpperCase().replace('.', '_'));
            GameMode tmp = GameMode.forVersion(v);
            if (tmp != null && C2JUtils.testReadAccess(doomwaddir + iwad)) {
                return tmp;
            }
        }
        catch (IllegalArgumentException ex) {
            Loggers.getLogger(DoomVersion.class.getName()).log(Level.WARNING, iwad, ex);
        }
        return null;
    }
}

