/*
 * Decompiled with CFR 0.152.
 */
package defines;

import defines.DoomVersion;
import doom.CommandVariable;

public enum GameMode {
    shareware("data_se", DoomVersion.DOOM1_WAD, CommandVariable.SHDEV),
    registered("data_se", DoomVersion.DOOM_WAD, CommandVariable.REGDEV),
    commercial("cdata", DoomVersion.DOOM2_WAD, CommandVariable.COMDEV),
    retail("data_se", DoomVersion.DOOMU_WAD, CommandVariable.REGDEV),
    pack_tnt("cdata", DoomVersion.TNT_WAD, CommandVariable.COMDEV),
    pack_plut("cdata", DoomVersion.PLUTONIA_WAD, CommandVariable.COMDEV),
    pack_xbla("cdata", DoomVersion.XBLA_WAD, CommandVariable.COMDEV),
    freedm("cdata", DoomVersion.FREEDM_WAD, CommandVariable.FRDMDEV),
    freedoom1("data_se", DoomVersion.FREEDOOM1_WAD, CommandVariable.FR1DEV),
    freedoom2("cdata", DoomVersion.FREEDOOM2_WAD, CommandVariable.FR2DEV),
    indetermined("data_se", null, null);

    public final String devDir;
    public final DoomVersion version;
    public final CommandVariable devVar;

    public static GameMode forVersion(DoomVersion v) {
        switch (v) {
            case DOOM1_WAD: {
                return shareware;
            }
            case DOOM2F_WAD: 
            case DOOM2_WAD: {
                return commercial;
            }
            case DOOMU_WAD: 
            case UDOOM_WAD: {
                return retail;
            }
            case DOOM_WAD: {
                return registered;
            }
            case FREEDM_WAD: {
                return freedm;
            }
            case FREEDOOM1_WAD: {
                return freedoom1;
            }
            case FREEDOOM2_WAD: {
                return freedoom2;
            }
            case PLUTONIA_WAD: {
                return pack_plut;
            }
            case TNT_WAD: {
                return pack_tnt;
            }
            case XBLA_WAD: {
                return pack_xbla;
            }
        }
        return null;
    }

    private GameMode(String devDir, DoomVersion version, CommandVariable devVar) {
        this.devDir = devDir;
        this.version = version;
        this.devVar = devVar;
    }

    public boolean hasTexture2() {
        return this != shareware && this != freedoom2 && this != commercial;
    }
}

