/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.IDemoTicCmd;
import doom.ticcmd_t;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import utils.C2JUtils;
import w.CacheableDoomObject;
import w.IWritableDoomObject;

public class VanillaTiccmd
implements CacheableDoomObject,
IDemoTicCmd,
IWritableDoomObject {
    public byte forwardmove;
    public byte sidemove;
    public byte angleturn;
    public byte buttons;
    private static StringBuilder sb = new StringBuilder();

    @Override
    public void unpack(ByteBuffer f) throws IOException {
        this.forwardmove = f.get();
        this.sidemove = f.get();
        this.angleturn = f.get();
        this.buttons = f.get();
    }

    public void pack(ByteBuffer f) throws IOException {
        f.put(this.forwardmove);
        f.put(this.sidemove);
        f.put(this.angleturn);
        f.put(this.buttons);
    }

    public String toString() {
        sb.setLength(0);
        sb.append(" forwardmove ");
        sb.append(this.forwardmove);
        sb.append(" sidemove ");
        sb.append(this.sidemove);
        sb.append(" angleturn ");
        sb.append(this.angleturn);
        sb.append(" buttons ");
        sb.append(Integer.toHexString(this.buttons));
        return sb.toString();
    }

    @Override
    public void decode(ticcmd_t dest) {
        dest.forwardmove = this.forwardmove;
        dest.sidemove = this.sidemove;
        dest.angleturn = (short)(this.angleturn << 8);
        dest.buttons = (char)C2JUtils.toUnsignedByte(this.buttons);
    }

    @Override
    public void encode(ticcmd_t source) {
        this.forwardmove = source.forwardmove;
        this.sidemove = source.sidemove;
        this.angleturn = (byte)(source.angleturn >>> 8);
        this.buttons = (byte)(source.buttons & 0xFF);
    }

    @Override
    public void write(DataOutputStream f) throws IOException {
        f.writeByte(this.forwardmove);
        f.writeByte(this.sidemove);
        f.writeByte(this.angleturn);
        f.writeByte(this.buttons);
    }
}

