/*
 * Decompiled with CFR 0.152.
 */
package doom;

public enum CommandVariable {
    DISP(String.class),
    GEOM(String[].class),
    CONFIG(String[].class),
    TRANMAP(String.class),
    PLAYDEMO(String.class),
    FASTDEMO(String.class),
    TIMEDEMO(String.class),
    RECORD(String.class),
    STATCOPY(String.class),
    TURBO(Integer.class),
    SKILL(Integer.class),
    EPISODE(Integer.class),
    TIMER(Integer.class),
    PORT(Integer.class),
    MULTIPLY(Integer.class),
    WIDTH(Integer.class),
    HEIGHT(Integer.class),
    PARALLELRENDERER(Integer.class, Integer.class, Integer.class),
    PARALLELRENDERER2(Integer.class, Integer.class, Integer.class),
    LOADGAME(Character.class),
    DUP(Character.class),
    NET(Character.class, String[].class),
    WART(Integer.class, Integer.class),
    WARP(WarpFormat.class),
    MAP('+', MapFormat.class),
    FILE(String[].class),
    IWAD(String.class),
    NOVERT(ForbidFormat.class),
    NOVOLATILEIMAGE(ForbidFormat.class),
    AWTFRAME(new Class[0]),
    DEBUGFILE(new Class[0]),
    SHDEV(new Class[0]),
    REGDEV(new Class[0]),
    FRDMDEV(new Class[0]),
    FR1DEV(new Class[0]),
    FR2DEV(new Class[0]),
    COMDEV(new Class[0]),
    NOMONSTERS(new Class[0]),
    RESPAWN(new Class[0]),
    FAST(new Class[0]),
    DEVPARM(new Class[0]),
    ALTDEATH(new Class[0]),
    DEATHMATCH(new Class[0]),
    MILLIS(new Class[0]),
    FASTTIC(new Class[0]),
    CDROM(new Class[0]),
    AVG(new Class[0]),
    NODRAW(new Class[0]),
    NOBLIT(new Class[0]),
    NOPLAYPAL(new Class[0]),
    NOCOLORMAP(new Class[0]),
    SERIALRENDERER(new Class[0]),
    EXTRATIC(new Class[0]),
    NOMUSIC(new Class[0]),
    NOSOUND(new Class[0]),
    NOSFX(new Class[0]),
    AUDIOLINES(new Class[0]),
    SPEAKERSOUND(new Class[0]),
    CLIPSOUND(new Class[0]),
    CLASSICSOUND(new Class[0]),
    INDEXED(new Class[0]),
    HICOLOR(new Class[0]),
    TRUECOLOR(new Class[0]),
    ALPHATRUECOLOR(new Class[0]),
    BLOCKMAP(new Class[0]),
    SHOWFPS(new Class[0]),
    JAVARANDOM(new Class[0]),
    GREYPAL(new Class[0]);

    public final char prefix;
    public final Class<?>[] arguments;
    public static final int MIN_CVAR_LENGTH = 4;

    private CommandVariable(char prefix, Class<?> ... arguments) {
        this.prefix = prefix;
        this.arguments = arguments;
    }

    private CommandVariable(Class<?> ... arguments) {
        this('-', arguments);
    }

    public Type getType() {
        return this.arguments.length > 0 ? (this.arguments[this.arguments.length - 1].isArray() ? Type.VARARG : Type.PARAMETER) : Type.SWITCH;
    }

    public static class MapFormat {
        final String mapString;

        public MapFormat(String mapString) {
            this.mapString = mapString.toLowerCase();
        }

        protected int parseAsMapXX() {
            int map;
            if (this.mapString.length() != 5 || this.mapString.lastIndexOf("map") != 0) {
                return -1;
            }
            try {
                map = Integer.parseInt(this.mapString.substring(3));
            }
            catch (NumberFormatException e) {
                return -1;
            }
            return map;
        }

        protected int parseAsExMx() {
            if (this.mapString.length() != 4 || this.mapString.charAt(0) != 'e' || this.mapString.charAt(2) != 'm') {
                return -1;
            }
            char episode = this.mapString.charAt(1);
            char mission = this.mapString.charAt(3);
            if (episode < '0' || episode > '9' || mission < '0' || mission > '9') {
                return -1;
            }
            return (episode - 48) * 10 + (mission - 48);
        }

        public WarpMetric getMetric(boolean commercial) {
            int parse = commercial ? this.parseAsMapXX() : this.parseAsExMx();
            return new WarpFormat(Math.max(parse, 0)).getMetric(commercial);
        }
    }

    public static class WarpFormat {
        final int warpInt;

        public WarpFormat(int warpInt) {
            this.warpInt = warpInt;
        }

        public WarpFormat(String warpString) {
            int tryParse;
            try {
                tryParse = Integer.parseInt(warpString);
            }
            catch (NumberFormatException e) {
                tryParse = 0;
            }
            this.warpInt = tryParse;
        }

        public WarpMetric getMetric(boolean commercial) {
            return new Metric(commercial);
        }

        private class Metric
        implements WarpMetric {
            final int episode;
            final int map;

            Metric(boolean commercial) {
                if (commercial) {
                    this.episode = 1;
                    this.map = WarpFormat.this.warpInt;
                } else {
                    int evalInt = WarpFormat.this.warpInt > 99 ? WarpFormat.this.warpInt % 100 : WarpFormat.this.warpInt;
                    this.episode = evalInt / 10;
                    this.map = evalInt % 10;
                }
            }

            @Override
            public int getEpisode() {
                return this.episode;
            }

            @Override
            public int getMap() {
                return this.map;
            }
        }
    }

    public static class ForbidFormat {
        public static ForbidFormat FORBID = new ForbidFormat("disable");
        public static ForbidFormat ALLOW = new ForbidFormat(null);
        private final boolean isForbidden;

        public ForbidFormat(String forbidString) {
            this.isForbidden = "disable".equals(forbidString);
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + (this.isForbidden ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ForbidFormat other = (ForbidFormat)obj;
            return this.isForbidden == other.isForbidden;
        }
    }

    public static interface WarpMetric {
        public int getEpisode();

        public int getMap();
    }

    public static enum Type {
        PARAMETER,
        VARARG,
        SWITCH;

    }
}

