/*
 * Decompiled with CFR 0.152.
 */
package doom;

import doom.CommandVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import m.Settings;
import mochadoom.Engine;
import utils.OSValidator;
import utils.ResourceIO;

public enum ConfigBase {
    WINDOWS("default.cfg", "USERPROFILE"),
    UNIX(".doomrc", "HOME");

    public static final ConfigBase CURRENT;
    public static final Files FILE_DOOM;
    public static final Files FILE_MOCHADOOM;
    public final String defaultConfigName;
    public final String env;

    private ConfigBase(String fileName, String env) {
        this.defaultConfigName = fileName;
        this.env = env;
    }

    public static List<Files> getFiles() {
        ArrayList<Files> ret = new ArrayList<Files>();
        if (!Engine.getCVM().with(CommandVariable.CONFIG, 0, fileNames -> Arrays.stream(fileNames).map(Files::new).forEach(ret::add))) {
            ret.add(FILE_DOOM);
            ret.add(FILE_MOCHADOOM);
        }
        return ret;
    }

    static {
        CURRENT = OSValidator.isMac() || OSValidator.isUnix() ? UNIX : WINDOWS;
        FILE_DOOM = new Files(ConfigBase.CURRENT.defaultConfigName, Enum::compareTo);
        FILE_MOCHADOOM = new Files("mochadoom.cfg");
    }

    public static class Files {
        private static String folder;
        public final Comparator<Settings> comparator;
        public final String fileName;
        public boolean changed = true;
        private String[] paths;

        public Files(String fileName) {
            this(fileName, Comparator.comparing(Enum::name, String::compareTo));
        }

        public Files(String fileName, Comparator<Settings> comparator) {
            this.fileName = fileName;
            this.comparator = comparator;
        }

        public Optional<ResourceIO> firstValidPathIO() {
            return Arrays.stream(this.getPaths()).map(ResourceIO::new).filter(ResourceIO::exists).findFirst();
        }

        public ResourceIO workDirIO() {
            return new ResourceIO(Files.getFolder() + this.fileName);
        }

        private String[] getPaths() {
            if (this.paths != null) {
                return this.paths;
            }
            String getPath = null;
            try {
                getPath = System.getenv(ConfigBase.CURRENT.env);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (getPath == null || "".equals(getPath)) {
                return new String[]{folder};
            }
            getPath = getPath + System.getProperty("file.separator");
            this.paths = new String[]{Files.getFolder() + this.fileName};
            return this.paths;
        }

        private static String getFolder() {
            return folder != null ? folder : (folder = Engine.getCVM().bool(CommandVariable.SHDEV) || Engine.getCVM().bool(CommandVariable.REGDEV) || Engine.getCVM().bool(CommandVariable.FR1DEV) || Engine.getCVM().bool(CommandVariable.FRDMDEV) || Engine.getCVM().bool(CommandVariable.FR2DEV) || Engine.getCVM().bool(CommandVariable.COMDEV) ? "devdata" + System.getProperty("file.separator") : "");
        }
    }
}

