/*
 * Decompiled with CFR 0.152.
 */
package doom;

import doom.ConfigBase;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import m.Settings;
import utils.ParseString;
import utils.QuoteType;
import utils.ResourceIO;

public class ConfigManager {
    private static final Pattern SPLITTER = Pattern.compile("[ \t\n\r\f]+");
    private final List<ConfigBase.Files> configFiles = ConfigBase.getFiles();
    private final EnumMap<Settings, Object> configMap = new EnumMap(Settings.class);

    public ConfigManager() {
        this.LoadDefaults();
    }

    public UpdateStatus update(Settings setting, String value) {
        if (setting.valueType == String.class) {
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)value), value));
        }
        if (setting.valueType == Character.class || setting.valueType == Long.class || setting.valueType == Integer.class || setting.valueType == Boolean.class) {
            Object parse = ParseString.parseString(value);
            if (setting.valueType.isInstance(parse)) {
                return setting.hasChange(!Objects.equals(this.configMap.put(setting, parse), parse));
            }
        } else if (setting.valueType.getSuperclass() == Enum.class) {
            Object enumerated = Enum.valueOf(setting.valueType, value);
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, enumerated), enumerated));
        }
        return UpdateStatus.INVALID;
    }

    public UpdateStatus update(Settings setting, Object value) {
        if (setting.valueType == String.class) {
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)value.toString()), value.toString()));
        }
        return UpdateStatus.INVALID;
    }

    public UpdateStatus update(Settings setting, int value) {
        if (setting.valueType == Integer.class) {
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)value), value));
        }
        if (setting.valueType == String.class) {
            String valStr = Integer.toString(value);
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)valStr), valStr));
        }
        if (setting.valueType.getSuperclass() == Enum.class) {
            ?[] enumValues = setting.valueType.getEnumConstants();
            if (value >= 0 && value < enumValues.length) {
                return setting.hasChange(!Objects.equals(this.configMap.put(setting, enumValues[value]), enumValues[value]));
            }
        }
        return UpdateStatus.INVALID;
    }

    public UpdateStatus update(Settings setting, long value) {
        if (setting.valueType == Long.class) {
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)value), value));
        }
        if (setting.valueType == String.class) {
            String valStr = Long.toString(value);
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)valStr), valStr));
        }
        return UpdateStatus.INVALID;
    }

    public UpdateStatus update(Settings setting, double value) {
        if (setting.valueType == Double.class) {
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)value), value));
        }
        if (setting.valueType == String.class) {
            String valStr = Double.toString(value);
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)valStr), valStr));
        }
        return UpdateStatus.INVALID;
    }

    public UpdateStatus update(Settings setting, char value) {
        if (setting.valueType == Character.class) {
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)Character.valueOf(value)), Character.valueOf(value)));
        }
        if (setting.valueType == String.class) {
            String valStr = Character.toString(value);
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)valStr), valStr));
        }
        return UpdateStatus.INVALID;
    }

    public UpdateStatus update(Settings setting, boolean value) {
        if (setting.valueType == Boolean.class) {
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)value), value));
        }
        if (setting.valueType == String.class) {
            String valStr = Boolean.toString(value);
            return setting.hasChange(!Objects.equals(this.configMap.put(setting, (Object)valStr), valStr));
        }
        return UpdateStatus.INVALID;
    }

    private String export(Settings setting) {
        return setting.quoteType().map(qt -> setting.name() + "\t\t" + qt.quoteChar + this.configMap.get((Object)setting) + qt.quoteChar).orElseGet(() -> setting.name() + "\t\t" + this.configMap.get((Object)setting));
    }

    public boolean equals(Settings setting, Object obj) {
        return obj.equals(this.configMap.get((Object)setting));
    }

    public <T> T getValue(Settings setting, Class<T> valueType) {
        if (setting.valueType == valueType) {
            return (T)this.configMap.get((Object)setting);
        }
        if (valueType == String.class) {
            return (T)this.configMap.get((Object)setting).toString();
        }
        if (setting.valueType == String.class) {
            Object parse;
            if ((valueType == Character.class || valueType == Long.class || valueType == Integer.class || valueType == Boolean.class) && valueType.isInstance(parse = ParseString.parseString(this.configMap.get((Object)setting).toString()))) {
                return (T)parse;
            }
        } else if (valueType == Integer.class && setting.valueType.getSuperclass() == Enum.class) {
            return (T)Integer.valueOf(((Enum)this.configMap.get((Object)setting)).ordinal());
        }
        throw new IllegalArgumentException("Unsupported cast: " + setting.valueType + " to " + valueType);
    }

    public void SaveDefaults() {
        Settings.SETTINGS_MAP.forEach((file, settings) -> {
            if (!file.changed) {
                return;
            }
            ResourceIO rio = file.firstValidPathIO().orElseGet(file::workDirIO);
            Iterator it = settings.stream().sorted(file.comparator).iterator();
            if (rio.writeLines(() -> {
                if (it.hasNext()) {
                    return this.export((Settings)((Object)((Object)((Object)it.next()))));
                }
                return null;
            }, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE)) {
                file.changed = false;
            }
        });
    }

    private void LoadDefaults() {
        Arrays.stream(Settings.values()).forEach(setting -> this.configMap.put((Settings)((Object)setting), setting.defaultValue));
        System.out.print("M_LoadDefaults: Load system defaults.\n");
        this.configFiles.forEach(file -> {
            Optional<ResourceIO> maybeRIO = file.firstValidPathIO();
            file.changed = !maybeRIO.isPresent() || !this.readFoundConfig((ConfigBase.Files)file, maybeRIO.get());
        });
        this.SaveDefaults();
    }

    private boolean readFoundConfig(ConfigBase.Files file, ResourceIO rio) {
        System.out.print(String.format("M_LoadDefaults: Using config %s.\n", rio.getFileame()));
        if (rio.readLines(line -> {
            String[] split = SPLITTER.split((CharSequence)line, 2);
            if (split.length < 2) {
                return;
            }
            String name = split[0];
            try {
                Settings setting = Settings.valueOf(name);
                String value = setting.quoteType().filter(qt -> qt == QuoteType.DOUBLE).map(qt -> qt.unQuote(split[1])).orElse(split[1]);
                if (this.update(setting, value) == UpdateStatus.INVALID) {
                    System.err.printf("WARNING: invalid config value for: %s in %s \n", name, rio.getFileame());
                } else {
                    setting.rebase(file);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        })) {
            return true;
        }
        System.err.printf("Can't read the settings file %s\n", rio.getFileame());
        return false;
    }

    public static enum UpdateStatus {
        UNCHANGED,
        UPDATED,
        INVALID;

    }
}

