/*
 * Decompiled with CFR 0.152.
 */
package doom;

import data.mapthing_t;
import defines.GameMission_t;
import defines.GameMode;
import defines.Language_t;
import defines.gamestate_t;
import defines.skill_t;
import demo.IDoomDemo;
import doom.ConfigManager;
import doom.doomcom_t;
import doom.doomdata_t;
import doom.gameaction_t;
import doom.ticcmd_t;
import doom.wbstartstruct_t;
import f.Finale;
import g.Signals;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.stream.Stream;
import m.Settings;
import mochadoom.Engine;
import p.mobj_t;

public abstract class DoomStatus<T, V> {
    public static final int BGCOLOR = 7;
    public static final int FGCOLOR = 8;
    public static int RESENDCOUNT = 10;
    public static int PL_DRONE = 128;
    public String[] wadfiles = new String[20];
    boolean drone;
    public boolean nomonsters;
    public boolean respawnparm;
    public boolean fastparm;
    public boolean devparm;
    public boolean inhelpscreens;
    boolean advancedemo;
    private GameMode gamemode;
    public GameMission_t gamemission;
    public Language_t language;
    public skill_t startskill;
    public int startepisode;
    public int startmap;
    public boolean autostart;
    public skill_t gameskill;
    public int gameepisode;
    public int gamemap;
    public boolean respawnmonsters;
    public boolean netgame;
    public boolean deathmatch;
    public boolean altdeath;
    public boolean nodrawers;
    public boolean noblit;
    public boolean viewactive;
    public int consoleplayer;
    public int displayplayer;
    public boolean statusbaractive;
    public boolean automapactive;
    public boolean menuactive;
    public boolean mousecaptured = true;
    public boolean paused;
    public int snd_SfxVolume;
    public int snd_MusicVolume;
    public int numChannels;
    public int snd_MusicDevice;
    public int snd_SfxDevice;
    public int snd_DesiredMusicDevice;
    public int snd_DesiredSfxDevice;
    public int totalkills;
    public int totalitems;
    public int totalsecret;
    public boolean flashing_hom;
    public int totallive;
    public int levelstarttic;
    public int leveltime;
    public boolean usergame;
    public boolean demoplayback;
    public boolean demorecording;
    public boolean singledemo;
    public boolean mapstrobe;
    public gamestate_t gamestate = gamestate_t.GS_DEMOSCREEN;
    public int gametic;
    public boolean[] playeringame = new boolean[4];
    public mapthing_t[] deathmatchstarts = new mapthing_t[10];
    public int deathmatch_p;
    public mapthing_t[] playerstarts = new mapthing_t[4];
    public wbstartstruct_t wminfo;
    public static final int[] maxammo = new int[]{200, 50, 300, 50};
    public OutputStreamWriter debugfile;
    public boolean precache;
    public gamestate_t wipegamestate = gamestate_t.GS_DEMOSCREEN;
    public int mouseSensitivity = 5;
    public boolean modifiedgame = false;
    public boolean singletics = false;
    protected boolean fastdemo;
    protected boolean normaldemo;
    protected String loaddemo = null;
    public int bodyqueslot;
    public doomcom_t doomcom;
    public doomdata_t netbuffer;
    public ticcmd_t[] localcmds = new ticcmd_t[12];
    public int rndindex;
    public ticcmd_t[][] netcmds;
    protected gameaction_t gameaction = gameaction_t.ga_nothing;
    public boolean sendpause;
    protected boolean sendsave;
    protected int starttime;
    protected boolean timingdemo;
    protected String demoname;
    protected boolean netdemo;
    protected IDoomDemo demobuffer;
    protected short[][] consistancy = new short[4][12];
    protected byte[] savebuffer;
    public int key_right = Signals.ScanCode.SC_NUMKEY6.ordinal();
    public int key_left = Signals.ScanCode.SC_NUMKEY4.ordinal();
    public int key_up = Signals.ScanCode.SC_W.ordinal();
    public int key_down = Signals.ScanCode.SC_S.ordinal();
    public int key_strafeleft = Signals.ScanCode.SC_A.ordinal();
    public int key_straferight = Signals.ScanCode.SC_D.ordinal();
    public int key_fire = Signals.ScanCode.SC_LCTRL.ordinal();
    public int key_use = Signals.ScanCode.SC_SPACE.ordinal();
    public int key_strafe = Signals.ScanCode.SC_LALT.ordinal();
    public int key_speed = Signals.ScanCode.SC_RSHIFT.ordinal();
    public boolean vanillaKeyBehavior;
    public int key_recordstop = Signals.ScanCode.SC_Q.ordinal();
    public int[] key_numbers = Stream.of(Signals.ScanCode.SC_1, Signals.ScanCode.SC_2, Signals.ScanCode.SC_3, Signals.ScanCode.SC_4, Signals.ScanCode.SC_5, Signals.ScanCode.SC_6, Signals.ScanCode.SC_7, Signals.ScanCode.SC_8, Signals.ScanCode.SC_9, Signals.ScanCode.SC_0).mapToInt(Enum::ordinal).toArray();
    public int key_lookup = Signals.ScanCode.SC_PGUP.ordinal();
    public int key_lookdown = Signals.ScanCode.SC_PGDOWN.ordinal();
    public int key_lookcenter = Signals.ScanCode.SC_END.ordinal();
    public int mousebfire = 0;
    public int mousebstrafe = 2;
    public int mousebforward = 1;
    public int joybfire;
    public int joybstrafe;
    public int joybuse;
    public int joybspeed;
    protected boolean novert = false;
    protected static final int TURBOTHRESHOLD = 50;
    protected final int[] forwardmove = new int[]{25, 50};
    protected final int[] sidemove = new int[]{24, 40};
    protected final int[] angleturn = new int[]{640, 1280, 320};
    protected static final int SLOWTURNTICS = 6;
    protected static final int NUMKEYS = 256;
    protected boolean[] gamekeydown = new boolean[256];
    protected boolean keysCleared;
    public boolean alwaysrun;
    protected int turnheld;
    protected int lookheld;
    protected boolean[] mousearray = new boolean[4];
    protected int mousex;
    protected int mousey;
    protected int dclicktime;
    protected int dclickstate;
    protected int dclicks;
    protected int dclicktime2;
    protected int dclickstate2;
    protected int dclicks2;
    protected int joyxmove;
    protected int joyymove;
    protected boolean[] joyarray = new boolean[5];
    protected int savegameslot;
    protected String savedescription;
    protected static final int BODYQUESIZE = 32;
    protected mobj_t[] bodyque = new mobj_t[32];
    public String statcopy;
    public boolean use_mouse;
    public boolean use_joystick;
    public static int compatibility_level;
    public final ConfigManager CM = Engine.getConfig();

    public void setGameMode(GameMode mode) {
        this.gamemode = mode;
    }

    public GameMode getGameMode() {
        return this.gamemode;
    }

    public boolean isShareware() {
        return this.gamemode == GameMode.shareware;
    }

    public boolean isCommercial() {
        return this.gamemode == GameMode.commercial || this.gamemode == GameMode.pack_plut || this.gamemode == GameMode.pack_tnt || this.gamemode == GameMode.pack_xbla || this.gamemode == GameMode.freedoom2 || this.gamemode == GameMode.freedm;
    }

    public boolean isRetail() {
        return this.gamemode == GameMode.retail || this.gamemode == GameMode.freedoom1;
    }

    public boolean isRegistered() {
        return this.gamemode == GameMode.registered || this.gamemode == GameMode.retail || this.gamemode == GameMode.freedoom1;
    }

    protected final void initNetGameStuff() {
        this.doomcom = new doomcom_t();
        this.netcmds = new ticcmd_t[4][12];
        Arrays.setAll(this.localcmds, i -> new ticcmd_t());
        for (int i2 = 0; i2 < 4; ++i2) {
            Arrays.setAll(this.netcmds[i2], j -> new ticcmd_t());
        }
    }

    protected abstract Finale<T> selectFinale();

    public boolean getPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    protected int MAXPLMOVE() {
        return this.forwardmove[1];
    }

    protected boolean mousebuttons(int i) {
        return this.mousearray[1 + i];
    }

    protected void mousebuttons(int i, boolean value) {
        this.mousearray[1 + i] = value;
    }

    protected void mousebuttons(int i, int value) {
        this.mousearray[1 + i] = value != 0;
    }

    protected boolean joybuttons(int i) {
        return this.joyarray[1 + i];
    }

    protected void joybuttons(int i, boolean value) {
        this.joyarray[1 + i] = value;
    }

    protected void joybuttons(int i, int value) {
        this.joyarray[1 + i] = value != 0;
    }

    public DoomStatus() {
        this.wminfo = new wbstartstruct_t();
        this.initNetGameStuff();
    }

    public void update() {
        this.snd_SfxVolume = this.CM.getValue(Settings.sfx_volume, Integer.class);
        this.snd_MusicVolume = this.CM.getValue(Settings.music_volume, Integer.class);
        this.alwaysrun = this.CM.equals(Settings.alwaysrun, Boolean.TRUE);
        this.key_right = this.CM.getValue(Settings.key_right, Integer.class);
        this.key_left = this.CM.getValue(Settings.key_left, Integer.class);
        this.key_up = this.CM.getValue(Settings.key_up, Integer.class);
        this.key_down = this.CM.getValue(Settings.key_down, Integer.class);
        this.key_strafeleft = this.CM.getValue(Settings.key_strafeleft, Integer.class);
        this.key_straferight = this.CM.getValue(Settings.key_straferight, Integer.class);
        this.key_fire = this.CM.getValue(Settings.key_fire, Integer.class);
        this.key_use = this.CM.getValue(Settings.key_use, Integer.class);
        this.key_strafe = this.CM.getValue(Settings.key_strafe, Integer.class);
        this.key_speed = this.CM.getValue(Settings.key_speed, Integer.class);
        this.use_mouse = this.CM.equals(Settings.use_mouse, 1);
        this.mousebfire = this.CM.getValue(Settings.mouseb_fire, Integer.class);
        this.mousebstrafe = this.CM.getValue(Settings.mouseb_strafe, Integer.class);
        this.mousebforward = this.CM.getValue(Settings.mouseb_forward, Integer.class);
        this.use_joystick = this.CM.equals(Settings.use_joystick, 1);
        this.joybfire = this.CM.getValue(Settings.joyb_fire, Integer.class);
        this.joybstrafe = this.CM.getValue(Settings.joyb_strafe, Integer.class);
        this.joybuse = this.CM.getValue(Settings.joyb_use, Integer.class);
        this.joybspeed = this.CM.getValue(Settings.joyb_speed, Integer.class);
        this.numChannels = this.CM.getValue(Settings.snd_channels, Integer.class);
        this.mapstrobe = this.CM.equals(Settings.vestrobe, Boolean.TRUE);
        this.mouseSensitivity = this.CM.getValue(Settings.mouse_sensitivity, Integer.class);
        this.vanillaKeyBehavior = this.CM.equals(Settings.vanilla_key_behavior, Boolean.TRUE);
    }

    public void commit() {
        this.CM.update(Settings.sfx_volume, this.snd_SfxVolume);
        this.CM.update(Settings.music_volume, this.snd_MusicVolume);
        this.CM.update(Settings.alwaysrun, this.alwaysrun);
        this.CM.update(Settings.key_right, this.key_right);
        this.CM.update(Settings.key_left, this.key_left);
        this.CM.update(Settings.key_up, this.key_up);
        this.CM.update(Settings.key_down, this.key_down);
        this.CM.update(Settings.key_strafeleft, this.key_strafeleft);
        this.CM.update(Settings.key_straferight, this.key_straferight);
        this.CM.update(Settings.key_fire, this.key_fire);
        this.CM.update(Settings.key_use, this.key_use);
        this.CM.update(Settings.key_strafe, this.key_strafe);
        this.CM.update(Settings.key_speed, this.key_speed);
        this.CM.update(Settings.use_mouse, this.use_mouse ? 1 : 0);
        this.CM.update(Settings.mouseb_fire, this.mousebfire);
        this.CM.update(Settings.mouseb_strafe, this.mousebstrafe);
        this.CM.update(Settings.mouseb_forward, this.mousebforward);
        this.CM.update(Settings.use_joystick, this.use_joystick ? 1 : 0);
        this.CM.update(Settings.joyb_fire, this.joybfire);
        this.CM.update(Settings.joyb_strafe, this.joybstrafe);
        this.CM.update(Settings.joyb_use, this.joybuse);
        this.CM.update(Settings.joyb_speed, this.joybspeed);
        this.CM.update(Settings.snd_channels, this.numChannels);
        this.CM.update(Settings.vestrobe, this.mapstrobe);
        this.CM.update(Settings.mouse_sensitivity, this.mouseSensitivity);
    }
}

