/*
 * Decompiled with CFR 0.152.
 */
package f;

import data.sounds;
import defines.Language_t;
import doom.DoomMain;
import doom.event_t;
import doom.player_t;
import doom.wbplayerstruct_t;
import doom.wbstartstruct_t;
import f.AbstractEndLevel;
import f.anim_t;
import rr.patch_t;
import v.renderers.DoomScreen;

public class EndLevel<T, V>
extends AbstractEndLevel {
    private final DoomMain<T, V> DOOM;
    private static final int COUNT_KILLS = 2;
    private static final int COUNT_ITEMS = 4;
    private static final int COUNT_SECRETS = 6;
    private static final int COUNT_TIME = 8;
    private static final int COUNT_DONE = 10;
    private static final int WI_TITLEY = 2;
    private static final int WI_SPACINGY = 3;
    private static final boolean RANGECHECKING = true;
    public static int SP_STATSX;
    public static int SP_STATSY;
    public static int SP_TIMEX;
    public static int SP_TIMEY;
    protected static int SP_KILLS;
    protected static int SP_ITEMS;
    protected static int SP_SECRET;
    protected static int SP_FRAGS;
    protected static int SP_TIME;
    protected static int SP_PAR;
    protected int SP_PAUSE = 1;
    protected int SHOWNEXTLOCDELAY;
    protected int SHOWLASTLOCDELAY = this.SHOWNEXTLOCDELAY = 4;
    int acceleratestage;
    int me;
    endlevel_state state;
    public wbstartstruct_t wbs;
    wbplayerstruct_t[] plrs;
    int cnt;
    int bcnt;
    int firstrefresh;
    int[] cnt_kills = new int[4];
    int[] cnt_items = new int[4];
    int[] cnt_secret = new int[4];
    int cnt_time;
    int cnt_par;
    int cnt_pause;
    int NUMCMAPS;
    patch_t bg;
    patch_t[] yah = new patch_t[3];
    patch_t[] splat;
    patch_t percent;
    patch_t colon;
    patch_t[] num = new patch_t[10];
    patch_t wiminus;
    patch_t finished;
    patch_t entering;
    patch_t sp_secret;
    patch_t kills;
    patch_t secret;
    patch_t items;
    patch_t frags;
    patch_t time;
    patch_t par;
    patch_t sucks;
    patch_t killers;
    patch_t victims;
    patch_t total;
    patch_t star;
    patch_t bstar;
    patch_t[] p = new patch_t[4];
    patch_t[] bp = new patch_t[4];
    patch_t[] lnames;
    boolean snl_pointeron = false;
    int dm_state;
    int[][] dm_frags = new int[4][4];
    int[] dm_totals = new int[4];
    int[] cnt_frags = new int[4];
    int dofrags;
    int ng_state;
    int sp_state;

    public EndLevel(DoomMain<T, V> DOOM) {
        this.DOOM = DOOM;
        SP_STATSX = 50 * DOOM.vs.getSafeScaling();
        SP_STATSY = 50 * DOOM.vs.getSafeScaling();
        SP_TIMEX = 16 * DOOM.vs.getSafeScaling();
        SP_TIMEY = DOOM.vs.getScreenHeight() - DOOM.statusBar.getHeight();
    }

    protected void slamBackground() {
        this.DOOM.graphicSystem.screenCopy(DoomScreen.BG, DoomScreen.FG);
    }

    public boolean Responder(event_t ev) {
        return false;
    }

    protected void drawLF() {
        int y = 2;
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.lnames[this.wbs.last], this.DOOM.vs, (320 - this.lnames[this.wbs.last].width) / 2, y, new int[0]);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.finished, this.DOOM.vs, (320 - this.finished.width) / 2, y += 5 * this.lnames[this.wbs.last].height / 4, new int[0]);
    }

    protected void drawEL() {
        int y = 2;
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.entering, this.DOOM.vs, (320 - this.entering.width) / 2, y, new int[0]);
        if (this.lnames[this.wbs.next].topoffset == 0) {
            y += 5 * this.lnames[this.wbs.next].height / 4;
        }
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.lnames[this.wbs.next], this.DOOM.vs, (320 - this.lnames[this.wbs.next].width) / 2, y, new int[0]);
    }

    protected void drawOnLnode(int n, patch_t[] c) {
        boolean fits = false;
        int i = 0;
        do {
            int left = EndLevel.lnodes[this.wbs.epsd][n].x - c[i].leftoffset;
            int top = EndLevel.lnodes[this.wbs.epsd][n].y - c[i].topoffset;
            int right = left + c[i].width;
            int bottom = top + c[i].height;
            if (left >= 0 && right < this.DOOM.vs.getScreenWidth() && top >= 0 && bottom < this.DOOM.vs.getScreenHeight()) {
                fits = true;
                continue;
            }
            ++i;
        } while (!fits && i != 2 && c[i] != null);
        if (fits && i < 2) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, c[i], this.DOOM.vs, EndLevel.lnodes[this.wbs.epsd][n].x, EndLevel.lnodes[this.wbs.epsd][n].y, new int[0]);
        } else {
            System.out.println("Could not place patch on level " + n + 1);
        }
    }

    protected void initAnimatedBack() {
        if (this.DOOM.isCommercial()) {
            return;
        }
        if (this.wbs.epsd > 2) {
            return;
        }
        block5: for (int i = 0; i < NUMANIMS[this.wbs.epsd]; ++i) {
            anim_t a = anims[this.wbs.epsd][i];
            a.ctr = -1;
            if (null == a.type) continue;
            switch (a.type) {
                case ANIM_ALWAYS: {
                    a.nexttic = this.bcnt + 1 + this.DOOM.random.M_Random() % a.period;
                    continue block5;
                }
                case ANIM_RANDOM: {
                    a.nexttic = this.bcnt + 1 + a.data2 + this.DOOM.random.M_Random() % a.data1;
                    continue block5;
                }
                case ANIM_LEVEL: {
                    a.nexttic = this.bcnt + 1;
                    continue block5;
                }
            }
        }
    }

    protected void updateAnimatedBack() {
        if (this.DOOM.isCommercial()) {
            return;
        }
        if (this.wbs.epsd > 2) {
            return;
        }
        int aaptr = this.wbs.epsd;
        block5: for (int i = 0; i < NUMANIMS[this.wbs.epsd]; ++i) {
            anim_t a = anims[aaptr][i];
            if (this.bcnt != a.nexttic) continue;
            switch (a.type) {
                case ANIM_ALWAYS: {
                    if (++EndLevel.anims[aaptr][i].ctr >= a.nanims) {
                        a.ctr = 0;
                    }
                    a.nexttic = this.bcnt + a.period;
                    continue block5;
                }
                case ANIM_RANDOM: {
                    ++a.ctr;
                    if (a.ctr == a.nanims) {
                        a.ctr = -1;
                        a.nexttic = this.bcnt + a.data2 + this.DOOM.random.M_Random() % a.data1;
                        continue block5;
                    }
                    a.nexttic = this.bcnt + a.period;
                    continue block5;
                }
                case ANIM_LEVEL: {
                    if (this.state == endlevel_state.StatCount && i == 7 || this.wbs.next != a.data1) continue block5;
                    ++a.ctr;
                    if (a.ctr == a.nanims) {
                        --a.ctr;
                    }
                    a.nexttic = this.bcnt + a.period;
                }
            }
        }
    }

    protected void drawAnimatedBack() {
        if (this.DOOM.isCommercial()) {
            return;
        }
        if (this.wbs.epsd > 2) {
            return;
        }
        for (int i = 0; i < NUMANIMS[this.wbs.epsd]; ++i) {
            anim_t a = anims[this.wbs.epsd][i];
            if (a.ctr < 0) continue;
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, a.p[a.ctr], this.DOOM.vs, a.loc.x, a.loc.y, new int[0]);
        }
    }

    protected int drawNum(int x, int y, int n, int digits) {
        boolean neg;
        short fontwidth = this.num[0].width;
        if (digits < 0) {
            if (n == 0) {
                digits = 1;
            } else {
                digits = 0;
                int temp = n;
                while (temp != 0) {
                    temp /= 10;
                    ++digits;
                }
            }
        }
        boolean bl = neg = n < 0;
        if (neg) {
            n = -n;
        }
        if (n == 1994) {
            return 0;
        }
        while (digits-- != 0) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.num[n % 10], this.DOOM.vs, x -= fontwidth * this.DOOM.vs.getScalingX(), y, 65536);
            n /= 10;
        }
        if (neg) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.wiminus, this.DOOM.vs, x -= 8 * this.DOOM.vs.getScalingX(), y, 65536);
        }
        return x;
    }

    protected void drawPercent(int x, int y, int p) {
        if (p < 0) {
            return;
        }
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.percent, this.DOOM.vs, x, y, 65536);
        this.drawNum(x, y, p, -1);
    }

    protected void drawTime(int x, int y, int t) {
        if (t < 0) {
            return;
        }
        if (t <= 3599) {
            int div = 1;
            do {
                int n = t / div % 60;
                x = this.drawNum(x, y, n, 2) - this.colon.width * this.DOOM.vs.getScalingX();
                if ((div *= 60) != 60 && t / div <= 0) continue;
                this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.colon, this.DOOM.vs, x, y, 65536);
            } while (t / div > 0);
        } else {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.sucks, this.DOOM.vs, x - this.sucks.width * this.DOOM.vs.getScalingX(), y, 65536);
        }
    }

    protected void End() {
        this.state = endlevel_state.JustShutOff;
        this.DOOM.graphicSystem.forcePalette();
        this.unloadData();
    }

    protected void unloadData() {
        int i;
        this.DOOM.wadLoader.UnlockLumpNum(this.wiminus);
        this.wiminus = null;
        for (i = 0; i < 10; ++i) {
            this.DOOM.wadLoader.UnlockLumpNum(this.num[i]);
            this.num[i] = null;
        }
        if (this.DOOM.isCommercial()) {
            for (i = 0; i < this.NUMCMAPS; ++i) {
                this.DOOM.wadLoader.UnlockLumpNum(this.lnames[i]);
                this.lnames[i] = null;
            }
        } else {
            this.DOOM.wadLoader.UnlockLumpNum(this.yah[0]);
            this.yah[0] = null;
            this.DOOM.wadLoader.UnlockLumpNum(this.yah[1]);
            this.yah[1] = null;
            this.DOOM.wadLoader.UnlockLumpNum(this.splat[0]);
            this.splat[0] = null;
            for (i = 0; i < 9; ++i) {
                this.DOOM.wadLoader.UnlockLumpNum(this.lnames[i]);
                this.lnames[i] = null;
            }
            if (this.wbs.epsd < 3) {
                for (int j = 0; j < NUMANIMS[this.wbs.epsd]; ++j) {
                    if (this.wbs.epsd == 1 && j == 8) continue;
                    for (i = 0; i < EndLevel.anims[this.wbs.epsd][j].nanims; ++i) {
                        this.DOOM.wadLoader.UnlockLumpNum(EndLevel.anims[this.wbs.epsd][j].p[i]);
                        EndLevel.anims[this.wbs.epsd][j].p[i] = null;
                    }
                }
            }
        }
        this.DOOM.wadLoader.UnlockLumpNum(this.percent);
        this.percent = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.colon);
        this.colon = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.finished);
        this.finished = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.entering);
        this.entering = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.kills);
        this.kills = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.secret);
        this.secret = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.sp_secret);
        this.sp_secret = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.items);
        this.items = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.frags);
        this.frags = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.time);
        this.time = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.sucks);
        this.sucks = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.par);
        this.par = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.victims);
        this.victims = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.killers);
        this.killers = null;
        this.DOOM.wadLoader.UnlockLumpNum(this.total);
        this.total = null;
        for (i = 0; i < 4; ++i) {
            this.DOOM.wadLoader.UnlockLumpNum(this.p[i]);
            this.DOOM.wadLoader.UnlockLumpNum(this.bp[i]);
            this.p[i] = null;
            this.bp[i] = null;
        }
    }

    protected void initNoState() {
        this.state = endlevel_state.NoState;
        this.acceleratestage = 0;
        this.cnt = 10;
    }

    protected void updateNoState() {
        this.updateAnimatedBack();
        if (--this.cnt == 0) {
            this.End();
            this.DOOM.WorldDone();
        }
    }

    protected void initShowNextLoc() {
        this.state = endlevel_state.ShowNextLoc;
        this.acceleratestage = 0;
        this.cnt = this.SHOWNEXTLOCDELAY * 35;
        this.initAnimatedBack();
    }

    protected void updateShowNextLoc() {
        this.updateAnimatedBack();
        if (--this.cnt == 0 || this.acceleratestage != 0) {
            this.initNoState();
        } else {
            this.snl_pointeron = (this.cnt & 0x1F) < 20;
        }
    }

    protected void drawShowNextLoc() {
        this.slamBackground();
        this.drawAnimatedBack();
        if (!this.DOOM.isCommercial()) {
            if (this.wbs.epsd > 2) {
                this.drawEL();
                return;
            }
            int last = this.wbs.last == 8 ? this.wbs.next - 1 : this.wbs.last;
            for (int i = 0; i <= last; ++i) {
                this.drawOnLnode(i, this.splat);
            }
            if (this.wbs.didsecret) {
                this.drawOnLnode(8, this.splat);
            }
            if (this.snl_pointeron) {
                this.drawOnLnode(this.wbs.next, this.yah);
            }
        }
        if (!this.DOOM.isCommercial() || this.wbs.next != 30) {
            this.drawEL();
        }
    }

    protected void drawNoState() {
        this.snl_pointeron = true;
        this.drawShowNextLoc();
    }

    protected int fragSum(int playernum) {
        int frags = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.DOOM.playeringame[i] || i == playernum) continue;
            frags += this.plrs[playernum].frags[i];
        }
        return frags -= this.plrs[playernum].frags[playernum];
    }

    protected void initDeathmatchStats() {
        this.state = endlevel_state.StatCount;
        this.acceleratestage = 0;
        this.dm_state = 1;
        this.cnt_pause = 35;
        for (int i = 0; i < 4; ++i) {
            if (!this.DOOM.playeringame[i]) continue;
            for (int j = 0; j < 4; ++j) {
                if (!this.DOOM.playeringame[j]) continue;
                this.dm_frags[i][j] = 0;
            }
            this.dm_totals[i] = 0;
        }
        this.initAnimatedBack();
    }

    protected void updateDeathmatchStats() {
        int j;
        int i;
        this.updateAnimatedBack();
        if (this.acceleratestage != 0 && this.dm_state != 4) {
            this.acceleratestage = 0;
            for (i = 0; i < 4; ++i) {
                if (!this.DOOM.playeringame[i]) continue;
                for (j = 0; j < 4; ++j) {
                    if (!this.DOOM.playeringame[j]) continue;
                    this.dm_frags[i][j] = this.plrs[i].frags[j];
                }
                this.dm_totals[i] = this.fragSum(i);
            }
            this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
            this.dm_state = 4;
        }
        if (this.dm_state == 2) {
            if ((this.bcnt & 3) == 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
            }
            boolean stillticking = false;
            for (i = 0; i < 4; ++i) {
                if (!this.DOOM.playeringame[i]) continue;
                for (j = 0; j < 4; ++j) {
                    if (!this.DOOM.playeringame[j] || this.dm_frags[i][j] == this.plrs[i].frags[j]) continue;
                    if (this.plrs[i].frags[j] < 0) {
                        int[] nArray = this.dm_frags[i];
                        int n = j;
                        nArray[n] = nArray[n] - 1;
                    } else {
                        int[] nArray = this.dm_frags[i];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                    }
                    if (this.dm_frags[i][j] > 99) {
                        this.dm_frags[i][j] = 99;
                    }
                    if (this.dm_frags[i][j] < -99) {
                        this.dm_frags[i][j] = -99;
                    }
                    stillticking = true;
                }
                this.dm_totals[i] = this.fragSum(i);
                if (this.dm_totals[i] > 99) {
                    this.dm_totals[i] = 99;
                }
                if (this.dm_totals[i] >= -99) continue;
                this.dm_totals[i] = -99;
            }
            if (!stillticking) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
                ++this.dm_state;
            }
        } else if (this.dm_state == 4) {
            if (this.acceleratestage != 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_slop);
                if (this.DOOM.isCommercial()) {
                    this.initNoState();
                } else {
                    this.initShowNextLoc();
                }
            }
        } else if ((this.dm_state & 1) != 0 && --this.cnt_pause == 0) {
            ++this.dm_state;
            this.cnt_pause = 35;
        }
    }

    protected void drawDeathmatchStats() {
        int i;
        int lh = 3;
        this.slamBackground();
        this.drawAnimatedBack();
        this.drawLF();
        this.DOOM.graphicSystem.DrawPatch(DoomScreen.FG, this.total, 269 - this.total.width / 2, 75, new int[0]);
        this.DOOM.graphicSystem.DrawPatch(DoomScreen.FG, this.killers, 10, 100, new int[0]);
        this.DOOM.graphicSystem.DrawPatch(DoomScreen.FG, this.victims, 5, 50, new int[0]);
        int x = 82;
        int y = 68;
        for (i = 0; i < 4; ++i) {
            if (this.DOOM.playeringame[i]) {
                this.DOOM.graphicSystem.DrawPatch(DoomScreen.FG, this.p[i], x - this.p[i].width / 2, 65, new int[0]);
                this.DOOM.graphicSystem.DrawPatch(DoomScreen.FG, this.p[i], 42 - this.p[i].width / 2, y, new int[0]);
                if (i == this.me) {
                    this.DOOM.graphicSystem.DrawPatch(DoomScreen.FG, this.bstar, x - this.p[i].width / 2, 65, new int[0]);
                    this.DOOM.graphicSystem.DrawPatch(DoomScreen.FG, this.star, 42 - this.p[i].width / 2, y, new int[0]);
                }
            }
            x += 40;
            y += 3;
        }
        y = 78;
        short w = this.num[0].width;
        for (i = 0; i < 4; ++i) {
            x = 82;
            if (this.DOOM.playeringame[i]) {
                for (int j = 0; j < 4; ++j) {
                    if (this.DOOM.playeringame[j]) {
                        this.drawNum(x + w, y, this.dm_frags[i][j], 2);
                    }
                    x += 40;
                }
                this.drawNum(269 + w, y, this.dm_totals[i], 2);
            }
            y += 3;
        }
    }

    protected void initNetgameStats() {
        this.state = endlevel_state.StatCount;
        this.acceleratestage = 0;
        this.ng_state = 1;
        this.cnt_pause = 35;
        for (int i = 0; i < 4; ++i) {
            if (!this.DOOM.playeringame[i]) continue;
            this.cnt_frags[i] = 0;
            this.cnt_secret[i] = 0;
            this.cnt_items[i] = 0;
            this.cnt_kills[i] = 0;
            this.dofrags += this.fragSum(i);
        }
        this.dofrags = ~(~this.dofrags);
        this.initAnimatedBack();
    }

    protected void updateNetgameStats() {
        int i;
        this.updateAnimatedBack();
        if (this.acceleratestage != 0 && this.ng_state != 10) {
            this.acceleratestage = 0;
            for (i = 0; i < 4; ++i) {
                if (!this.DOOM.playeringame[i]) continue;
                this.cnt_kills[i] = this.plrs[i].skills * 100 / this.wbs.maxkills;
                this.cnt_items[i] = this.plrs[i].sitems * 100 / this.wbs.maxitems;
                this.cnt_secret[i] = this.plrs[i].ssecret * 100 / this.wbs.maxsecret;
                if (this.dofrags == 0) continue;
                this.cnt_frags[i] = this.fragSum(i);
            }
            this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
            this.ng_state = 10;
        }
        if (this.ng_state == 2) {
            if ((this.bcnt & 3) == 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
            }
            boolean stillticking = false;
            for (i = 0; i < 4; ++i) {
                if (!this.DOOM.playeringame[i]) continue;
                int n = i;
                this.cnt_kills[n] = this.cnt_kills[n] + 2;
                if (this.cnt_kills[i] >= this.plrs[i].skills * 100 / this.wbs.maxkills) {
                    this.cnt_kills[i] = this.plrs[i].skills * 100 / this.wbs.maxkills;
                    continue;
                }
                stillticking = true;
            }
            if (!stillticking) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
                ++this.ng_state;
            }
        } else if (this.ng_state == 4) {
            if ((this.bcnt & 3) == 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
            }
            boolean stillticking = false;
            for (i = 0; i < 4; ++i) {
                if (!this.DOOM.playeringame[i]) continue;
                int n = i;
                this.cnt_items[n] = this.cnt_items[n] + 2;
                if (this.cnt_items[i] >= this.plrs[i].sitems * 100 / this.wbs.maxitems) {
                    this.cnt_items[i] = this.plrs[i].sitems * 100 / this.wbs.maxitems;
                    continue;
                }
                stillticking = true;
            }
            if (!stillticking) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
                ++this.ng_state;
            }
        } else if (this.ng_state == 6) {
            if ((this.bcnt & 3) == 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
            }
            boolean stillticking = false;
            for (i = 0; i < 4; ++i) {
                if (!this.DOOM.playeringame[i]) continue;
                int n = i;
                this.cnt_secret[n] = this.cnt_secret[n] + 2;
                if (this.cnt_secret[i] >= this.plrs[i].ssecret * 100 / this.wbs.maxsecret) {
                    this.cnt_secret[i] = this.plrs[i].ssecret * 100 / this.wbs.maxsecret;
                    continue;
                }
                stillticking = true;
            }
            if (!stillticking) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
                this.ng_state += 1 + 2 * ~this.dofrags;
            }
        } else if (this.ng_state == 8) {
            if ((this.bcnt & 3) == 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
            }
            boolean stillticking = false;
            for (i = 0; i < 4; ++i) {
                if (!this.DOOM.playeringame[i]) continue;
                int n = i;
                this.cnt_frags[n] = this.cnt_frags[n] + 1;
                int fsum = this.fragSum(i);
                if (this.cnt_frags[i] >= fsum) {
                    this.cnt_frags[i] = fsum;
                    continue;
                }
                stillticking = true;
            }
            if (!stillticking) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pldeth);
                ++this.ng_state;
            }
        } else if (this.ng_state == 10) {
            if (this.acceleratestage != 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_sgcock);
                if (this.DOOM.isCommercial()) {
                    this.initNoState();
                } else {
                    this.initShowNextLoc();
                }
            }
        } else if ((this.ng_state & 1) != 0 && --this.cnt_pause == 0) {
            ++this.ng_state;
            this.cnt_pause = 35;
        }
    }

    protected void drawNetgameStats() {
        short pwidth = this.percent.width;
        this.slamBackground();
        this.drawAnimatedBack();
        this.drawLF();
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.kills, this.DOOM.vs, this.NG_STATSX() + 64 - this.kills.width, 50, new int[0]);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.items, this.DOOM.vs, this.NG_STATSX() + 128 - this.items.width, 50, new int[0]);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.secret, this.DOOM.vs, this.NG_STATSX() + 192 - this.secret.width, 50, new int[0]);
        if (this.dofrags != 0) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.frags, this.DOOM.vs, this.NG_STATSX() + 256 - this.frags.width, 50, new int[0]);
        }
        int y = 50 + this.kills.height;
        for (int i = 0; i < 4; ++i) {
            if (!this.DOOM.playeringame[i]) continue;
            int x = this.NG_STATSX();
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.p[i], this.DOOM.vs, x - this.p[i].width, y, new int[0]);
            if (i == this.me) {
                this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.star, this.DOOM.vs, x - this.p[i].width, y, new int[0]);
            }
            this.drawPercent(((x += 64) - pwidth) * this.DOOM.vs.getScalingX(), (y + 10) * this.DOOM.vs.getScalingY(), this.cnt_kills[i]);
            this.drawPercent(((x += 64) - pwidth) * this.DOOM.vs.getScalingX(), (y + 10) * this.DOOM.vs.getScalingY(), this.cnt_items[i]);
            this.drawPercent(((x += 64) - pwidth) * this.DOOM.vs.getScalingX(), (y + 10) * this.DOOM.vs.getScalingY(), this.cnt_secret[i]);
            x += 64;
            if (this.dofrags != 0) {
                this.drawNum(x * this.DOOM.vs.getScalingX(), (y + 10) * this.DOOM.vs.getScalingY(), this.cnt_frags[i], -1);
            }
            y += 3;
        }
    }

    protected void initStats() {
        this.state = endlevel_state.StatCount;
        this.acceleratestage = 0;
        this.sp_state = 1;
        this.cnt_secret[0] = -1;
        this.cnt_items[0] = -1;
        this.cnt_kills[0] = -1;
        this.cnt_par = -1;
        this.cnt_time = -1;
        this.cnt_pause = 35;
        this.initAnimatedBack();
    }

    protected void updateStats() {
        this.updateAnimatedBack();
        if (this.acceleratestage != 0 && this.sp_state != 10) {
            this.acceleratestage = 0;
            this.cnt_kills[0] = this.plrs[this.me].skills * 100 / this.wbs.maxkills;
            this.cnt_items[0] = this.plrs[this.me].sitems * 100 / this.wbs.maxitems;
            this.cnt_secret[0] = this.plrs[this.me].ssecret * 100 / this.wbs.maxsecret;
            this.cnt_time = this.plrs[this.me].stime / 35;
            this.cnt_par = this.wbs.partime / 35;
            this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
            this.sp_state = 10;
        }
        if (this.sp_state == 2) {
            this.cnt_kills[0] = this.cnt_kills[0] + 2;
            if ((this.bcnt & 3) == 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
            }
            if (this.cnt_kills[0] >= this.plrs[this.me].skills * 100 / this.wbs.maxkills) {
                this.cnt_kills[0] = this.plrs[this.me].skills * 100 / this.wbs.maxkills;
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
                ++this.sp_state;
            }
        } else if (this.sp_state == 4) {
            this.cnt_items[0] = this.cnt_items[0] + 2;
            if ((this.bcnt & 3) == 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
            }
            if (this.cnt_items[0] >= this.plrs[this.me].sitems * 100 / this.wbs.maxitems) {
                this.cnt_items[0] = this.plrs[this.me].sitems * 100 / this.wbs.maxitems;
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
                ++this.sp_state;
            }
        } else if (this.sp_state == 6) {
            this.cnt_secret[0] = this.cnt_secret[0] + 2;
            if ((this.bcnt & 3) == 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
            }
            if (this.cnt_secret[0] >= this.plrs[this.me].ssecret * 100 / this.wbs.maxsecret) {
                this.cnt_secret[0] = this.plrs[this.me].ssecret * 100 / this.wbs.maxsecret;
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
                ++this.sp_state;
            }
        } else if (this.sp_state == 8) {
            if ((this.bcnt & 3) == 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
            }
            this.cnt_time += 3;
            if (this.cnt_time >= this.plrs[this.me].stime / 35) {
                this.cnt_time = this.plrs[this.me].stime / 35;
            }
            this.cnt_par += 3;
            if (this.cnt_par >= this.wbs.partime / 35) {
                this.cnt_par = this.wbs.partime / 35;
                if (this.cnt_time >= this.plrs[this.me].stime / 35) {
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_barexp);
                    ++this.sp_state;
                }
            }
        } else if (this.sp_state == 10) {
            if (this.acceleratestage != 0) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_sgcock);
                if (this.DOOM.isCommercial()) {
                    this.initNoState();
                } else {
                    this.initShowNextLoc();
                }
            }
        } else if ((this.sp_state & 1) > 0 && --this.cnt_pause == 0) {
            ++this.sp_state;
            this.cnt_pause = 35;
        }
    }

    protected void drawStats() {
        int lh = 3 * this.num[0].height * this.DOOM.vs.getScalingY() / 2;
        this.slamBackground();
        this.drawAnimatedBack();
        this.drawLF();
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.kills, this.DOOM.vs, SP_STATSX, SP_STATSY, 65536);
        this.drawPercent(this.DOOM.vs.getScreenWidth() - SP_STATSX, SP_STATSY, this.cnt_kills[0]);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.items, this.DOOM.vs, SP_STATSX, SP_STATSY + lh, 65536);
        this.drawPercent(this.DOOM.vs.getScreenWidth() - SP_STATSX, SP_STATSY + lh, this.cnt_items[0]);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.sp_secret, this.DOOM.vs, SP_STATSX, SP_STATSY + 2 * lh, 65536);
        this.drawPercent(this.DOOM.vs.getScreenWidth() - SP_STATSX, SP_STATSY + 2 * lh, this.cnt_secret[0]);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.time, this.DOOM.vs, SP_TIMEX, SP_TIMEY, 65536);
        this.drawTime(this.DOOM.vs.getScreenWidth() / 2 - SP_TIMEX, SP_TIMEY, this.cnt_time);
        if (this.wbs.epsd < 3) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.par, this.DOOM.vs, this.DOOM.vs.getScreenWidth() / 2 + SP_TIMEX, SP_TIMEY, 65536);
            this.drawTime(this.DOOM.vs.getScreenWidth() - SP_TIMEX, SP_TIMEY, this.cnt_par);
        }
    }

    protected void checkForAccelerate() {
        for (int i = 0; i < 4; ++i) {
            player_t player = this.DOOM.players[i];
            if (!this.DOOM.playeringame[i]) continue;
            if ((player.cmd.buttons & '\u0001') != 0) {
                if (!player.attackdown) {
                    this.acceleratestage = 1;
                }
                player.attackdown = true;
            } else {
                player.attackdown = false;
            }
            if ((player.cmd.buttons & 2) != 0) {
                if (!player.usedown) {
                    this.acceleratestage = 1;
                }
                player.usedown = true;
                continue;
            }
            player.usedown = false;
        }
    }

    public void Ticker() {
        ++this.bcnt;
        if (this.bcnt == 1) {
            if (this.DOOM.isCommercial()) {
                this.DOOM.doomSound.ChangeMusic(sounds.musicenum_t.mus_dm2int.ordinal(), true);
            } else {
                this.DOOM.doomSound.ChangeMusic(sounds.musicenum_t.mus_inter.ordinal(), true);
            }
        }
        this.checkForAccelerate();
        switch (this.state) {
            case StatCount: {
                if (this.DOOM.deathmatch) {
                    this.updateDeathmatchStats();
                    break;
                }
                if (this.DOOM.netgame) {
                    this.updateNetgameStats();
                    break;
                }
                this.updateStats();
                break;
            }
            case ShowNextLoc: {
                this.updateShowNextLoc();
                break;
            }
            case NoState: {
                this.updateNoState();
                break;
            }
            case JustShutOff: {
                this.state = endlevel_state.NoState;
            }
        }
    }

    protected void loadData() {
        int i;
        String xxx;
        String name = this.DOOM.isCommercial() ? "INTERPIC" : "WIMAP" + Integer.toString(this.wbs.epsd);
        if (this.DOOM.isRetail() && this.wbs.epsd == 3) {
            name = "INTERPIC";
        }
        this.bg = this.DOOM.wadLoader.CacheLumpName(name, 101, patch_t.class);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.BG, this.bg, this.DOOM.vs, 0, 0, 0x4000000);
        if (this.DOOM.isCommercial()) {
            this.NUMCMAPS = 32;
            this.lnames = new patch_t[this.NUMCMAPS];
            xxx = "CWILV%02d";
            for (i = 0; i < this.NUMCMAPS; ++i) {
                name = String.format(xxx, i);
                this.lnames[i] = this.DOOM.wadLoader.CacheLumpName(name, 1, patch_t.class);
            }
        } else {
            this.lnames = new patch_t[9];
            xxx = "WILV%d%d";
            for (i = 0; i < 9; ++i) {
                name = String.format(xxx, this.wbs.epsd, i);
                this.lnames[i] = this.DOOM.wadLoader.CacheLumpName(name, 1, patch_t.class);
            }
            this.yah[0] = this.DOOM.wadLoader.CacheLumpName("WIURH0", 1, patch_t.class);
            this.yah[1] = this.DOOM.wadLoader.CacheLumpName("WIURH1", 1, patch_t.class);
            this.yah[2] = null;
            this.splat = new patch_t[]{this.DOOM.wadLoader.CacheLumpName("WISPLAT", 1, patch_t.class), null};
            if (this.wbs.epsd < 3) {
                xxx = "WIA%d%02d%02d";
                for (int j = 0; j < NUMANIMS[this.wbs.epsd]; ++j) {
                    anim_t a = anims[this.wbs.epsd][j];
                    for (int i2 = 0; i2 < a.nanims; ++i2) {
                        if (this.wbs.epsd != 1 || j != 8) {
                            name = String.format(xxx, this.wbs.epsd, j, i2);
                            a.p[i2] = this.DOOM.wadLoader.CacheLumpName(name, 1, patch_t.class);
                            continue;
                        }
                        a.p[i2] = EndLevel.anims[1][4].p[i2];
                    }
                }
            }
        }
        this.wiminus = this.DOOM.wadLoader.CacheLumpName("WIMINUS", 1, patch_t.class);
        xxx = "WINUM%d";
        for (i = 0; i < 10; ++i) {
            name = String.format(xxx, i);
            this.num[i] = this.DOOM.wadLoader.CacheLumpName(name, 1, patch_t.class);
        }
        this.percent = this.DOOM.wadLoader.CacheLumpName("WIPCNT", 1, patch_t.class);
        this.finished = this.DOOM.wadLoader.CacheLumpName("WIF", 1, patch_t.class);
        this.entering = this.DOOM.wadLoader.CacheLumpName("WIENTER", 1, patch_t.class);
        this.kills = this.DOOM.wadLoader.CacheLumpName("WIOSTK", 1, patch_t.class);
        this.secret = this.DOOM.wadLoader.CacheLumpName("WIOSTS", 1, patch_t.class);
        this.sp_secret = this.DOOM.wadLoader.CacheLumpName("WISCRT2", 1, patch_t.class);
        this.items = this.DOOM.language == Language_t.french ? (this.DOOM.netgame && !this.DOOM.deathmatch ? this.DOOM.wadLoader.CacheLumpName("WIOBJ", 1, patch_t.class) : this.DOOM.wadLoader.CacheLumpName("WIOSTI", 1, patch_t.class)) : this.DOOM.wadLoader.CacheLumpName("WIOSTI", 1, patch_t.class);
        this.frags = this.DOOM.wadLoader.CacheLumpName("WIFRGS", 1, patch_t.class);
        this.colon = this.DOOM.wadLoader.CacheLumpName("WICOLON", 1, patch_t.class);
        this.time = this.DOOM.wadLoader.CacheLumpName("WITIME", 1, patch_t.class);
        this.sucks = this.DOOM.wadLoader.CacheLumpName("WISUCKS", 1, patch_t.class);
        this.par = this.DOOM.wadLoader.CacheLumpName("WIPAR", 1, patch_t.class);
        this.killers = this.DOOM.wadLoader.CacheLumpName("WIKILRS", 1, patch_t.class);
        this.victims = this.DOOM.wadLoader.CacheLumpName("WIVCTMS", 1, patch_t.class);
        this.total = this.DOOM.wadLoader.CacheLumpName("WIMSTT", 1, patch_t.class);
        this.star = this.DOOM.wadLoader.CacheLumpName("STFST01", 1, patch_t.class);
        this.bstar = this.DOOM.wadLoader.CacheLumpName("STFDEAD0", 1, patch_t.class);
        String xx1 = "STPB%d";
        String xx2 = "WIBP%d";
        for (int i3 = 0; i3 < 4; ++i3) {
            name = String.format(xx1, i3);
            this.p[i3] = this.DOOM.wadLoader.CacheLumpName(name, 1, patch_t.class);
            name = String.format(xx2, i3 + 1);
            this.bp[i3] = this.DOOM.wadLoader.CacheLumpName(name, 1, patch_t.class);
        }
    }

    public void Drawer() {
        switch (this.state) {
            case StatCount: {
                if (this.DOOM.deathmatch) {
                    this.drawDeathmatchStats();
                    break;
                }
                if (this.DOOM.netgame) {
                    this.drawNetgameStats();
                    break;
                }
                this.drawStats();
                break;
            }
            case ShowNextLoc: {
                this.drawShowNextLoc();
                break;
            }
            case NoState: {
                this.drawNoState();
                break;
            }
        }
    }

    protected void initVariables(wbstartstruct_t wbstartstruct) {
        this.wbs = wbstartstruct.clone();
        if (!this.DOOM.isCommercial()) {
            if (this.DOOM.isRetail()) {
                EndLevel.RNGCHECK(this.wbs.epsd, 0, 3);
            } else {
                EndLevel.RNGCHECK(this.wbs.epsd, 0, 2);
            }
        } else {
            EndLevel.RNGCHECK(this.wbs.last, 0, 8);
            EndLevel.RNGCHECK(this.wbs.next, 0, 8);
        }
        EndLevel.RNGCHECK(this.wbs.pnum, 0, 4);
        EndLevel.RNGCHECK(this.wbs.pnum, 0, 4);
        this.acceleratestage = 0;
        this.bcnt = 0;
        this.cnt = 0;
        this.firstrefresh = 1;
        this.me = this.wbs.pnum;
        this.plrs = (wbplayerstruct_t[])this.wbs.plyr.clone();
        if (this.wbs.maxkills == 0) {
            this.wbs.maxkills = 1;
        }
        if (this.wbs.maxitems == 0) {
            this.wbs.maxitems = 1;
        }
        if (this.wbs.maxsecret == 0) {
            this.wbs.maxsecret = 1;
        }
        if (!this.DOOM.isRetail() && this.wbs.epsd > 2) {
            this.wbs.epsd -= 3;
        }
    }

    public void Start(wbstartstruct_t wbstartstruct) {
        this.initVariables(wbstartstruct);
        this.loadData();
        if (this.DOOM.deathmatch) {
            this.initDeathmatchStats();
        } else if (this.DOOM.netgame) {
            this.initNetgameStats();
        } else {
            this.initStats();
        }
    }

    protected int NG_STATSX() {
        return 32 + this.star.width / 2 + 32 * (this.dofrags <= 0 ? 1 : 0);
    }

    protected static boolean RNGCHECK(int what, int min, int max) {
        return what >= min && what <= max;
    }

    static {
        SP_KILLS = 0;
        SP_ITEMS = 2;
        SP_SECRET = 4;
        SP_FRAGS = 6;
        SP_PAR = SP_TIME = 8;
    }

    static enum endlevel_state {
        NoState,
        StatCount,
        ShowNextLoc,
        JustShutOff;

    }
}

