/*
 * Decompiled with CFR 0.152.
 */
package f;

import data.info;
import data.mobjtype_t;
import data.sounds;
import data.state_t;
import defines.gamestate_t;
import defines.statenum_t;
import doom.DoomMain;
import doom.event_t;
import doom.evtype_t;
import doom.gameaction_t;
import f.castinfo_t;
import java.awt.Rectangle;
import m.Settings;
import mochadoom.Engine;
import rr.flat_t;
import rr.patch_t;
import rr.spritedef_t;
import rr.spriteframe_t;
import utils.C2JUtils;
import v.graphics.Blocks;
import v.renderers.DoomScreen;

public class Finale<T> {
    final DoomMain<T, ?> DOOM;
    int finalestage;
    int finalecount;
    private static final int TEXTSPEED = 3;
    private static final int TEXTWAIT = 250;
    static final String[] doom_text = new String[]{"Once you beat the big badasses and\nclean out the moon base you're supposed\nto win, aren't you? Aren't you? Where's\nyour fat reward and ticket home? What\nthe hell is this? It's not supposed to\nend this way!\n\nIt stinks like rotten meat, but looks\nlike the lost Deimos base.  Looks like\nyou're stuck on The Shores of Hell.\nThe only way out is through.\n\nTo continue the DOOM experience, play\nThe Shores of Hell and its amazing\nsequel, Inferno!\n", "You've done it! The hideous cyber-\ndemon lord that ruled the lost Deimos\nmoon base has been slain and you\nare triumphant! But ... where are\nyou? You clamber to the edge of the\nmoon and look down to see the awful\ntruth.\n\nDeimos floats above Hell itself!\nYou've never heard of anyone escaping\nfrom Hell, but you'll make the bastards\nsorry they ever heard of you! Quickly,\nyou rappel down to  the surface of\nHell.\n\nNow, it's on to the final chapter of\nDOOM! -- Inferno.", "The loathsome spiderdemon that\nmasterminded the invasion of the moon\nbases and caused so much death has had\nits ass kicked for all time.\n\nA hidden doorway opens and you enter.\nYou've proven too tough for Hell to\ncontain, and now Hell at last plays\nfair -- for you emerge from the door\nto see the green fields of Earth!\nHome at last.\n\nYou wonder what's been happening on\nEarth while you were battling evil\nunleashed. It's good that no Hell-\nspawn could have come through that\ndoor with you ...", "the spider mastermind must have sent forth\nits legions of hellspawn before your\nfinal confrontation with that terrible\nbeast from hell.  but you stepped forward\nand brought forth eternal damnation and\nsuffering upon the horde as a true hero\nwould in the face of something so evil.\n\nbesides, someone was gonna pay for what\nhappened to daisy, your pet rabbit.\n\nbut now, you see spread before you more\npotential pain and gibbitude as a nation\nof demons run amok among our cities.\n\nnext stop, hell on earth!"};
    static final String[] doom2_text = new String[]{"YOU HAVE ENTERED DEEPLY INTO THE INFESTED\nSTARPORT. BUT SOMETHING IS WRONG. THE\nMONSTERS HAVE BROUGHT THEIR OWN REALITY\nWITH THEM, AND THE STARPORT'S TECHNOLOGY\nIS BEING SUBVERTED BY THEIR PRESENCE.\n\nAHEAD, YOU SEE AN OUTPOST OF HELL, A\nFORTIFIED ZONE. IF YOU CAN GET PAST IT,\nYOU CAN PENETRATE INTO THE HAUNTED HEART\nOF THE STARBASE AND FIND THE CONTROLLING\nSWITCH WHICH HOLDS EARTH'S POPULATION\nHOSTAGE.", "YOU HAVE WON! YOUR VICTORY HAS ENABLED\nHUMANKIND TO EVACUATE EARTH AND ESCAPE\nTHE NIGHTMARE.  NOW YOU ARE THE ONLY\nHUMAN LEFT ON THE FACE OF THE PLANET.\nCANNIBAL MUTATIONS, CARNIVOROUS ALIENS,\nAND EVIL SPIRITS ARE YOUR ONLY NEIGHBORS.\nYOU SIT BACK AND WAIT FOR DEATH, CONTENT\nTHAT YOU HAVE SAVED YOUR SPECIES.\n\nBUT THEN, EARTH CONTROL BEAMS DOWN A\nMESSAGE FROM SPACE: \"SENSORS HAVE LOCATED\nTHE SOURCE OF THE ALIEN INVASION. IF YOU\nGO THERE, YOU MAY BE ABLE TO BLOCK THEIR\nENTRY.  THE ALIEN BASE IS IN THE HEART OF\nYOUR OWN HOME CITY, NOT FAR FROM THE\nSTARPORT.\" SLOWLY AND PAINFULLY YOU GET\nUP AND RETURN TO THE FRAY.", "YOU ARE AT THE CORRUPT HEART OF THE CITY,\nSURROUNDED BY THE CORPSES OF YOUR ENEMIES.\nYOU SEE NO WAY TO DESTROY THE CREATURES'\nENTRYWAY ON THIS SIDE, SO YOU CLENCH YOUR\nTEETH AND PLUNGE THROUGH IT.\n\nTHERE MUST BE A WAY TO CLOSE IT ON THE\nOTHER SIDE. WHAT DO YOU CARE IF YOU'VE\nGOT TO GO THROUGH HELL TO GET TO IT?", "THE HORRENDOUS VISAGE OF THE BIGGEST\nDEMON YOU'VE EVER SEEN CRUMBLES BEFORE\nYOU, AFTER YOU PUMP YOUR ROCKETS INTO\nHIS EXPOSED BRAIN. THE MONSTER SHRIVELS\nUP AND DIES, ITS THRASHING LIMBS\nDEVASTATING UNTOLD MILES OF HELL'S\nSURFACE.\n\nYOU'VE DONE IT. THE INVASION IS OVER.\nEARTH IS SAVED. HELL IS A WRECK. YOU\nWONDER WHERE BAD FOLKS WILL GO WHEN THEY\nDIE, NOW. WIPING THE SWEAT FROM YOUR\nFOREHEAD YOU BEGIN THE LONG TREK BACK\nHOME. REBUILDING EARTH OUGHT TO BE A\nLOT MORE FUN THAN RUINING IT WAS.\n", "CONGRATULATIONS, YOU'VE FOUND THE SECRET\nLEVEL! LOOKS LIKE IT'S BEEN BUILT BY\nHUMANS, RATHER THAN DEMONS. YOU WONDER\nWHO THE INMATES OF THIS CORNER OF HELL\nWILL BE.", "CONGRATULATIONS, YOU'VE FOUND THE\nSUPER SECRET LEVEL!  YOU'D BETTER\nBLAZE THROUGH THIS ONE!\n"};
    static final String[] plut_text = new String[]{"You gloat over the steaming carcass of the\nGuardian.  With its death, you've wrested\nthe Accelerator from the stinking claws\nof Hell.  You relax and glance around the\nroom.  Damn!  There was supposed to be at\nleast one working prototype, but you can't\nsee it. The demons must have taken it.\n\nYou must find the prototype, or all your\nstruggles will have been wasted. Keep\nmoving, keep fighting, keep killing.\nOh yes, keep living, too.", "Even the deadly Arch-Vile labyrinth could\nnot stop you, and you've gotten to the\nprototype Accelerator which is soon\nefficiently and permanently deactivated.\n\nYou're good at that kind of thing.", "You've bashed and battered your way into\nthe heart of the devil-hive.  Time for a\nSearch-and-Destroy mission, aimed at the\nGatekeeper, whose foul offspring is\ncascading to Earth.  Yeah, he's bad. But\nyou know who's worse!\n\nGrinning evilly, you check your gear, and\nget ready to give the bastard a little Hell\nof your own making!", "The Gatekeeper's evil face is splattered\nall over the place.  As its tattered corpse\ncollapses, an inverted Gate forms and\nsucks down the shards of the last\nprototype Accelerator, not to mention the\nfew remaining demons.  You're done. Hell\nhas gone back to pounding bad dead folks \ninstead of good live ones.  Remember to\ntell your grandkids to put a rocket\nlauncher in your coffin. If you go to Hell\nwhen you die, you'll need it for some\nfinal cleaning-up ...", "You've found the second-hardest level we\ngot. Hope you have a saved game a level or\ntwo previous.  If not, be prepared to die\naplenty. For master marines only.", "Betcha wondered just what WAS the hardest\nlevel we had ready for ya?  Now you know.\nNo one gets out alive."};
    static final String[] tnt_text = new String[]{"You've fought your way out of the infested\nexperimental labs.   It seems that UAC has\nonce again gulped it down.  With their\nhigh turnover, it must be hard for poor\nold UAC to buy corporate health insurance\nnowadays..\n\nAhead lies the military complex, now\nswarming with diseased horrors hot to get\ntheir teeth into you. With luck, the\ncomplex still has some warlike ordnance\nlaying around.", "You hear the grinding of heavy machinery\nahead.  You sure hope they're not stamping\nout new hellspawn, but you're ready to\nream out a whole herd if you have to.\nThey might be planning a blood feast, but\nyou feel about as mean as two thousand\nmaniacs packed into one mad killer.\n\nYou don't plan to go down easy.", "The vista opening ahead looks real damn\nfamiliar. Smells familiar, too -- like\nfried excrement. You didn't like this\nplace before, and you sure as hell ain't\nplanning to like it now. The more you\nbrood on it, the madder you get.\nHefting your gun, an evil grin trickles\nonto your face. Time to take some names.", "Suddenly, all is silent, from one horizon\nto the other. The agonizing echo of Hell\nfades away, the nightmare sky turns to\nblue, the heaps of monster corpses start \nto evaporate along with the evil stench \nthat filled the air. Jeeze, maybe you've\ndone it. Have you really won?\n\nSomething rumbles in the distance.\nA blue light begins to glow inside the\nruined skull of the demon-spitter.", "What now? Looks totally different. Kind\nof like King Tut's condo. Well,\nwhatever's here can't be any worse\nthan usual. Can it?  Or maybe it's best\nto let sleeping gods lie..", "Time for a vacation. You've burst the\nbowels of hell and by golly you're ready\nfor a break. You mutter to yourself,\nMaybe someone else can kick Hell's ass\nnext time around. Ahead lies a quiet town,\nwith peaceful flowing water, quaint\nbuildings, and presumably no Hellspawn.\n\nAs you step off the transport, you hear\nthe stomp of a cyberdemon's iron shoe."};
    String finaletext;
    String finaleflat;
    patch_t[] hu_font;
    private final castinfo_t[] castorder;
    int castnum;
    int casttics;
    state_t caststate;
    boolean castdeath;
    int castframes;
    int castonmelee;
    boolean castattacking;
    protected int laststage;

    public void StartFinale() {
        this.DOOM.setGameAction(gameaction_t.ga_nothing);
        this.DOOM.gamestate = gamestate_t.GS_FINALE;
        this.DOOM.viewactive = false;
        this.DOOM.automapactive = false;
        String[] texts = null;
        switch (this.DOOM.getGameMode()) {
            case commercial: 
            case pack_xbla: 
            case freedoom2: 
            case freedm: {
                texts = doom2_text;
                break;
            }
            case pack_tnt: {
                texts = tnt_text;
                break;
            }
            case pack_plut: {
                texts = plut_text;
                break;
            }
            case shareware: 
            case registered: 
            case retail: 
            case freedoom1: {
                texts = doom_text;
                break;
            }
        }
        block6 : switch (this.DOOM.getGameMode()) {
            case shareware: 
            case registered: 
            case retail: 
            case freedoom1: {
                this.DOOM.doomSound.ChangeMusic(sounds.musicenum_t.mus_victor, true);
                switch (this.DOOM.gameepisode) {
                    case 1: {
                        this.finaleflat = "FLOOR4_8";
                        this.finaletext = texts[0];
                        break block6;
                    }
                    case 2: {
                        this.finaleflat = "SFLR6_1";
                        this.finaletext = texts[1];
                        break block6;
                    }
                    case 3: {
                        this.finaleflat = "MFLR8_4";
                        this.finaletext = texts[2];
                        break block6;
                    }
                    case 4: {
                        this.finaleflat = "MFLR8_3";
                        this.finaletext = texts[3];
                        break block6;
                    }
                }
                break;
            }
            case commercial: 
            case pack_xbla: 
            case freedoom2: 
            case freedm: 
            case pack_tnt: 
            case pack_plut: {
                this.DOOM.doomSound.ChangeMusic(sounds.musicenum_t.mus_read_m, true);
                switch (this.DOOM.gamemap) {
                    case 6: {
                        this.finaleflat = "SLIME16";
                        this.finaletext = texts[0];
                        break block6;
                    }
                    case 11: {
                        this.finaleflat = "RROCK14";
                        this.finaletext = texts[1];
                        break block6;
                    }
                    case 20: {
                        this.finaleflat = "RROCK07";
                        this.finaletext = texts[2];
                        break block6;
                    }
                    case 30: {
                        this.finaleflat = "RROCK17";
                        this.finaletext = texts[3];
                        break block6;
                    }
                    case 15: {
                        this.finaleflat = "RROCK13";
                        this.finaletext = texts[4];
                        break block6;
                    }
                    case 31: {
                        this.finaleflat = "RROCK19";
                        this.finaletext = texts[5];
                        break block6;
                    }
                }
                break;
            }
            default: {
                this.DOOM.doomSound.ChangeMusic(sounds.musicenum_t.mus_read_m, true);
                this.finaleflat = "F_SKY1";
                this.finaletext = doom2_text[1];
            }
        }
        this.finalestage = 0;
        this.finalecount = 0;
    }

    public boolean Responder(event_t event) {
        if (this.finalestage == 2) {
            return this.CastResponder(event);
        }
        return false;
    }

    public void Ticker() {
        if (this.DOOM.isCommercial() && this.finalecount > 50) {
            int i;
            for (i = 0; i < 4 && this.DOOM.players[i].cmd.buttons == '\u0000'; ++i) {
            }
            if (i < 4) {
                if (this.DOOM.gamemap == 30) {
                    this.StartCast();
                } else {
                    this.DOOM.setGameAction(gameaction_t.ga_worlddone);
                }
            }
        }
        ++this.finalecount;
        if (this.finalestage == 2) {
            this.CastTicker();
            return;
        }
        if (this.DOOM.isCommercial()) {
            return;
        }
        if (this.finalestage == 0 && this.finalecount > this.finaletext.length() * 3 + 250) {
            this.finalecount = 0;
            this.finalestage = 1;
            this.DOOM.wipegamestate = gamestate_t.GS_MINUS_ONE;
            if (this.DOOM.gameepisode == 3) {
                this.DOOM.doomSound.StartMusic(sounds.musicenum_t.mus_bunny);
            }
        }
    }

    public void TextWrite() {
        int c;
        byte[] src = this.DOOM.wadLoader.CacheLumpName((String)this.finaleflat, (int)101, flat_t.class).data;
        if (Engine.getConfig().equals(Settings.scale_screen_tiles, Boolean.TRUE)) {
            Object scaled = ((Blocks)((Object)this.DOOM.graphicSystem)).ScaleBlock(this.DOOM.graphicSystem.convertPalettedBlock(src), 64, 64, this.DOOM.graphicSystem.getScalingX(), this.DOOM.graphicSystem.getScalingY());
            ((Blocks)((Object)this.DOOM.graphicSystem)).TileScreen(DoomScreen.FG, scaled, new Rectangle(0, 0, 64 * this.DOOM.graphicSystem.getScalingX(), 64 * this.DOOM.graphicSystem.getScalingY()));
        } else {
            ((Blocks)((Object)this.DOOM.graphicSystem)).TileScreen(DoomScreen.FG, this.DOOM.graphicSystem.convertPalettedBlock(src), new Rectangle(0, 0, 64, 64));
        }
        int cx = 10;
        int cy = 10;
        char[] ch = this.finaletext.toCharArray();
        int count = (this.finalecount - 10) / 3;
        if (count < 0) {
            count = 0;
        }
        for (int i = 0; i < Math.min(ch.length, count) && (c = ch[i]) != 0; ++i) {
            if (c == 10) {
                cx = 10;
                cy += 11;
                continue;
            }
            if ((c = Character.toUpperCase(c) - 33) < 0 || c > 63) {
                cx += 4;
                continue;
            }
            if (cx + this.hu_font[c].width > this.DOOM.vs.getScreenWidth()) break;
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.hu_font[c], this.DOOM.vs, cx, cy, new int[0]);
            cx += this.hu_font[c].width;
        }
    }

    public void StartCast() {
        this.DOOM.wipegamestate = gamestate_t.GS_MINUS_ONE;
        this.castnum = 0;
        this.caststate = info.states[info.mobjinfo[this.castorder[this.castnum].type.ordinal()].seestate.ordinal()];
        this.casttics = this.caststate.tics;
        this.castdeath = false;
        this.finalestage = 2;
        this.castframes = 0;
        this.castonmelee = 0;
        this.castattacking = false;
        this.DOOM.doomSound.ChangeMusic(sounds.musicenum_t.mus_evil, true);
    }

    public void CastTicker() {
        if (--this.casttics > 0) {
            return;
        }
        if (this.caststate.tics == -1 || this.caststate.nextstate == statenum_t.S_NULL || this.caststate.nextstate == null) {
            ++this.castnum;
            this.castdeath = false;
            if (this.castorder[this.castnum].name == null) {
                this.castnum = 0;
            }
            if (info.mobjinfo[this.castorder[this.castnum].type.ordinal()].seesound.ordinal() != 0) {
                this.DOOM.doomSound.StartSound(null, info.mobjinfo[this.castorder[this.castnum].type.ordinal()].seesound);
            }
            this.caststate = info.states[info.mobjinfo[this.castorder[this.castnum].type.ordinal()].seestate.ordinal()];
            this.castframes = 0;
        } else {
            sounds.sfxenum_t sfx;
            if (this.caststate == info.states[statenum_t.S_PLAY_ATK1.ordinal()]) {
                this.stopattack();
                this.afterstopattack();
                return;
            }
            statenum_t st = this.caststate.nextstate;
            this.caststate = info.states[st.ordinal()];
            ++this.castframes;
            switch (st) {
                case S_PLAY_ATK1: {
                    sfx = sounds.sfxenum_t.sfx_dshtgn;
                    break;
                }
                case S_POSS_ATK2: {
                    sfx = sounds.sfxenum_t.sfx_pistol;
                    break;
                }
                case S_SPOS_ATK2: {
                    sfx = sounds.sfxenum_t.sfx_shotgn;
                    break;
                }
                case S_VILE_ATK2: {
                    sfx = sounds.sfxenum_t.sfx_vilatk;
                    break;
                }
                case S_SKEL_FIST2: {
                    sfx = sounds.sfxenum_t.sfx_skeswg;
                    break;
                }
                case S_SKEL_FIST4: {
                    sfx = sounds.sfxenum_t.sfx_skepch;
                    break;
                }
                case S_SKEL_MISS2: {
                    sfx = sounds.sfxenum_t.sfx_skeatk;
                    break;
                }
                case S_FATT_ATK8: 
                case S_FATT_ATK5: 
                case S_FATT_ATK2: {
                    sfx = sounds.sfxenum_t.sfx_firsht;
                    break;
                }
                case S_CPOS_ATK2: 
                case S_CPOS_ATK3: 
                case S_CPOS_ATK4: {
                    sfx = sounds.sfxenum_t.sfx_shotgn;
                    break;
                }
                case S_TROO_ATK3: {
                    sfx = sounds.sfxenum_t.sfx_claw;
                    break;
                }
                case S_SARG_ATK2: {
                    sfx = sounds.sfxenum_t.sfx_sgtatk;
                    break;
                }
                case S_BOSS_ATK2: 
                case S_BOS2_ATK2: 
                case S_HEAD_ATK2: {
                    sfx = sounds.sfxenum_t.sfx_firsht;
                    break;
                }
                case S_SKULL_ATK2: {
                    sfx = sounds.sfxenum_t.sfx_sklatk;
                    break;
                }
                case S_SPID_ATK2: 
                case S_SPID_ATK3: {
                    sfx = sounds.sfxenum_t.sfx_shotgn;
                    break;
                }
                case S_BSPI_ATK2: {
                    sfx = sounds.sfxenum_t.sfx_plasma;
                    break;
                }
                case S_CYBER_ATK2: 
                case S_CYBER_ATK4: 
                case S_CYBER_ATK6: {
                    sfx = sounds.sfxenum_t.sfx_rlaunc;
                    break;
                }
                case S_PAIN_ATK3: {
                    sfx = sounds.sfxenum_t.sfx_sklatk;
                    break;
                }
                default: {
                    sfx = null;
                }
            }
            if (sfx != null) {
                this.DOOM.doomSound.StartSound(null, sfx);
            }
        }
        if (this.castframes == 12) {
            this.castattacking = true;
            this.caststate = this.castonmelee != 0 ? info.states[info.mobjinfo[this.castorder[this.castnum].type.ordinal()].meleestate.ordinal()] : info.states[info.mobjinfo[this.castorder[this.castnum].type.ordinal()].missilestate.ordinal()];
            this.castonmelee ^= 1;
            if (this.caststate == info.states[statenum_t.S_NULL.ordinal()]) {
                this.caststate = this.castonmelee != 0 ? info.states[info.mobjinfo[this.castorder[this.castnum].type.ordinal()].meleestate.ordinal()] : info.states[info.mobjinfo[this.castorder[this.castnum].type.ordinal()].missilestate.ordinal()];
            }
        }
        if (this.castattacking && (this.castframes == 24 || this.caststate == info.states[info.mobjinfo[this.castorder[this.castnum].type.ordinal()].seestate.ordinal()])) {
            this.stopattack();
        }
        this.afterstopattack();
    }

    protected void stopattack() {
        this.castattacking = false;
        this.castframes = 0;
        this.caststate = info.states[info.mobjinfo[this.castorder[this.castnum].type.ordinal()].seestate.ordinal()];
    }

    protected void afterstopattack() {
        this.casttics = this.caststate.tics;
        if (this.casttics == -1) {
            this.casttics = 15;
        }
    }

    public boolean CastResponder(event_t ev) {
        if (!ev.isType(evtype_t.ev_keydown)) {
            return false;
        }
        if (this.castdeath) {
            return true;
        }
        this.castdeath = true;
        this.caststate = info.states[info.mobjinfo[this.castorder[this.castnum].type.ordinal()].deathstate.ordinal()];
        this.casttics = this.caststate.tics;
        this.castframes = 0;
        this.castattacking = false;
        if (info.mobjinfo[this.castorder[this.castnum].type.ordinal()].deathsound != null) {
            this.DOOM.doomSound.StartSound(null, info.mobjinfo[this.castorder[this.castnum].type.ordinal()].deathsound);
        }
        return true;
    }

    public void CastPrint(String text) {
        int c;
        int width = 0;
        char[] ch = text.toCharArray();
        for (int i = 0; i < ch.length && (c = ch[i]) != 0; ++i) {
            if ((c = Character.toUpperCase(c) - 33) < 0 || c > 63) {
                width += 4;
                continue;
            }
            width += this.hu_font[c].width;
        }
        int cx = 160 - width / 2;
        for (int i = 0; i < ch.length && (c = ch[i]) != 0; ++i) {
            if ((c = Character.toUpperCase(c) - 33) < 0 || c > 63) {
                cx += 4;
                continue;
            }
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.hu_font[c], this.DOOM.vs, cx, 180, new int[0]);
            cx += this.hu_font[c].width;
        }
    }

    public void CastDrawer() {
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("BOSSBACK", 101), this.DOOM.vs, 0, 0, new int[0]);
        this.CastPrint(this.castorder[this.castnum].name);
        spritedef_t sprdef = this.DOOM.spriteManager.getSprite(this.caststate.sprite.ordinal());
        spriteframe_t sprframe = sprdef.spriteframes[this.caststate.frame & Short.MAX_VALUE];
        int lump = sprframe.lump[0];
        boolean flip = C2JUtils.eval(sprframe.flip[0]);
        patch_t patch = this.DOOM.wadLoader.CachePatchNum(lump + this.DOOM.spriteManager.getFirstSpriteLump());
        if (flip) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, patch, this.DOOM.vs, 160, 170, 0x200000);
        } else {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, patch, this.DOOM.vs, 160, 170, new int[0]);
        }
    }

    public void BunnyScroll() {
        patch_t p1 = this.DOOM.wadLoader.CachePatchName("PFUB2", 50);
        patch_t p2 = this.DOOM.wadLoader.CachePatchName("PFUB1", 50);
        int scrolled = 320 - (this.finalecount - 230) / 2;
        if (scrolled > 320) {
            scrolled = 320;
        }
        if (scrolled < 0) {
            scrolled = 0;
        }
        for (int x = 0; x < 320; ++x) {
            if (x + scrolled < 320) {
                this.DOOM.graphicSystem.DrawPatchColScaled(DoomScreen.FG, p1, this.DOOM.vs, x, x + scrolled);
                continue;
            }
            this.DOOM.graphicSystem.DrawPatchColScaled(DoomScreen.FG, p2, this.DOOM.vs, x, x + scrolled - 320);
        }
        if (this.finalecount < 1130) {
            return;
        }
        if (this.finalecount < 1180) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("END0", 101), this.DOOM.vs, 108, 68, new int[0]);
            this.laststage = 0;
            return;
        }
        int stage = (this.finalecount - 1180) / 5;
        if (stage > 6) {
            stage = 6;
        }
        if (stage > this.laststage) {
            this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
            this.laststage = stage;
        }
        String name = "END" + stage;
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName(name, 101), this.DOOM.vs, 108, 68, new int[0]);
    }

    public void Drawer() {
        if (this.finalestage == 2) {
            this.CastDrawer();
            return;
        }
        if (this.finalestage == 0) {
            this.TextWrite();
        } else {
            switch (this.DOOM.gameepisode) {
                case 1: {
                    if (this.DOOM.isCommercial() || this.DOOM.isRegistered()) {
                        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("CREDIT", 101), this.DOOM.vs, 0, 0, new int[0]);
                        break;
                    }
                    this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("HELP2", 101), this.DOOM.vs, 0, 0, new int[0]);
                    break;
                }
                case 2: {
                    this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("VICTORY2", 101), this.DOOM.vs, 0, 0, new int[0]);
                    break;
                }
                case 3: {
                    this.BunnyScroll();
                    break;
                }
                case 4: {
                    this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("ENDPIC", 101), this.DOOM.vs, 0, 0, new int[0]);
                }
            }
        }
    }

    public Finale(DoomMain<T, ?> DOOM) {
        this.DOOM = DOOM;
        this.hu_font = DOOM.headsUp.getHUFonts();
        this.castorder = new castinfo_t[]{new castinfo_t("ZOMBIEMAN", mobjtype_t.MT_POSSESSED), new castinfo_t("SHOTGUN GUY", mobjtype_t.MT_SHOTGUY), new castinfo_t("HEAVY WEAPON DUDE", mobjtype_t.MT_CHAINGUY), new castinfo_t("IMP", mobjtype_t.MT_TROOP), new castinfo_t("DEMON", mobjtype_t.MT_SERGEANT), new castinfo_t("LOST SOUL", mobjtype_t.MT_SKULL), new castinfo_t("CACODEMON", mobjtype_t.MT_HEAD), new castinfo_t("HELL KNIGHT", mobjtype_t.MT_KNIGHT), new castinfo_t("BARON OF HELL", mobjtype_t.MT_BRUISER), new castinfo_t("ARACHNOTRON", mobjtype_t.MT_BABY), new castinfo_t("PAIN ELEMENTAL", mobjtype_t.MT_PAIN), new castinfo_t("REVENANT", mobjtype_t.MT_UNDEAD), new castinfo_t("MANCUBUS", mobjtype_t.MT_FATSO), new castinfo_t("ARCH-VILE", mobjtype_t.MT_VILE), new castinfo_t("THE SPIDER MASTERMIND", mobjtype_t.MT_SPIDER), new castinfo_t("THE CYBERDEMON", mobjtype_t.MT_CYBORG), new castinfo_t("OUR HERO", mobjtype_t.MT_PLAYER), new castinfo_t(null, null)};
    }
}

