/*
 * Decompiled with CFR 0.152.
 */
package g;

import defines.skill_t;
import doom.DoomStatus;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import utils.C2JUtils;
import w.CacheableDoomObject;
import w.DoomBuffer;
import w.DoomIO;
import w.IReadableDoomObject;
import w.IWritableDoomObject;

public class DoomSaveGame
implements CacheableDoomObject,
IReadableDoomObject,
IWritableDoomObject {
    public String name;
    public String vcheck;
    public int gameskill;
    public int gameepisode;
    public int gamemap;
    public boolean[] playeringame = new boolean[4];
    public int leveltime;
    public boolean wrongversion;
    public boolean properend;

    @Override
    public void unpack(ByteBuffer buf) throws IOException {
        this.name = DoomBuffer.getNullTerminatedString(buf, 24);
        this.vcheck = DoomBuffer.getNullTerminatedString(buf, 16);
        String vcheckb = "version 109";
        this.wrongversion = !vcheckb.equalsIgnoreCase(this.vcheck);
        if (this.wrongversion) {
            return;
        }
        this.gameskill = buf.get();
        this.gameepisode = buf.get();
        this.gamemap = buf.get();
        for (int i = 0; i < 4; ++i) {
            this.playeringame[i] = buf.get() != 0;
        }
        int a = C2JUtils.toUnsignedByte(buf.get());
        int b = C2JUtils.toUnsignedByte(buf.get());
        int c = C2JUtils.toUnsignedByte(buf.get());
        this.leveltime = (a << 16) + (b << 8) + c;
        buf.mark();
        buf.position(buf.limit() - 1);
        this.properend = buf.get() == 29;
        buf.reset();
    }

    @Override
    public void write(DataOutputStream f) throws IOException {
        DoomIO.writeString(f, this.name, 24);
        DoomIO.writeString(f, this.vcheck, 16);
        f.writeByte(this.gameskill);
        f.writeByte(this.gameepisode);
        f.writeByte(this.gamemap);
        for (int i = 0; i < 4; ++i) {
            f.writeBoolean(this.playeringame[i]);
        }
        byte a = (byte)(0xFF & this.leveltime >>> 16);
        byte b = (byte)(0xFF & this.leveltime >>> 8);
        byte c = (byte)(0xFF & this.leveltime);
        f.writeByte(a);
        f.writeByte(b);
        f.writeByte(c);
        f.writeByte(29);
    }

    @Override
    public void read(DataInputStream f) throws IOException {
        this.name = DoomIO.readNullTerminatedString(f, 24);
        this.vcheck = DoomIO.readNullTerminatedString(f, 16);
        String vcheckb = "version 109";
        this.wrongversion = !vcheckb.equalsIgnoreCase(this.vcheck);
        if (this.wrongversion) {
            return;
        }
        this.gameskill = f.readByte();
        this.gameepisode = f.readByte();
        this.gamemap = f.readByte();
        this.playeringame = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.playeringame[i] = f.readBoolean();
        }
        int a = f.readUnsignedByte();
        int b = f.readUnsignedByte();
        int c = f.readUnsignedByte();
        this.leveltime = (a << 16) + (b << 8) + c;
        long available = f.available();
        f.skip(available - 1L);
        this.properend = f.readByte() == 29;
    }

    public void toStat(DoomStatus<?, ?> DS) {
        System.arraycopy(this.playeringame, 0, DS.playeringame, 0, this.playeringame.length);
        DS.gameskill = skill_t.values()[this.gameskill];
        DS.gameepisode = this.gameepisode;
        DS.gamemap = this.gamemap;
        DS.leveltime = this.leveltime;
    }

    public void fromStat(DoomStatus<?, ?> DS) {
        System.arraycopy(DS.playeringame, 0, this.playeringame, 0, DS.playeringame.length);
        this.gameskill = DS.gameskill.ordinal();
        this.gameepisode = DS.gameepisode;
        this.gamemap = DS.gamemap;
        this.leveltime = DS.leveltime;
    }
}

