/*
 * Decompiled with CFR 0.152.
 */
package hu;

import data.Defines;
import data.sounds;
import defines.GameMode;
import defines.Language_t;
import doom.DoomMain;
import doom.event_t;
import doom.evtype_t;
import doom.player_t;
import g.Signals;
import hu.IHeadsUp;
import java.awt.Rectangle;
import java.util.Arrays;
import rr.ViewVars;
import rr.patch_t;
import utils.C2JUtils;
import v.renderers.DoomScreen;

public class HU
implements IHeadsUp {
    final DoomMain<?, ?> DOOM;
    String HU_TITLE;
    String HU_TITLE2;
    String HU_TITLEP;
    String HU_TITLET;
    protected static final int HU_TITLEHEIGHT = 1;
    protected static final int HU_TITLEX = 0;
    protected int HU_TITLEY;
    protected static final Signals.ScanCode HU_INPUTTOGGLE = Signals.ScanCode.SC_T;
    protected static final int HU_INPUTX = 0;
    protected int HU_INPUTY;
    protected static final int HU_INPUTWIDTH = 64;
    protected static final int HU_INPUTHEIGHT = 1;
    public String[] chat_macros = new String[]{"No", "I'm ready to kick butt!", "I'm OK.", "I'm not looking too good!", "Help!", "You suck!", "Next time, scumbag...", "Come here!", "I'll take care of it.", "Yes"};
    public static final String[] player_names = new String[]{"Green: ", "Indigo: ", "Brown: ", "Red: "};
    char chat_char;
    player_t plr;
    patch_t[] hu_font = new patch_t[63];
    char[] chat_dest = new char[4];
    hu_itext_t[] w_inputbuffer;
    hu_textline_t w_title;
    hu_itext_t w_chat;
    boolean[] always_off = new boolean[]{false};
    public boolean[] chat_on = new boolean[1];
    boolean[] message_on = new boolean[]{true};
    boolean message_dontfuckwithme;
    boolean message_nottobefuckedwith;
    hu_stext_t w_message;
    int message_counter;
    boolean headsupactive = false;
    protected String[] mapnames = new String[]{"E1M1: Hangar", "E1M2: Nuclear Plant", "E1M3: Toxin Refinery", "E1M4: Command Control", "E1M5: Phobos Lab", "E1M6: Central Processing", "E1M7: Computer Station", "E1M8: Phobos Anomaly", "E1M9: Military Base", "E2M1: Deimos Anomaly", "E2M2: Containment Area", "E2M3: Refinery", "E2M4: Deimos Lab", "E2M5: Command Center", "E2M6: Halls of the Damned", "E2M7: Spawning Vats", "E2M8: Tower of Babel", "E2M9: Fortress of Mystery", "E3M1: Hell Keep", "E3M2: Slough of Despair", "E3M3: Pandemonium", "E3M4: House of Pain", "E3M5: Unholy Cathedral", "E3M6: Mt. Erebus", "E3M7: Limbo", "E3M8: Dis", "E3M9: Warrens", "E4M1: Hell Beneath", "E4M2: Perfect Hatred", "E4M3: Sever The Wicked", "E4M4: Unruly Evil", "E4M5: They Will Repent", "E4M6: Against Thee Wickedly", "E4M7: And Hell Followed", "E4M8: Unto The Cruel", "E4M9: Fear", "NEWLEVEL", "NEWLEVEL", "NEWLEVEL", "NEWLEVEL", "NEWLEVEL", "NEWLEVEL", "NEWLEVEL", "NEWLEVEL", "NEWLEVEL"};
    protected String[] mapnames2 = new String[]{"level 1: entryway", "level 2: underhalls", "level 3: the gantlet", "level 4: the focus", "level 5: the waste tunnels", "level 6: the crusher", "level 7: dead simple", "level 8: tricks and traps", "level 9: the pit", "level 10: refueling base", "level 11: 'o' of destruction!", "level 12: the factory", "level 13: downtown", "level 14: the inmost dens", "level 15: industrial zone", "level 16: suburbs", "level 17: tenements", "level 18: the courtyard", "level 19: the citadel", "level 20: gotcha!", "level 21: nirvana", "level 22: the catacombs", "level 23: barrels o' fun", "level 24: the chasm", "level 25: bloodfalls", "level 26: the abandoned mines", "level 27: monster condo", "level 28: the spirit world", "level 29: the living end", "level 30: icon of sin", "level 31: wolfenstein", "level 32: grosse", "level 33: betray"};
    protected String[] mapnamesp = new String[]{"level 1: congo", "level 2: well of souls", "level 3: aztec", "level 4: caged", "level 5: ghost town", "level 6: baron's lair", "level 7: caughtyard", "level 8: realm", "level 9: abattoire", "level 10: onslaught", "level 11: hunted", "level 12: speed", "level 13: the crypt", "level 14: genesis", "level 15: the twilight", "level 16: the omen", "level 17: compound", "level 18: neurosphere", "level 19: nme", "level 20: the death domain", "level 21: slayer", "level 22: impossible mission", "level 23: tombstone", "level 24: the final frontier", "level 25: the temple of darkness", "level 26: bunker", "level 27: anti-christ", "level 28: the sewers", "level 29: odyssey of noises", "level 30: the gateway of hell", "level 31: cyberden", "level 32: go 2 it"};
    protected String[] mapnamest = new String[]{"level 1: system control", "level 2: human bbq", "level 3: power control", "level 4: wormhole", "level 5: hanger", "level 6: open season", "level 7: prison", "level 8: metal", "level 9: stronghold", "level 10: redemption", "level 11: storage facility", "level 12: crater", "level 13: nukage processing", "level 14: steel works", "level 15: dead zone", "level 16: deepest reaches", "level 17: processing area", "level 18: mill", "level 19: shipping/respawning", "level 20: central processing", "level 21: administration center", "level 22: habitat", "level 23: lunar mining project", "level 24: quarry", "level 25: baron's den", "level 26: ballistyx", "level 27: mount pain", "level 28: heck", "level 29: river styx", "level 30: last call", "level 31: pharaoh", "level 32: caribbean"};
    char[] shiftxform;
    public static final char[] french_shiftxform = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\"', '(', ')', '*', '+', '?', '_', '>', '?', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '/', '.', '<', '+', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '!', ']', '\"', '_', '\'', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};
    public static final char[] english_shiftxform = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\"', '(', ')', '*', '+', '<', '_', '>', '?', ')', '!', '@', '#', '$', '%', '^', '&', '*', '(', ':', ':', '<', '+', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '!', ']', '\"', '_', '\'', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};
    char[] frenchKeyMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '%', '(', ')', '*', '+', ';', '-', ':', '!', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', 'M', '<', '=', '>', '?', '@', 'Q', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', ',', 'N', 'O', 'P', 'A', 'R', 'S', 'T', 'U', 'V', 'Z', 'X', 'Y', 'W', '^', '\\', '$', '^', '_', '@', 'Q', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', ',', 'N', 'O', 'P', 'A', 'R', 'S', 'T', 'U', 'V', 'Z', 'X', 'Y', 'W', '^', '\\', '$', '^', '\u007f'};
    protected final int QUEUESIZE = 128;
    protected char[] chatchars = new char[128];
    protected int head = 0;
    protected int tail = 0;
    protected StringBuilder lastmessage = new StringBuilder(81);
    protected boolean shiftdown = false;
    protected boolean altdown = false;
    protected char[] destination_keys = new char[]{'g', 'i', 'b', 'r'};
    protected int num_nobrainers = 0;

    @Override
    public void setChatMacro(int i, String s) {
        this.chat_macros[i] = s;
    }

    protected final char ForeignTranslation(char ch) {
        return ch < '\u0080' ? this.frenchKeyMap[ch] : ch;
    }

    public HU(DoomMain<?, ?> DOOM) {
        this.DOOM = DOOM;
        this.w_message = new hu_stext_t();
        this.w_inputbuffer = new hu_itext_t[4];
        for (int i = 0; i < 4; ++i) {
            this.w_inputbuffer[i] = new hu_itext_t();
        }
        this.w_title = new hu_textline_t();
        this.w_chat = new hu_itext_t();
    }

    @Override
    public void Init() {
        this.shiftxform = this.DOOM.language == Language_t.french ? french_shiftxform : english_shiftxform;
        int j = 33;
        Arrays.setAll(this.hu_font, i -> new patch_t());
        for (int i2 = 0; i2 < 63; ++i2) {
            String buffer = String.format("STCFN%03d", j++);
            this.hu_font[i2] = this.DOOM.wadLoader.CachePatchName(buffer, 1);
        }
        this.HU_TITLEY = 167 - this.hu_font[0].height;
        this.HU_INPUTY = 0 + 1 * this.hu_font[0].height + 1;
    }

    @Override
    public void Stop() {
        this.headsupactive = false;
    }

    @Override
    public void Start() {
        String s;
        if (this.DOOM.gamemap > 32 && this.DOOM.getGameMode() == GameMode.pack_xbla) {
            this.HU_TITLE = this.mapnames[(this.DOOM.gameepisode - 1) * 9 + this.DOOM.gamemap - 2];
            this.HU_TITLE2 = this.mapnames2[this.DOOM.gamemap - 1];
            this.HU_TITLEP = this.mapnamesp[this.DOOM.gamemap - 2];
            this.HU_TITLET = this.mapnamest[this.DOOM.gamemap - 2];
        } else {
            this.HU_TITLE = this.mapnames[(this.DOOM.gameepisode - 1) * 9 + this.DOOM.gamemap - 1];
            this.HU_TITLE2 = this.mapnames2[this.DOOM.gamemap - 1];
            this.HU_TITLEP = this.mapnamesp[this.DOOM.gamemap - 1];
            this.HU_TITLET = this.mapnamest[this.DOOM.gamemap - 1];
        }
        if (this.headsupactive) {
            this.Stop();
        }
        this.plr = this.DOOM.players[this.DOOM.consoleplayer];
        this.message_on[0] = false;
        this.message_dontfuckwithme = false;
        this.message_nottobefuckedwith = false;
        this.chat_on[0] = false;
        this.w_message.initSText(0, 0, 1, this.hu_font, 33, this.message_on);
        this.w_title.initTextLine(0, this.HU_TITLEY, this.hu_font, 33);
        switch (this.DOOM.getGameMode()) {
            case shareware: 
            case registered: 
            case retail: 
            case freedoom1: {
                s = this.HU_TITLE;
                break;
            }
            case pack_plut: {
                s = this.HU_TITLEP;
                break;
            }
            case pack_tnt: {
                s = this.HU_TITLET;
                break;
            }
            default: {
                s = this.HU_TITLE2;
            }
        }
        int ptr = 0;
        while (ptr < s.length()) {
            this.w_title.addCharToTextLine(s.charAt(ptr++));
        }
        this.w_chat.initIText(0, this.HU_INPUTY, this.hu_font, 33, this.chat_on);
        for (int i = 0; i < 4; ++i) {
            this.w_inputbuffer[i] = new hu_itext_t();
            this.w_inputbuffer[i].initIText(0, 0, null, 0, this.always_off);
        }
        this.headsupactive = true;
    }

    @Override
    public void Drawer() {
        this.w_message.drawSText();
        this.w_chat.drawIText();
        if (this.DOOM.automapactive) {
            this.w_title.drawTextLine(false);
        }
    }

    @Override
    public void Erase() {
        this.w_message.eraseSText();
        this.w_chat.eraseIText();
        this.w_title.eraseTextLine();
    }

    @Override
    public void Ticker() {
        if (this.message_counter != 0 && --this.message_counter == 0) {
            this.message_on[0] = false;
            this.message_nottobefuckedwith = false;
        }
        if ((this.DOOM.menu.getShowMessages() || this.message_dontfuckwithme) && (this.plr.message != null && !this.message_nottobefuckedwith || this.plr.message != null && this.message_dontfuckwithme)) {
            this.w_message.addMessageToSText(null, this.plr.message);
            this.plr.message = null;
            this.message_on[0] = true;
            this.message_counter = 140;
            this.message_nottobefuckedwith = this.message_dontfuckwithme;
            this.message_dontfuckwithme = false;
        }
        if (this.DOOM.netgame) {
            for (int i = 0; i < 4; ++i) {
                char c;
                if (!this.DOOM.playeringame[i] || i == this.DOOM.consoleplayer || (c = this.DOOM.players[i].cmd.chatchar) == '\u0000') continue;
                if (c <= '\u0005') {
                    this.chat_dest[i] = c;
                } else {
                    boolean rc;
                    if (c >= 'a' && c <= 'z') {
                        c = this.shiftxform[c];
                    }
                    if ((rc = this.w_inputbuffer[i].keyInIText(c)) && c == Signals.ScanCode.SC_ENTER.c) {
                        if (this.w_inputbuffer[i].l.len != 0 && this.chat_dest[i] == this.DOOM.consoleplayer + 1 || this.chat_dest[i] == '\u0005') {
                            this.w_message.addMessageToSText(player_names[i], this.w_inputbuffer[i].l.text.toString());
                            this.message_nottobefuckedwith = true;
                            this.message_on[0] = true;
                            this.message_counter = 140;
                            if (this.DOOM.isCommercial()) {
                                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_radio);
                            } else {
                                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_tink);
                            }
                        }
                        this.w_inputbuffer[i].resetIText();
                    }
                }
                this.DOOM.players[i].cmd.chatchar = '\u0000';
            }
        }
    }

    protected void queueChatChar(char c) {
        if ((this.head + 1 & 0x7F) == this.tail) {
            this.plr.message = "[Message unsent]";
        } else {
            this.chatchars[this.head] = c;
            this.head = this.head + 1 & 0x7F;
        }
    }

    @Override
    public char dequeueChatChar() {
        char c;
        if (this.head != this.tail) {
            c = this.chatchars[this.tail];
            this.tail = this.tail + 1 & 0x7F;
        } else {
            c = '\u0000';
        }
        return c;
    }

    @Override
    public boolean Responder(event_t ev) {
        boolean eatkey;
        int numplayers = 0;
        for (int i = 0; i < 4; ++i) {
            numplayers += this.DOOM.playeringame[i] ? 1 : 0;
        }
        if (ev.isKey(Signals.ScanCode.SC_LSHIFT) || ev.isKey(Signals.ScanCode.SC_RSHIFT)) {
            this.shiftdown = ev.isType(evtype_t.ev_keydown);
            return false;
        }
        if (ev.isKey(Signals.ScanCode.SC_LALT) || ev.isKey(Signals.ScanCode.SC_RALT)) {
            this.altdown = ev.isType(evtype_t.ev_keydown);
            return false;
        }
        if (!ev.isType(evtype_t.ev_keydown)) {
            return false;
        }
        if (!this.chat_on[0]) {
            if (ev.isKey(Defines.HU_MSGREFRESH)) {
                this.message_on[0] = true;
                this.message_counter = 140;
                eatkey = true;
            } else if (this.DOOM.netgame && ev.isKey(HU_INPUTTOGGLE)) {
                this.chat_on[0] = true;
                eatkey = true;
                this.w_chat.resetIText();
                this.queueChatChar('\u0005');
            } else {
                eatkey = this.DOOM.netgame && numplayers > 2 ? ev.ifKey(sc -> {
                    boolean r = false;
                    for (int i = 0; i < 4; ++i) {
                        if (sc.c != this.destination_keys[i]) continue;
                        if (this.DOOM.playeringame[i] && i != this.DOOM.consoleplayer) {
                            this.chat_on[0] = true;
                            r = true;
                            this.w_chat.resetIText();
                            this.queueChatChar((char)(i + 1));
                            break;
                        }
                        if (i != this.DOOM.consoleplayer) continue;
                        ++this.num_nobrainers;
                        this.plr.message = this.num_nobrainers < 3 ? "You mumble to yourself" : (this.num_nobrainers < 6 ? "Who's there?" : (this.num_nobrainers < 9 ? "You scare yourself" : (this.num_nobrainers < 32 ? "You start to rave" : "You've lost it...")));
                    }
                    return r;
                }) : false;
            }
        } else {
            eatkey = ev.ifKey(sc -> {
                boolean ret;
                char c = sc.c;
                if (this.altdown) {
                    if ((c = (char)(c - 48)) > '\t') {
                        return false;
                    }
                    char[] macromessage = this.chat_macros[c].toCharArray();
                    this.queueChatChar(Signals.ScanCode.SC_ENTER.c);
                    int index = 0;
                    while (macromessage[index] != '\u0000') {
                        this.queueChatChar(macromessage[index]);
                    }
                    this.queueChatChar(Signals.ScanCode.SC_ENTER.c);
                    this.chat_on[0] = false;
                    this.lastmessage.setLength(0);
                    this.lastmessage.append(this.chat_macros[c]);
                    this.plr.message = this.lastmessage.toString();
                    ret = true;
                } else {
                    if (this.DOOM.language == Language_t.french) {
                        c = this.ForeignTranslation(c);
                    }
                    if (this.shiftdown || c >= 'a' && c <= 'z') {
                        c = this.shiftxform[c];
                    }
                    if (ret = this.w_chat.keyInIText(c)) {
                        this.queueChatChar(c);
                    }
                    if (c == Signals.ScanCode.SC_ENTER.c) {
                        this.chat_on[0] = false;
                        if (this.w_chat.l.len != 0) {
                            this.lastmessage.setLength(0);
                            this.lastmessage.append(this.w_chat.l.text);
                            this.plr.message = new String(this.lastmessage);
                        }
                    } else if (c == Signals.ScanCode.SC_ESCAPE.c) {
                        this.chat_on[0] = false;
                    }
                }
                return ret;
            });
        }
        return eatkey;
    }

    @Override
    public patch_t[] getHUFonts() {
        return this.hu_font;
    }

    class hu_textline_t {
        int x;
        int y;
        patch_t[] f;
        int sc;
        char[] text = new char[81];
        int len;
        int needsupdate;
        protected boolean lastautomapactive = true;

        public hu_textline_t() {
        }

        public void clearTextLine() {
            this.len = 0;
            C2JUtils.memset(this.text, '\u0000', this.text.length);
            this.needsupdate = 1;
        }

        public void initTextLine(int x, int y, patch_t[] f, int sc) {
            this.x = x;
            this.y = y;
            this.f = f;
            this.sc = sc;
            this.clearTextLine();
        }

        public hu_textline_t(int x, int y, patch_t[] f, int sc) {
            this.x = x;
            this.y = y;
            this.f = f;
            this.sc = sc;
            this.clearTextLine();
        }

        public boolean addCharToTextLine(char ch) {
            if (this.len == 80) {
                return false;
            }
            this.text[this.len++] = ch;
            this.text[this.len] = '\u0000';
            this.needsupdate = 4;
            return true;
        }

        boolean delCharFromTextLine() {
            if (this.len == 0) {
                return false;
            }
            this.text[--this.len] = '\u0000';
            this.needsupdate = 4;
            return true;
        }

        void drawTextLine(boolean drawcursor) {
            int x = this.x;
            for (int i = 0; i < this.len; ++i) {
                char c = Character.toUpperCase(this.text[i]);
                if (c != ' ' && c >= this.sc && c <= '_') {
                    short w = this.f[c - this.sc].width;
                    if (x + w > HU.this.DOOM.vs.getScreenWidth()) break;
                    HU.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.f[c - this.sc], HU.this.DOOM.vs, x, this.y, new int[0]);
                    x += w;
                    continue;
                }
                if ((x += 4) >= HU.this.DOOM.vs.getScreenWidth()) break;
            }
            if (drawcursor && x + this.f[95 - this.sc].width <= HU.this.DOOM.vs.getScreenWidth()) {
                HU.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.f[95 - this.sc], HU.this.DOOM.vs, x, this.y, new int[0]);
            }
        }

        public void eraseTextLine() {
            if (!HU.this.DOOM.automapactive && HU.this.DOOM.sceneRenderer.getView().windowx != 0 && this.needsupdate > 0) {
                ViewVars active = HU.this.DOOM.sceneRenderer.getView();
                int activeEndX = active.x + active.width;
                int activeEndY = active.y + active.height;
                int dupY = HU.this.DOOM.graphicSystem.getScalingY();
                int lineY = this.y * dupY;
                int lineHeight = (this.f[0].height + 1) * dupY;
                int lineEndY = lineY + lineHeight;
                Rectangle rect = new Rectangle(0, lineY, HU.this.DOOM.vs.getScreenWidth(), lineHeight);
                if (lineY < active.y) {
                    if (lineEndY >= active.y) {
                        rect.height = active.y - lineY;
                    }
                    HU.this.DOOM.graphicSystem.CopyRect(DoomScreen.BG, rect, DoomScreen.FG);
                }
                if (lineEndY >= active.y && lineEndY < activeEndY || lineY >= active.y && lineY < activeEndY) {
                    if (lineY < active.y) {
                        rect.y = active.y;
                        rect.height = lineHeight - rect.height;
                    } else {
                        rect.y = lineY;
                        rect.height = lineEndY >= activeEndY ? activeEndY - lineY : lineHeight;
                    }
                    rect.width = active.x;
                    HU.this.DOOM.graphicSystem.CopyRect(DoomScreen.BG, rect, DoomScreen.FG);
                    rect.width = HU.this.DOOM.vs.getScreenWidth() - activeEndX;
                    HU.this.DOOM.graphicSystem.CopyRect(DoomScreen.BG, rect, DoomScreen.FG);
                    rect.width = HU.this.DOOM.vs.getScreenWidth();
                }
                if (lineEndY >= activeEndY) {
                    if (lineY >= activeEndY) {
                        rect.y = lineY;
                    } else {
                        rect.y = activeEndY;
                        rect.height = lineHeight - rect.height;
                    }
                    HU.this.DOOM.graphicSystem.CopyRect(DoomScreen.BG, rect, DoomScreen.FG);
                }
            }
            this.lastautomapactive = HU.this.DOOM.automapactive;
            if (this.needsupdate != 0) {
                --this.needsupdate;
            }
        }
    }

    class hu_stext_t {
        hu_textline_t[] lines = new hu_textline_t[4];
        int height;
        int currline;
        boolean[] on;
        boolean laston;
        protected boolean automapactive;
        protected boolean noterased;
        StringBuilder sb = new StringBuilder();

        public hu_stext_t() {
        }

        public hu_stext_t(int x, int y, int h, patch_t[] font, int startchar, boolean[] on) {
            this.initSText(x, y, h, font, startchar, on);
        }

        public void initSText(int x, int y, int h, patch_t[] font, int startchar, boolean[] on) {
            int i;
            for (i = 0; i < 4; ++i) {
                this.lines[i] = new hu_textline_t();
            }
            this.height = h;
            this.on = on;
            this.laston = true;
            this.currline = 0;
            for (i = 0; i < h; ++i) {
                this.lines[i].initTextLine(x, y - i * (font[0].height + 1), font, startchar);
            }
        }

        public void addLineToSText() {
            if (++this.currline == this.height) {
                this.currline = 0;
            }
            this.lines[this.currline].clearTextLine();
            for (int i = 0; i < this.height; ++i) {
                this.lines[i].needsupdate = 4;
            }
        }

        public void addMessageToSText(char[] prefix, char[] msg) {
            this.addLineToSText();
            int ptr = 0;
            if (prefix != null && prefix.length > 0) {
                while (ptr < prefix.length && prefix[ptr] > '\u0000') {
                    this.lines[this.currline].addCharToTextLine(prefix[ptr++]);
                }
            }
            ptr = 0;
            while (ptr < msg.length && msg[ptr] > '\u0000') {
                this.lines[this.currline].addCharToTextLine(msg[ptr++]);
            }
        }

        public void addMessageToSText(String prefix, String msg) {
            int i;
            this.addLineToSText();
            if (prefix != null && prefix.length() > 0) {
                for (i = 0; i < prefix.length(); ++i) {
                    this.lines[this.currline].addCharToTextLine(prefix.charAt(i));
                }
            }
            for (i = 0; i < msg.length(); ++i) {
                this.lines[this.currline].addCharToTextLine(msg.charAt(i));
            }
        }

        public void drawSText() {
            if (!this.on[0]) {
                return;
            }
            for (int i = 0; i < this.height; ++i) {
                int idx = this.currline - i;
                if (idx < 0) {
                    idx += this.height;
                }
                hu_textline_t l = this.lines[idx];
                l.drawTextLine(false);
            }
        }

        public void eraseSText() {
            for (int i = 0; i < this.height; ++i) {
                if (this.laston && !this.on[0]) {
                    this.lines[i].needsupdate = 4;
                }
                this.lines[i].eraseTextLine();
            }
            this.laston = this.on[0];
        }

        public boolean isAutomapactive() {
            return this.automapactive;
        }

        public void setAutomapactive(boolean automapactive) {
            this.automapactive = automapactive;
        }

        public boolean isNoterased() {
            return this.noterased;
        }

        public void setNoterased(boolean noterased) {
            this.noterased = noterased;
        }

        public String toString() {
            this.sb.setLength(0);
            this.sb.append(this.lines[0].text);
            this.sb.append(this.lines[1].text);
            this.sb.append(this.lines[2].text);
            this.sb.append(this.lines[3].text);
            return this.sb.toString();
        }
    }

    class hu_itext_t {
        hu_textline_t l;
        int lm;
        boolean[] on;
        boolean laston;

        public void initIText(int x, int y, patch_t[] font, int startchar, boolean[] on) {
            this.lm = 0;
            this.on = on;
            this.laston = true;
            this.l = new hu_textline_t(x, y, font, startchar);
        }

        public void delCharFromIText() {
            if (this.l.len != this.lm) {
                this.l.delCharFromTextLine();
            }
        }

        public void eraseLineFromIText() {
            while (this.lm != this.l.len) {
                this.l.delCharFromTextLine();
            }
        }

        public void resetIText() {
            this.lm = 0;
            this.l.clearTextLine();
        }

        public void addPrefixToIText(char[] str) {
            int ptr = 0;
            while (str[ptr] > '\u0000') {
                this.l.addCharToTextLine(str[ptr++]);
                this.lm = this.l.len;
            }
        }

        public void addPrefixToIText(String str) {
            int ptr = 0;
            while (str.charAt(ptr) > '\u0000') {
                this.l.addCharToTextLine(str.charAt(ptr++));
                this.lm = this.l.len;
            }
        }

        public boolean keyInIText(char ch) {
            if (ch >= ' ' && ch <= '_') {
                this.l.addCharToTextLine(ch);
            } else if (ch == Signals.ScanCode.SC_BACKSPACE.c) {
                this.delCharFromIText();
            } else if (ch != Signals.ScanCode.SC_ENTER.c) {
                return false;
            }
            return true;
        }

        public void drawIText() {
            if (!this.on[0]) {
                return;
            }
            this.l.drawTextLine(true);
        }

        void eraseIText() {
            if (this.laston && !this.on[0]) {
                this.l.needsupdate = 4;
            }
            this.l.eraseTextLine();
            this.laston = this.on[0];
        }
    }
}

