/*
 * Decompiled with CFR 0.152.
 */
package i;

import awt.MsgBox;
import doom.DoomMain;
import doom.ticcmd_t;
import i.IDoomSystem;
import java.io.IOException;

public class DoomSystem
implements IDoomSystem {
    static int mb_used = 6;
    private final DoomMain<?, ?> DM;
    private final ticcmd_t emptycmd;

    public static void MiscError(String error, Object ... args) {
        System.err.print("Error: ");
        System.err.print(error);
        System.err.print("\n");
    }

    public DoomSystem(DoomMain<?, ?> DM) {
        this.DM = DM;
        this.emptycmd = new ticcmd_t();
    }

    @Override
    public void Tactile(int on, int off, int total) {
        total = 0;
        off = 0;
        on = 0;
    }

    @Override
    public ticcmd_t BaseTiccmd() {
        return this.emptycmd;
    }

    @Override
    public int GetHeapSize() {
        return mb_used * 1024 * 1024;
    }

    @Override
    public byte[] ZoneBase(int size) {
        return new byte[mb_used * 1024 * 1024];
    }

    @Override
    public void Quit() {
        try {
            this.DM.QuitNetGame();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.DM.commit();
        this.DM.CM.SaveDefaults();
        System.exit(0);
    }

    @Override
    public void Init() {
    }

    @Override
    public void WaitVBL(int count) {
        try {
            Thread.sleep(count * 1000 / 70);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void BeginRead() {
        if (this.DM.diskDrawer != null && !this.DM.diskDrawer.isReading()) {
            this.DM.diskDrawer.setReading(8);
        }
    }

    @Override
    public void EndRead() {
    }

    @Override
    public void AllocLow(int length) {
    }

    @Override
    public void Error(String error, Object ... args) {
        System.err.print("Error: ");
        System.err.printf(error, args);
        System.err.print("\n");
        if (this.DM.demorecording) {
            this.DM.CheckDemoStatus();
        }
        try {
            this.DM.QuitNetGame();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(-1);
    }

    @Override
    public void Error(String error) {
        System.err.print("Error: ");
        System.err.printf(error, new Object[0]);
        System.err.print("\n");
        System.exit(-1);
    }

    @Override
    public boolean GenerateAlert(String title, String cause) {
        MsgBox alert = new MsgBox(null, title, cause, true);
        return alert.isOk();
    }
}

