/*
 * Decompiled with CFR 0.152.
 */
package m;

import data.mobjtype_t;
import m.DoomRandom;
import m.IRandom;
import m.JavaRandom;
import p.ActiveStates;
import utils.C2JUtils;

public class DelegateRandom
implements IRandom {
    private IRandom random = new JavaRandom();
    private IRandom altRandom;

    public void requireRandom(int version) {
        if (C2JUtils.flags(version, 128) && this.random instanceof DoomRandom) {
            this.switchRandom(true);
        } else if (!C2JUtils.flags(version, 128) && !(this.random instanceof DoomRandom)) {
            this.switchRandom(false);
        }
    }

    private void switchRandom(boolean which) {
        IRandom arandom = this.altRandom;
        if (arandom != null && (!which && arandom instanceof DoomRandom || which && arandom instanceof JavaRandom)) {
            this.altRandom = this.random;
            this.random = arandom;
            System.out.print(String.format("M_Random: Switching to %s\n", this.random.getClass().getSimpleName()));
        } else {
            this.altRandom = this.random;
            this.random = which ? new JavaRandom() : new DoomRandom();
            System.out.print(String.format("M_Random: Switching to %s (new instance)\n", this.random.getClass().getSimpleName()));
        }
    }

    @Override
    public int P_Random() {
        return this.random.P_Random();
    }

    @Override
    public int M_Random() {
        return this.random.M_Random();
    }

    @Override
    public void ClearRandom() {
        this.random.ClearRandom();
    }

    @Override
    public int getIndex() {
        return this.random.getIndex();
    }

    @Override
    public int P_Random(int caller) {
        return this.random.P_Random(caller);
    }

    @Override
    public int P_Random(String message) {
        return this.random.P_Random(message);
    }

    @Override
    public int P_Random(ActiveStates caller, int sequence) {
        return this.random.P_Random(caller, sequence);
    }

    @Override
    public int P_Random(ActiveStates caller, mobjtype_t type, int sequence) {
        return this.random.P_Random(caller, type, sequence);
    }
}

