/*
 * Decompiled with CFR 0.152.
 */
package m;

public class FixedFloat {
    public static final int MANTISSA_32 = 0x7FFFFF;
    public static final int EXP_32 = 2139095040;
    public static final int IMPLICIT_32 = 0x800000;
    public static final int SIGN_32 = Integer.MIN_VALUE;
    public static final int NONSIGN_32 = Integer.MAX_VALUE;
    public static final long SIGN_64 = Long.MIN_VALUE;
    public static final long EXP_64 = 0x7FF0000000000000L;
    public static final long IMPLICIT_64 = 0x10000000000000L;
    public static final long MANTISSA_64 = 0xFFFFFFFFFFFFFL;

    public static float toFloat(int fixed) {
        if (fixed == 0) {
            return 0.0f;
        }
        int sign = fixed & Integer.MIN_VALUE;
        if (fixed < 0) {
            fixed = -fixed;
        }
        int exp = FixedFloat.findShift(fixed);
        int mantissa = fixed << exp + 2 >>> 9;
        int result = sign | 14 - exp + 127 << 23 | mantissa;
        return Float.intBitsToFloat(result);
    }

    private static int findShift(int fixed) {
        int shift;
        fixed &= Integer.MAX_VALUE;
        for (shift = 30; shift >= 0 && fixed >>> shift == 0; --shift) {
        }
        return 30 - shift;
    }

    public static double toDouble(int fixed) {
        long fx = fixed;
        long sign = (fx <<= 32) & Long.MIN_VALUE;
        if (fixed < 0) {
            fixed = -fixed;
            fx = -fx;
        }
        long exp = FixedFloat.findShift(fixed);
        long bits = fx << (int)(exp + 2L) >>> 12;
        long result = sign | 14L - exp + 1023L << 52 | bits;
        return Double.longBitsToDouble(result);
    }

    public static int toFixed(float fl) {
        int flbits = Float.floatToRawIntBits(fl);
        int sign = flbits & Integer.MIN_VALUE;
        int denorm = 0x800000 | flbits & 0x7FFFFF;
        int exp = ((flbits & 0x7F800000) >> 23) - 127 & 0x8000000F;
        int result = exp - 7 >= 0 ? sign | denorm << exp - 7 : sign | denorm >>> 7 - exp;
        return result;
    }

    public static int toFixed(double fl) {
        long flbits = Double.doubleToRawLongBits(fl);
        int sign = (int)((flbits & Long.MIN_VALUE) >> 32);
        long denorm = 0x10000000000000L | flbits & 0xFFFFFFFFFFFFFL;
        int exp = (int)(((flbits & 0x7FF0000000000000L) >> 52) - 1023L) & 0x8000000F;
        int result = exp - 36 >= 0 ? (int)((long)sign | denorm << exp - 36) : (int)((long)sign | denorm >>> 36 - exp);
        return result;
    }
}

