/*
 * Decompiled with CFR 0.152.
 */
package m;

import data.dstrings;
import data.sounds;
import defines.Language_t;
import defines.gamestate_t;
import defines.skill_t;
import doom.CommandVariable;
import doom.DoomMain;
import doom.event_t;
import doom.evtype_t;
import g.Signals;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import m.AbstractDoomMenu;
import m.DrawRoutine;
import m.MenuRoutine;
import m.menu_t;
import m.menuitem_t;
import rr.patch_t;
import timing.DelegateTicker;
import utils.C2JUtils;
import v.renderers.DoomScreen;
import w.DoomIO;

public class Menu<T, V>
extends AbstractDoomMenu<T, V> {
    patch_t[] hu_font = new patch_t[63];
    boolean message_dontfuckwithme;
    private boolean showMessages = false;
    int detailLevel;
    int screenblocks = 10;
    int screenSize;
    int quickSaveSlot;
    boolean messageToPrint;
    String messageString;
    int messx;
    int messy;
    boolean messageLastMenuActive;
    boolean messageNeedsInput;
    public MenuRoutine messageRoutine;
    boolean saveStringEnter;
    int saveSlot;
    int saveCharIndex;
    char[] saveOldString = new char[24];
    boolean inhelpscreens;
    protected static final int SKULLXOFF = -32;
    protected static final int LINEHEIGHT = 16;
    char[][] savegamestrings = new char[10][24];
    String endstring = new String();
    short itemOn;
    short skullAnimCounter;
    short whichSkull;
    private static String[] skullName = new String[]{"M_SKULL1", "M_SKULL2"};
    menu_t currentMenu;
    MenuRoutine ChangeDetail;
    MenuRoutine ChangeMessages;
    MenuRoutine ChangeSensitivity;
    MenuRoutine ChooseSkill;
    MenuRoutine EndGame;
    MenuRoutine EndGameResponse;
    MenuRoutine Episode;
    MenuRoutine FinishReadThis;
    MenuRoutine LoadGame;
    MenuRoutine LoadSelect;
    MenuRoutine MusicVol;
    MenuRoutine NewGame;
    MenuRoutine Options;
    MenuRoutine VerifyNightmare;
    MenuRoutine SaveSelect;
    MenuRoutine SfxVol;
    MenuRoutine SizeDisplay;
    MenuRoutine SaveGame;
    MenuRoutine Sound;
    MenuRoutine QuitDOOM;
    MenuRoutine QuitResponse;
    MenuRoutine QuickLoadResponse;
    MenuRoutine QuickSaveResponse;
    MenuRoutine ReadThis;
    MenuRoutine ReadThis2;
    DrawRoutine DrawEpisode;
    DrawRoutine DrawLoad;
    DrawRoutine DrawMainMenu;
    DrawRoutine DrawNewGame;
    DrawRoutine DrawOptions;
    DrawRoutine DrawReadThis1;
    DrawRoutine DrawReadThis2;
    DrawRoutine DrawSave;
    DrawRoutine DrawSound;
    menuitem_t[] MainMenu;
    menuitem_t[] EpisodeMenu;
    menuitem_t[] NewGameMenu;
    menuitem_t[] OptionsMenu;
    menuitem_t[] ReadMenu1;
    menuitem_t[] ReadMenu2;
    menuitem_t[] SoundMenu;
    menuitem_t[] LoadMenu;
    menuitem_t[] SaveMenu;
    menu_t MainDef;
    menu_t EpiDef;
    menu_t NewDef;
    menu_t OptionsDef;
    menu_t ReadDef1;
    menu_t ReadDef2;
    menu_t SoundDef;
    menu_t LoadDef;
    menu_t SaveDef;
    private String tempstring;
    private int epi;
    private int joywait = 0;
    private int mousewait = 0;
    private int mousey = 0;
    private int lasty = 0;
    private int mousex = 0;
    private int lastx = 0;
    private static final sounds.sfxenum_t[] quitsounds = new sounds.sfxenum_t[]{sounds.sfxenum_t.sfx_pldeth, sounds.sfxenum_t.sfx_dmpain, sounds.sfxenum_t.sfx_popain, sounds.sfxenum_t.sfx_slop, sounds.sfxenum_t.sfx_telept, sounds.sfxenum_t.sfx_posit1, sounds.sfxenum_t.sfx_posit3, sounds.sfxenum_t.sfx_sgtatk};
    private static final sounds.sfxenum_t[] quitsounds2 = new sounds.sfxenum_t[]{sounds.sfxenum_t.sfx_vilact, sounds.sfxenum_t.sfx_getpow, sounds.sfxenum_t.sfx_boscub, sounds.sfxenum_t.sfx_slop, sounds.sfxenum_t.sfx_skeswg, sounds.sfxenum_t.sfx_kntdth, sounds.sfxenum_t.sfx_bspact, sounds.sfxenum_t.sfx_sgtatk};
    private static final int ep1 = 0;
    private static final int ep2 = 1;
    private static final int ep3 = 2;
    private static final int ep4 = 3;
    private static final int ep_end = 4;
    private static final int load1 = 0;
    private static final int load2 = 1;
    private static final int load3 = 2;
    private static final int load4 = 3;
    private static final int load5 = 4;
    private static final int load6 = 5;
    private static final int load_end = 6;
    private static final int endgame = 0;
    private static final int messages = 1;
    private static final int detail = 2;
    private static final int scrnsize = 3;
    private static final int option_empty1 = 4;
    private static final int mousesens = 5;
    private static final int option_empty2 = 6;
    private static final int soundvol = 7;
    private static final int opt_end = 8;
    private static final int newgame = 0;
    private static final int options = 1;
    private static final int loadgam = 2;
    private static final int savegame = 3;
    private static final int readthis = 4;
    private static final int quitdoom = 5;
    private static final int main_end = 6;
    private static final int rdthsempty1 = 0;
    private static final int read1_end = 1;
    private static final int rdthsempty2 = 0;
    private static final int read2_end = 1;
    public static final int killthings = 0;
    public static final int toorough = 1;
    public static final int hurtme = 2;
    public static final int violence = 3;
    public static final int nightmare = 4;
    public static final int newg_end = 5;
    private static final String[] gammamsg = new String[]{"Gamma correction OFF", "Gamma correction level 1", "Gamma correction level 2", "Gamma correction level 3", "Gamma correction level 4"};
    static final int sfx_vol = 0;
    static final int sfx_empty1 = 1;
    static final int music_vol = 2;
    static final int sfx_empty2 = 3;
    static final int sound_end = 4;

    public Menu(DoomMain<T, V> DOOM) {
        super(DOOM);
    }

    @Override
    public boolean getShowMessages() {
        return this.showMessages;
    }

    @Override
    public void setShowMessages(boolean val) {
        this.showMessages = val;
    }

    private void initMenuRoutines() {
        this.ChangeMessages = new M_ChangeMessages();
        this.ChangeDetail = new M_ChangeDetail();
        this.ChangeSensitivity = new M_ChangeSensitivity();
        this.ChooseSkill = new M_ChooseSkill();
        this.EndGame = new M_EndGame();
        this.EndGameResponse = new M_EndGameResponse();
        this.Episode = new M_Episode();
        this.FinishReadThis = new M_FinishReadThis();
        this.LoadGame = new M_LoadGame();
        this.LoadSelect = new M_LoadSelect();
        this.MusicVol = new M_MusicVol();
        this.NewGame = new M_NewGame();
        this.Options = new M_Options();
        this.QuitDOOM = new M_QuitDOOM();
        this.QuickLoadResponse = new M_QuickLoadResponse();
        this.QuickSaveResponse = new M_QuickSaveResponse();
        this.QuitResponse = new M_QuitResponse();
        this.ReadThis = new M_ReadThis();
        this.ReadThis2 = new M_ReadThis2();
        this.SaveGame = new M_SaveGame();
        this.SaveSelect = new M_SaveSelect();
        this.SfxVol = new M_SfxVol();
        this.SizeDisplay = new M_SizeDisplay();
        this.Sound = new M_Sound();
        this.VerifyNightmare = new M_VerifyNightmare();
    }

    private void initDrawRoutines() {
        this.DrawEpisode = new M_DrawEpisode();
        this.DrawNewGame = new M_DrawNewGame();
        this.DrawReadThis1 = new M_DrawReadThis1();
        this.DrawReadThis2 = new M_DrawReadThis2();
        this.DrawOptions = new M_DrawOptions();
        this.DrawLoad = new M_DrawLoad();
        this.DrawSave = new M_DrawSave();
        this.DrawSound = new M_DrawSound();
        this.DrawMainMenu = new M_DrawMainMenu();
    }

    private void initMenuItems() {
        this.MainMenu = new menuitem_t[]{new menuitem_t(1, "M_NGAME", this.NewGame, Signals.ScanCode.SC_N), new menuitem_t(1, "M_OPTION", this.Options, Signals.ScanCode.SC_O), new menuitem_t(1, "M_LOADG", this.LoadGame, Signals.ScanCode.SC_L), new menuitem_t(1, "M_SAVEG", this.SaveGame, Signals.ScanCode.SC_S), new menuitem_t(1, "M_RDTHIS", this.ReadThis, Signals.ScanCode.SC_R), new menuitem_t(1, "M_QUITG", this.QuitDOOM, Signals.ScanCode.SC_Q)};
        this.MainDef = new menu_t(6, null, this.MainMenu, this.DrawMainMenu, 97, 64, 0);
        this.EpisodeMenu = new menuitem_t[]{new menuitem_t(1, "M_EPI1", this.Episode, Signals.ScanCode.SC_K), new menuitem_t(1, "M_EPI2", this.Episode, Signals.ScanCode.SC_T), new menuitem_t(1, "M_EPI3", this.Episode, Signals.ScanCode.SC_I), new menuitem_t(1, "M_EPI4", this.Episode, Signals.ScanCode.SC_T)};
        this.EpiDef = new menu_t(4, this.MainDef, this.EpisodeMenu, this.DrawEpisode, 48, 63, 0);
        this.NewGameMenu = new menuitem_t[]{new menuitem_t(1, "M_JKILL", this.ChooseSkill, Signals.ScanCode.SC_I), new menuitem_t(1, "M_ROUGH", this.ChooseSkill, Signals.ScanCode.SC_H), new menuitem_t(1, "M_HURT", this.ChooseSkill, Signals.ScanCode.SC_H), new menuitem_t(1, "M_ULTRA", this.ChooseSkill, Signals.ScanCode.SC_U), new menuitem_t(1, "M_NMARE", this.ChooseSkill, Signals.ScanCode.SC_N)};
        this.NewDef = new menu_t(5, this.EpiDef, this.NewGameMenu, this.DrawNewGame, 48, 63, 2);
        this.OptionsMenu = new menuitem_t[]{new menuitem_t(1, "M_ENDGAM", this.EndGame, Signals.ScanCode.SC_3), new menuitem_t(1, "M_MESSG", this.ChangeMessages, Signals.ScanCode.SC_M), new menuitem_t(1, "M_DETAIL", this.ChangeDetail, Signals.ScanCode.SC_G), new menuitem_t(2, "M_SCRNSZ", this.SizeDisplay, Signals.ScanCode.SC_S), new menuitem_t(-1, "", null), new menuitem_t(2, "M_MSENS", this.ChangeSensitivity, Signals.ScanCode.SC_M), new menuitem_t(-1, "", null), new menuitem_t(1, "M_SVOL", this.Sound, Signals.ScanCode.SC_S)};
        this.OptionsDef = new menu_t(8, this.MainDef, this.OptionsMenu, this.DrawOptions, 60, 37, 0);
        this.ReadMenu1 = new menuitem_t[]{new menuitem_t(1, "", this.ReadThis2, Signals.ScanCode.SC_0)};
        this.ReadDef1 = new menu_t(1, this.MainDef, this.ReadMenu1, this.DrawReadThis1, 280, 185, 0);
        this.ReadMenu2 = new menuitem_t[]{new menuitem_t(1, "", this.FinishReadThis, Signals.ScanCode.SC_0)};
        this.ReadDef2 = new menu_t(1, this.ReadDef1, this.ReadMenu2, this.DrawReadThis2, 330, 175, 0);
        this.SoundMenu = new menuitem_t[]{new menuitem_t(2, "M_SFXVOL", this.SfxVol, Signals.ScanCode.SC_S), new menuitem_t(-1, "", null), new menuitem_t(2, "M_MUSVOL", this.MusicVol, Signals.ScanCode.SC_M), new menuitem_t(-1, "", null)};
        this.SoundDef = new menu_t(4, this.OptionsDef, this.SoundMenu, this.DrawSound, 80, 64, 0);
        this.LoadMenu = new menuitem_t[]{new menuitem_t(1, "", this.LoadSelect, Signals.ScanCode.SC_1), new menuitem_t(1, "", this.LoadSelect, Signals.ScanCode.SC_2), new menuitem_t(1, "", this.LoadSelect, Signals.ScanCode.SC_3), new menuitem_t(1, "", this.LoadSelect, Signals.ScanCode.SC_4), new menuitem_t(1, "", this.LoadSelect, Signals.ScanCode.SC_5), new menuitem_t(1, "", this.LoadSelect, Signals.ScanCode.SC_6)};
        this.LoadDef = new menu_t(6, this.MainDef, this.LoadMenu, this.DrawLoad, 80, 54, 0);
        this.SaveMenu = new menuitem_t[]{new menuitem_t(1, "", this.SaveSelect, Signals.ScanCode.SC_1), new menuitem_t(1, "", this.SaveSelect, Signals.ScanCode.SC_2), new menuitem_t(1, "", this.SaveSelect, Signals.ScanCode.SC_3), new menuitem_t(1, "", this.SaveSelect, Signals.ScanCode.SC_4), new menuitem_t(1, "", this.SaveSelect, Signals.ScanCode.SC_5), new menuitem_t(1, "", this.SaveSelect, Signals.ScanCode.SC_6)};
        this.SaveDef = new menu_t(6, this.MainDef, this.SaveMenu, this.DrawSave, 80, 54, 0);
    }

    public void ReadSaveStrings() {
        for (int i = 0; i < 6; ++i) {
            String name = this.DOOM.cVarManager.bool(CommandVariable.CDROM) ? "c:\\doomdata\\doomsav" + i + ".dsg" : "doomsav" + i + ".dsg";
            try {
                DataInputStream handle = new DataInputStream(new BufferedInputStream(new FileInputStream(name)));
                this.savegamestrings[i] = DoomIO.readString(handle, 24).toCharArray();
                handle.close();
                this.LoadMenu[i].status = 1;
                continue;
            }
            catch (IOException e) {
                this.savegamestrings[i][0] = '\u0000';
                this.LoadMenu[i].status = 0;
            }
        }
    }

    private void DrawSaveLoadBorder(int x, int y) {
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("M_LSLEFT"), this.DOOM.vs, x - 8, y + 7, new int[0]);
        for (int i = 0; i < 24; ++i) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("M_LSCNTR"), this.DOOM.vs, x, y + 7, new int[0]);
            x += 8;
        }
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("M_LSRGHT"), this.DOOM.vs, x, y + 7, new int[0]);
    }

    public void DrawThermo(int x, int y, int thermWidth, int thermDot) {
        int xx = x;
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("M_THERML"), this.DOOM.vs, xx, y, new int[0]);
        xx += 8;
        for (int i = 0; i < thermWidth; ++i) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("M_THERMM"), this.DOOM.vs, xx, y, new int[0]);
            xx += 8;
        }
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("M_THERMR"), this.DOOM.vs, xx, y, new int[0]);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName("M_THERMO"), this.DOOM.vs, x + 8 + thermDot * 8, y, new int[0]);
    }

    public void DrawEmptyCell(menu_t menu, int item) {
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CacheLumpName("M_CELL1", 101, patch_t.class), this.DOOM.vs, menu.x - 10, menu.y + item * 16 - 1, new int[0]);
    }

    public void DrawSelCell(menu_t menu, int item) {
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CacheLumpName("M_CELL2", 101, patch_t.class), this.DOOM.vs, menu.x - 10, menu.y + item * 16 - 1, new int[0]);
    }

    public void DoSave(int slot) {
        this.DOOM.SaveGame(slot, new String(this.savegamestrings[slot]));
        this.ClearMenus();
        if (this.quickSaveSlot == -2) {
            this.quickSaveSlot = slot;
        }
    }

    private void QuickSave() {
        if (!this.DOOM.usergame) {
            this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_oof);
            return;
        }
        if (this.DOOM.gamestate != gamestate_t.GS_LEVEL) {
            return;
        }
        if (this.quickSaveSlot < 0) {
            this.StartControlPanel();
            this.ReadSaveStrings();
            this.SetupNextMenu(this.SaveDef);
            this.quickSaveSlot = -2;
            return;
        }
        this.tempstring = String.format("quicksave over your game named\n\n'%s'?\n\npress y or n.", C2JUtils.nullTerminatedString(this.savegamestrings[this.quickSaveSlot]));
        this.StartMessage(this.tempstring, this.QuickSaveResponse, true);
    }

    public void QuickLoad() {
        if (this.DOOM.netgame) {
            this.StartMessage("you can't quickload during a netgame!\n\npress a key.", null, false);
            return;
        }
        if (this.quickSaveSlot < 0) {
            this.StartMessage("you haven't picked a quicksave slot yet!\n\npress a key.", null, false);
            return;
        }
        this.tempstring = String.format("do you want to quickload the game named\n\n'%s'?\n\npress y or n.", C2JUtils.nullTerminatedString(this.savegamestrings[this.quickSaveSlot]));
        this.StartMessage(this.tempstring, this.QuickLoadResponse, true);
    }

    public void StartMessage(String string, MenuRoutine routine, boolean input) {
        this.messageLastMenuActive = this.DOOM.menuactive;
        this.messageToPrint = true;
        this.messageString = string;
        this.messageRoutine = routine;
        this.messageNeedsInput = input;
        this.DOOM.menuactive = true;
    }

    public void StopMessage() {
        this.DOOM.menuactive = this.messageLastMenuActive;
        this.messageToPrint = false;
    }

    public int StringWidth(char[] string) {
        int w = 0;
        for (int i = 0; i < C2JUtils.strlen(string); ++i) {
            int c = Character.toUpperCase(string[i]) - 33;
            if (c < 0 || c >= 63) {
                w += 4;
                continue;
            }
            w += this.hu_font[c].width;
        }
        return w;
    }

    private int StringHeight(char[] string) {
        int height;
        int h = height = this.hu_font[0].height;
        for (int i = 0; i < string.length; ++i) {
            if (string[i] != '\n') continue;
            h += height;
        }
        return h;
    }

    private int StringHeight(String string) {
        return this.StringHeight(string.toCharArray());
    }

    private void WriteText(int x, int y, char[] string) {
        char[] ch = string;
        int cx = x;
        int cy = y;
        for (int chptr = 0; chptr < ch.length; ++chptr) {
            int c = ch[chptr];
            if (c == 0) break;
            if (c == 10) {
                cx = x;
                cy += 12;
                continue;
            }
            if ((c = Character.toUpperCase(c) - 33) < 0 || c >= 63) {
                cx += 4;
                continue;
            }
            short w = this.hu_font[c].width;
            if (cx + w > this.DOOM.vs.getScreenWidth()) break;
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.hu_font[c], this.DOOM.vs, cx, cy, new int[0]);
            cx += w;
        }
    }

    private void WriteText(int x, int y, String string) {
        char c;
        if (string == null || string.length() == 0) {
            return;
        }
        int chptr = 0;
        int cx = x;
        int cy = y;
        while (chptr < string.length() && (c = string.charAt(chptr++)) != '\u0000') {
            if (c == '\n') {
                cx = x;
                cy += 12;
                continue;
            }
            if ((c = (char)(Character.toUpperCase(c) - 33)) < '\u0000' || c >= '?') {
                cx += 4;
                continue;
            }
            short w = this.hu_font[c].width;
            if (cx + w > this.DOOM.vs.getScreenWidth()) break;
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.hu_font[c], this.DOOM.vs, cx, cy, new int[0]);
            cx += w;
        }
    }

    @Override
    public boolean Responder(event_t ev) {
        int i;
        Signals.ScanCode sc;
        if (ev.isType(evtype_t.ev_joystick) && this.joywait < this.DOOM.ticker.GetTime()) {
            sc = ev.mapByJoy(joyEvent -> {
                Signals.ScanCode r = Signals.ScanCode.SC_NULL;
                if (joyEvent.y == -1) {
                    r = Signals.ScanCode.SC_UP;
                    this.joywait = this.DOOM.ticker.GetTime() + 5;
                } else if (joyEvent.y == 1) {
                    r = Signals.ScanCode.SC_DOWN;
                    this.joywait = this.DOOM.ticker.GetTime() + 5;
                }
                if (joyEvent.x == -1) {
                    r = Signals.ScanCode.SC_LEFT;
                    this.joywait = this.DOOM.ticker.GetTime() + 2;
                } else if (joyEvent.x == 1) {
                    r = Signals.ScanCode.SC_RIGHT;
                    this.joywait = this.DOOM.ticker.GetTime() + 2;
                }
                if (joyEvent.isJoy(2)) {
                    r = Signals.ScanCode.SC_BACKSPACE;
                    this.joywait = this.DOOM.ticker.GetTime() + 5;
                } else if (joyEvent.isJoy(1)) {
                    r = Signals.ScanCode.SC_ENTER;
                    this.joywait = this.DOOM.ticker.GetTime() + 5;
                }
                return r;
            });
        } else if (ev.isType(evtype_t.ev_mouse) && this.mousewait < this.DOOM.ticker.GetTime()) {
            sc = ev.mapByMouse(mouseEvent -> {
                Signals.ScanCode r = Signals.ScanCode.SC_NULL;
                this.mousey += mouseEvent.y;
                if (this.mousey < this.lasty - 30) {
                    r = Signals.ScanCode.SC_DOWN;
                    this.mousewait = this.DOOM.ticker.GetTime() + 5;
                    this.mousey = this.lasty -= 30;
                } else if (this.mousey > this.lasty + 30) {
                    r = Signals.ScanCode.SC_UP;
                    this.mousewait = this.DOOM.ticker.GetTime() + 5;
                    this.mousey = this.lasty += 30;
                }
                this.mousex += mouseEvent.x;
                if (this.mousex < this.lastx - 30) {
                    r = Signals.ScanCode.SC_LEFT;
                    this.mousewait = this.DOOM.ticker.GetTime() + 5;
                    this.mousex = this.lastx -= 30;
                } else if (this.mousex > this.lastx + 30) {
                    r = Signals.ScanCode.SC_RIGHT;
                    this.mousewait = this.DOOM.ticker.GetTime() + 5;
                    this.mousex = this.lastx += 30;
                }
                if (mouseEvent.isMouse(2)) {
                    r = Signals.ScanCode.SC_BACKSPACE;
                    this.mousewait = this.DOOM.ticker.GetTime() + 15;
                } else if (mouseEvent.isMouse(1)) {
                    r = Signals.ScanCode.SC_ENTER;
                    this.mousewait = this.DOOM.ticker.GetTime() + 15;
                }
                return r;
            });
            if (sc == Signals.ScanCode.SC_NULL) {
                return false;
            }
        } else if (ev.isType(evtype_t.ev_keydown)) {
            sc = ev.getSC();
        } else {
            return false;
        }
        if (this.saveStringEnter) {
            switch (sc) {
                case SC_BACKSPACE: {
                    if (this.saveCharIndex <= 0) break;
                    --this.saveCharIndex;
                    this.savegamestrings[this.saveSlot][this.saveCharIndex] = '\u0000';
                    break;
                }
                case SC_ESCAPE: {
                    this.saveStringEnter = false;
                    C2JUtils.strcpy(this.savegamestrings[this.saveSlot], this.saveOldString);
                    break;
                }
                case SC_ENTER: {
                    this.saveStringEnter = false;
                    if (this.savegamestrings[this.saveSlot][0] == '\u0000') break;
                    this.DoSave(this.saveSlot);
                    break;
                }
                default: {
                    char ch = Character.toUpperCase(sc.c);
                    if (ch != ' ' && (ch - 33 < 0 || ch - 33 >= 63) || ch < ' ' || ch > '\u007f' || this.saveCharIndex >= 23 || this.StringWidth(this.savegamestrings[this.saveSlot]) >= 176) break;
                    this.savegamestrings[this.saveSlot][this.saveCharIndex++] = ch;
                    this.savegamestrings[this.saveSlot][this.saveCharIndex] = '\u0000';
                }
            }
            return true;
        }
        if (this.messageToPrint) {
            if (this.messageNeedsInput && sc != Signals.ScanCode.SC_SPACE && sc != Signals.ScanCode.SC_N && sc != Signals.ScanCode.SC_Y && sc != Signals.ScanCode.SC_ESCAPE) {
                return false;
            }
            this.DOOM.menuactive = this.messageLastMenuActive;
            this.messageToPrint = false;
            if (this.messageRoutine != null) {
                this.messageRoutine.invoke(sc.c);
            }
            this.DOOM.menuactive = false;
            this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchx);
            return true;
        }
        if (this.DOOM.devparm && sc == Signals.ScanCode.SC_F1 || sc == Signals.ScanCode.SC_PRTSCRN) {
            this.DOOM.ScreenShot();
            return true;
        }
        if (!this.DOOM.menuactive) {
            switch (sc) {
                case SC_MINUS: {
                    if (this.DOOM.automapactive || this.DOOM.headsUp.chat_on[0]) {
                        return false;
                    }
                    this.SizeDisplay.invoke(0);
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_stnmov);
                    return true;
                }
                case SC_EQUALS: {
                    if (this.DOOM.automapactive || this.DOOM.headsUp.chat_on[0]) {
                        return false;
                    }
                    this.SizeDisplay.invoke(1);
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_stnmov);
                    return true;
                }
                case SC_F1: {
                    this.StartControlPanel();
                    this.currentMenu = this.DOOM.isRegistered() || this.DOOM.isShareware() ? this.ReadDef2 : this.ReadDef1;
                    this.itemOn = 0;
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                    return true;
                }
                case SC_F2: {
                    this.StartControlPanel();
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                    this.SaveGame.invoke(0);
                    return true;
                }
                case SC_F3: {
                    this.StartControlPanel();
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                    this.LoadGame.invoke(0);
                    return true;
                }
                case SC_F4: {
                    this.StartControlPanel();
                    this.currentMenu = this.SoundDef;
                    this.itemOn = 0;
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                    return true;
                }
                case SC_F5: {
                    this.ChangeDetail.invoke(0);
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                    return true;
                }
                case SC_F6: {
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                    this.QuickSave();
                    return true;
                }
                case SC_F7: {
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                    this.EndGame.invoke(0);
                    return true;
                }
                case SC_F8: {
                    this.ChangeMessages.invoke(0);
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                    return true;
                }
                case SC_F9: {
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                    this.QuickLoad();
                    return true;
                }
                case SC_F10: {
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                    this.QuitDOOM.invoke(0);
                    return true;
                }
                case SC_F11: {
                    int usegamma = this.DOOM.graphicSystem.getUsegamma();
                    if (++usegamma > 4) {
                        usegamma = 0;
                    }
                    this.DOOM.players[this.DOOM.consoleplayer].message = gammamsg[usegamma];
                    this.DOOM.graphicSystem.setUsegamma(usegamma);
                    this.DOOM.autoMap.Repalette();
                    return true;
                }
            }
        } else if (sc == Signals.ScanCode.SC_F5 && this.DOOM.ticker instanceof DelegateTicker) {
            ((DelegateTicker)this.DOOM.ticker).changeTicker();
            System.err.println("Warning! Ticker changed; time reset");
            this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_radio);
            return true;
        }
        if (!this.DOOM.menuactive) {
            if (sc == Signals.ScanCode.SC_ESCAPE) {
                this.StartControlPanel();
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                return true;
            }
            return false;
        }
        switch (sc) {
            case SC_DOWN: {
                do {
                    this.itemOn = this.itemOn + 1 > this.currentMenu.numitems - 1 ? (short)0 : (short)(this.itemOn + 1);
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pstop);
                } while (this.currentMenu.menuitems[this.itemOn].status == -1);
                return true;
            }
            case SC_UP: {
                do {
                    this.itemOn = this.itemOn == 0 ? (short)(this.currentMenu.numitems - 1) : (short)(this.itemOn - 1);
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pstop);
                } while (this.currentMenu.menuitems[this.itemOn].status == -1);
                return true;
            }
            case SC_LEFT: {
                if (this.currentMenu.menuitems[this.itemOn].routine != null && this.currentMenu.menuitems[this.itemOn].status == 2) {
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_stnmov);
                    this.currentMenu.menuitems[this.itemOn].routine.invoke(0);
                }
                return true;
            }
            case SC_RIGHT: {
                if (this.currentMenu.menuitems[this.itemOn].routine != null && this.currentMenu.menuitems[this.itemOn].status == 2) {
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_stnmov);
                    this.currentMenu.menuitems[this.itemOn].routine.invoke(1);
                }
                return true;
            }
            case SC_ENTER: 
            case SC_NPENTER: {
                if (this.currentMenu.menuitems[this.itemOn].routine != null && this.currentMenu.menuitems[this.itemOn].status != 0) {
                    this.currentMenu.lastOn = this.itemOn;
                    if (this.currentMenu.menuitems[this.itemOn].status == 2) {
                        this.currentMenu.menuitems[this.itemOn].routine.invoke(1);
                        this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_stnmov);
                    } else {
                        this.currentMenu.menuitems[this.itemOn].routine.invoke(this.itemOn);
                        this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pistol);
                    }
                }
                return true;
            }
            case SC_ESCAPE: {
                this.currentMenu.lastOn = this.itemOn;
                this.ClearMenus();
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchx);
                return true;
            }
            case SC_BACKSPACE: {
                this.currentMenu.lastOn = this.itemOn;
                if (this.currentMenu.prevMenu != null) {
                    this.currentMenu = this.currentMenu.prevMenu;
                    this.itemOn = (short)this.currentMenu.lastOn;
                    this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchn);
                }
                return true;
            }
        }
        for (i = this.itemOn + 1; i < this.currentMenu.numitems; ++i) {
            if (this.currentMenu.menuitems[i].alphaKey != sc) continue;
            this.itemOn = (short)i;
            this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pstop);
            return true;
        }
        for (i = 0; i <= this.itemOn; ++i) {
            if (this.currentMenu.menuitems[i].alphaKey != sc) continue;
            this.itemOn = (short)i;
            this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_pstop);
            return true;
        }
        return false;
    }

    @Override
    public void StartControlPanel() {
        if (this.DOOM.menuactive) {
            return;
        }
        this.DOOM.menuactive = true;
        this.currentMenu = this.MainDef;
        this.itemOn = (short)this.currentMenu.lastOn;
    }

    @Override
    public void Drawer() {
        char[] string = new char[40];
        this.inhelpscreens = false;
        if (this.messageToPrint) {
            int start = 0;
            int y = 100 - this.StringHeight(this.messageString) / 2;
            char[] msstring = this.messageString.toCharArray();
            while (start < this.messageString.length()) {
                int i = 0;
                for (i = 0; i < this.messageString.length() - start; ++i) {
                    if (msstring[start + i] != '\n') continue;
                    C2JUtils.memset(string, '\u0000', 40);
                    C2JUtils.strcpy(string, msstring, start, i);
                    start += i + 1;
                    break;
                }
                if (i == this.messageString.length() - start) {
                    C2JUtils.strcpy(string, msstring, start);
                    start += i;
                }
                int x = 160 - this.StringWidth(string) / 2;
                this.WriteText(x, y, string);
                y += this.hu_font[0].height;
            }
            return;
        }
        if (!this.DOOM.menuactive) {
            return;
        }
        if (this.currentMenu.routine != null) {
            this.currentMenu.routine.invoke();
        }
        int x = this.currentMenu.x;
        int y = this.currentMenu.y;
        int max = this.currentMenu.numitems;
        for (int i = 0; i < max; ++i) {
            if (this.currentMenu.menuitems[i].name != null && !"".equals(this.currentMenu.menuitems[i].name)) {
                this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName(this.currentMenu.menuitems[i].name, 101), this.DOOM.vs, x, y, new int[0]);
            }
            y += 16;
        }
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.DOOM.wadLoader.CachePatchName(skullName[this.whichSkull], 101), this.DOOM.vs, x + -32, this.currentMenu.y - 5 + this.itemOn * 16, new int[0]);
    }

    @Override
    public void ClearMenus() {
        this.DOOM.menuactive = false;
        this.DOOM.graphicSystem.forcePalette();
    }

    public void SetupNextMenu(menu_t menudef) {
        this.currentMenu = menudef;
        this.itemOn = (short)this.currentMenu.lastOn;
    }

    @Override
    public void Ticker() {
        this.skullAnimCounter = (short)(this.skullAnimCounter - 1);
        if (this.skullAnimCounter <= 0) {
            this.whichSkull = (short)(this.whichSkull ^ 1);
            this.skullAnimCounter = (short)8;
        }
    }

    @Override
    public void Init() {
        this.initMenuRoutines();
        this.initDrawRoutines();
        this.initMenuItems();
        this.hu_font = this.DOOM.headsUp.getHUFonts();
        this.currentMenu = this.MainDef;
        this.DOOM.menuactive = false;
        this.itemOn = (short)this.currentMenu.lastOn;
        this.whichSkull = 0;
        this.skullAnimCounter = (short)10;
        this.screenSize = this.screenblocks - 3;
        this.messageToPrint = false;
        this.messageString = null;
        this.messageLastMenuActive = this.DOOM.menuactive;
        this.quickSaveSlot = -1;
        switch (this.DOOM.getGameMode()) {
            case freedm: 
            case freedoom2: 
            case commercial: 
            case pack_plut: 
            case pack_tnt: {
                this.MainMenu[4] = this.MainMenu[5];
                --this.MainDef.numitems;
                this.MainDef.y += 8;
                this.NewDef.prevMenu = this.MainDef;
                this.ReadDef1.routine = this.DrawReadThis1;
                this.ReadDef1.x = 330;
                this.ReadDef1.y = 165;
                this.ReadMenu1[0].routine = this.FinishReadThis;
                break;
            }
            case shareware: 
            case registered: {
                --this.EpiDef.numitems;
                break;
            }
        }
    }

    public int DrawText(int x, int y, boolean direct, String string) {
        int c;
        int ptr = 0;
        while ((c = string.charAt(ptr)) > 0) {
            c = Character.toUpperCase(c) - 33;
            ++ptr;
            if (c < 0 || c > 63) {
                x += 4;
                continue;
            }
            short w = this.hu_font[c].width;
            if (x + w > this.DOOM.vs.getScreenWidth()) break;
            if (direct) {
                this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.hu_font[c], this.DOOM.vs, x, y, new int[0]);
            } else {
                this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.hu_font[c], this.DOOM.vs, x, y, new int[0]);
            }
            x += w;
        }
        return x;
    }

    @Override
    public void setScreenBlocks(int val) {
        this.screenblocks = val;
    }

    @Override
    public int getScreenBlocks() {
        return this.screenblocks;
    }

    @Override
    public int getDetailLevel() {
        return this.detailLevel;
    }

    class M_LoadGame
    implements MenuRoutine {
        M_LoadGame() {
        }

        @Override
        public void invoke(int choice) {
            if (Menu.this.DOOM.netgame) {
                Menu.this.StartMessage("you can't do load while in a net game!\n\npress a key.", null, false);
                return;
            }
            Menu.this.SetupNextMenu(Menu.this.LoadDef);
            Menu.this.ReadSaveStrings();
        }
    }

    class M_LoadSelect
    implements MenuRoutine {
        M_LoadSelect() {
        }

        @Override
        public void invoke(int choice) {
            String name = Menu.this.DOOM.cVarManager.bool(CommandVariable.CDROM) ? "c:\\doomdata\\doomsav" + choice + ".dsg" : "doomsav" + choice + ".dsg";
            Menu.this.DOOM.LoadGame(name);
            Menu.this.ClearMenus();
        }
    }

    class M_Episode
    implements MenuRoutine {
        M_Episode() {
        }

        @Override
        public void invoke(int choice) {
            if (Menu.this.DOOM.isShareware() && choice != 0) {
                Menu.this.StartMessage("this is the shareware version of doom.\n\nyou need to order the entire trilogy.\n\npress a key.", null, false);
                Menu.this.SetupNextMenu(Menu.this.ReadDef2);
                return;
            }
            if (!Menu.this.DOOM.isRetail() && choice > 2) {
                System.err.print("M_Episode: 4th episode requires UltimateDOOM\n");
                choice = 0;
            }
            Menu.this.epi = choice;
            Menu.this.SetupNextMenu(Menu.this.NewDef);
        }
    }

    class M_EndGameResponse
    implements MenuRoutine {
        M_EndGameResponse() {
        }

        @Override
        public void invoke(int ch) {
            if (ch != 121) {
                return;
            }
            Menu.this.currentMenu.lastOn = Menu.this.itemOn;
            Menu.this.ClearMenus();
            Menu.this.DOOM.StartTitle();
        }
    }

    class M_EndGame
    implements MenuRoutine {
        M_EndGame() {
        }

        @Override
        public void invoke(int choice) {
            choice = 0;
            if (!Menu.this.DOOM.usergame) {
                Menu.this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_oof);
                return;
            }
            if (Menu.this.DOOM.netgame) {
                Menu.this.StartMessage("you can't end a netgame!\n\npress a key.", null, false);
                return;
            }
            Menu.this.StartMessage("are you sure you want to end the game?\n\npress y or n.", Menu.this.EndGameResponse, true);
        }
    }

    class M_ChooseSkill
    implements MenuRoutine {
        M_ChooseSkill() {
        }

        @Override
        public void invoke(int choice) {
            if (choice == 4) {
                Menu.this.StartMessage("are you sure? this skill level\nisn't even remotely fair.\n\npress y or n.", Menu.this.VerifyNightmare, true);
                return;
            }
            Menu.this.DOOM.DeferedInitNew(skill_t.values()[choice], Menu.this.epi + 1, 1);
            Menu.this.ClearMenus();
        }
    }

    class M_ChangeSensitivity
    implements MenuRoutine {
        M_ChangeSensitivity() {
        }

        @Override
        public void invoke(int choice) {
            switch (choice) {
                case 0: {
                    if (Menu.this.DOOM.mouseSensitivity == 0) break;
                    --Menu.this.DOOM.mouseSensitivity;
                    break;
                }
                case 1: {
                    if (Menu.this.DOOM.mouseSensitivity >= 9) break;
                    ++Menu.this.DOOM.mouseSensitivity;
                }
            }
        }
    }

    class M_ChangeMessages
    implements MenuRoutine {
        M_ChangeMessages() {
        }

        @Override
        public void invoke(int choice) {
            Menu.this.showMessages = !Menu.this.showMessages;
            Menu.this.DOOM.players[Menu.this.DOOM.consoleplayer].message = !Menu.this.showMessages ? "Messages OFF" : "Messages ON";
            Menu.this.message_dontfuckwithme = true;
        }
    }

    class M_ChangeDetail
    implements MenuRoutine {
        M_ChangeDetail() {
        }

        @Override
        public void invoke(int choice) {
            choice = 0;
            Menu.this.detailLevel = 1 - Menu.this.detailLevel;
            Menu.this.DOOM.sceneRenderer.SetViewSize(Menu.this.screenblocks, Menu.this.detailLevel);
            Menu.this.DOOM.players[Menu.this.DOOM.consoleplayer].message = Menu.this.detailLevel == 0 ? "High detail" : "Low detail";
        }
    }

    class M_DrawSound
    implements DrawRoutine {
        M_DrawSound() {
        }

        @Override
        public void invoke() {
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CacheLumpName("M_SVOL", 101, patch_t.class), Menu.this.DOOM.vs, 60, 38, new int[0]);
            Menu.this.DrawThermo(Menu.this.SoundDef.x, Menu.this.SoundDef.y + 16, 16, Menu.this.DOOM.snd_SfxVolume);
            Menu.this.DrawThermo(Menu.this.SoundDef.x, Menu.this.SoundDef.y + 48, 16, Menu.this.DOOM.snd_MusicVolume);
        }
    }

    class M_DrawReadThis2
    implements DrawRoutine {
        M_DrawReadThis2() {
        }

        @Override
        public void invoke() {
            Menu.this.inhelpscreens = true;
            String lumpname = "HELP1";
            int skullx = 330;
            int skully = 175;
            Menu.this.ReadDef2.x = skullx;
            Menu.this.ReadDef2.y = skully;
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName(lumpname), Menu.this.DOOM.vs, 0, 0, new int[0]);
            Menu.this.DOOM.statusBar.forceRefresh();
        }
    }

    class M_DrawReadThis1
    implements DrawRoutine {
        M_DrawReadThis1() {
        }

        @Override
        public void invoke() {
            String lumpname;
            int skully;
            int skullx;
            Menu.this.inhelpscreens = true;
            switch (Menu.this.DOOM.getGameMode()) {
                case freedm: 
                case freedoom2: 
                case commercial: 
                case pack_plut: 
                case pack_tnt: {
                    skullx = 330;
                    skully = 165;
                    lumpname = "HELP";
                    break;
                }
                case shareware: {
                    lumpname = "HELP2";
                    skullx = 280;
                    skully = 185;
                    break;
                }
                default: {
                    lumpname = "CREDIT";
                    skullx = 330;
                    skully = 165;
                }
            }
            Menu.this.ReadDef1.x = skullx;
            Menu.this.ReadDef1.y = skully;
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName(lumpname), Menu.this.DOOM.vs, 0, 0, new int[0]);
            Menu.this.DOOM.statusBar.forceRefresh();
        }
    }

    class M_DrawOptions
    implements DrawRoutine {
        private final String[] detailNames = new String[]{"M_GDHIGH", "M_GDLOW"};
        private final String[] msgNames = new String[]{"M_MSGOFF", "M_MSGON"};

        M_DrawOptions() {
        }

        @Override
        public void invoke() {
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName("M_OPTTTL"), Menu.this.DOOM.vs, 108, 15, new int[0]);
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName(this.detailNames[Menu.this.detailLevel]), Menu.this.DOOM.vs, Menu.this.OptionsDef.x + 175, Menu.this.OptionsDef.y + 32, new int[0]);
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName(this.msgNames[Menu.this.showMessages ? 1 : 0]), Menu.this.DOOM.vs, Menu.this.OptionsDef.x + 120, Menu.this.OptionsDef.y + 16, new int[0]);
            Menu.this.DrawThermo(Menu.this.OptionsDef.x, Menu.this.OptionsDef.y + 96, 10, Menu.this.DOOM.mouseSensitivity);
            Menu.this.DrawThermo(Menu.this.OptionsDef.x, Menu.this.OptionsDef.y + 64, 9, Menu.this.screenSize);
        }
    }

    class M_DrawNewGame
    implements DrawRoutine {
        M_DrawNewGame() {
        }

        @Override
        public void invoke() {
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName("M_NEWG"), Menu.this.DOOM.vs, 96, 14, new int[0]);
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName("M_SKILL"), Menu.this.DOOM.vs, 54, 38, new int[0]);
        }
    }

    class M_DrawMainMenu
    implements DrawRoutine {
        M_DrawMainMenu() {
        }

        @Override
        public void invoke() {
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName("M_DOOM"), Menu.this.DOOM.vs, 94, 2, new int[0]);
        }
    }

    class M_DrawLoad
    implements DrawRoutine {
        M_DrawLoad() {
        }

        @Override
        public void invoke() {
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName("M_LOADG"), Menu.this.DOOM.vs, 72, 28, new int[0]);
            for (int i = 0; i < 6; ++i) {
                Menu.this.DrawSaveLoadBorder(Menu.this.LoadDef.x, Menu.this.LoadDef.y + 16 * i);
                Menu.this.WriteText(Menu.this.LoadDef.x, Menu.this.LoadDef.y + 16 * i, Menu.this.savegamestrings[i]);
            }
        }
    }

    class M_DrawEpisode
    implements DrawRoutine {
        M_DrawEpisode() {
        }

        @Override
        public void invoke() {
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName("M_EPISOD"), Menu.this.DOOM.vs, 54, 38, new int[0]);
        }
    }

    class M_NewGame
    implements MenuRoutine {
        M_NewGame() {
        }

        @Override
        public void invoke(int choice) {
            if (Menu.this.DOOM.netgame && !Menu.this.DOOM.demoplayback) {
                Menu.this.StartMessage("you can't start a new game\nwhile in a network game.\n\npress a key.", null, false);
                return;
            }
            if (Menu.this.DOOM.isCommercial()) {
                Menu.this.SetupNextMenu(Menu.this.NewDef);
            } else {
                Menu.this.SetupNextMenu(Menu.this.EpiDef);
            }
        }
    }

    class M_Options
    implements MenuRoutine {
        M_Options() {
        }

        @Override
        public void invoke(int choice) {
            Menu.this.SetupNextMenu(Menu.this.OptionsDef);
        }
    }

    class M_SizeDisplay
    implements MenuRoutine {
        M_SizeDisplay() {
        }

        @Override
        public void invoke(int choice) {
            switch (choice) {
                case 0: {
                    if (Menu.this.screenSize <= 0) break;
                    --Menu.this.screenblocks;
                    --Menu.this.screenSize;
                    break;
                }
                case 1: {
                    if (Menu.this.screenSize >= 8) break;
                    ++Menu.this.screenblocks;
                    ++Menu.this.screenSize;
                }
            }
            Menu.this.DOOM.sceneRenderer.SetViewSize(Menu.this.screenblocks, Menu.this.detailLevel);
        }
    }

    class M_QuitGame
    implements MenuRoutine {
        M_QuitGame() {
        }

        @Override
        public void invoke(int ch) {
            if (ch != 121) {
                return;
            }
            if (!Menu.this.DOOM.netgame) {
                if (Menu.this.DOOM.isCommercial()) {
                    Menu.this.DOOM.doomSound.StartSound(null, quitsounds2[Menu.this.DOOM.gametic >> 2 & 7]);
                } else {
                    Menu.this.DOOM.doomSound.StartSound(null, quitsounds[Menu.this.DOOM.gametic >> 2 & 7]);
                }
                Menu.this.DOOM.doomSystem.WaitVBL(105);
            }
            Menu.this.DOOM.doomSystem.Quit();
        }
    }

    class M_QuitDOOM
    implements MenuRoutine {
        M_QuitDOOM() {
        }

        @Override
        public void invoke(int choice) {
            Menu.this.endstring = Menu.this.DOOM.language != Language_t.english ? dstrings.endmsg[0] + "\n\n" + "(press y to quit)" : dstrings.endmsg[Menu.this.DOOM.gametic % 13 + 1] + "\n\n" + "(press y to quit)";
            Menu.this.StartMessage(Menu.this.endstring, Menu.this.QuitResponse, true);
        }
    }

    class M_FinishReadThis
    implements MenuRoutine {
        M_FinishReadThis() {
        }

        @Override
        public void invoke(int choice) {
            choice = 0;
            Menu.this.SetupNextMenu(Menu.this.MainDef);
        }
    }

    class M_ReadThis2
    implements MenuRoutine {
        M_ReadThis2() {
        }

        @Override
        public void invoke(int choice) {
            choice = 0;
            Menu.this.SetupNextMenu(Menu.this.ReadDef2);
        }
    }

    class M_ReadThis
    implements MenuRoutine {
        M_ReadThis() {
        }

        @Override
        public void invoke(int choice) {
            choice = 0;
            Menu.this.SetupNextMenu(Menu.this.ReadDef1);
        }
    }

    class M_VerifyNightmare
    implements MenuRoutine {
        M_VerifyNightmare() {
        }

        @Override
        public void invoke(int ch) {
            if (ch != 121) {
                return;
            }
            Menu.this.DOOM.DeferedInitNew(skill_t.sk_nightmare, Menu.this.epi + 1, 1);
            Menu.this.ClearMenus();
        }
    }

    class M_MusicVol
    implements MenuRoutine {
        M_MusicVol() {
        }

        @Override
        public void invoke(int choice) {
            switch (choice) {
                case 0: {
                    if (Menu.this.DOOM.snd_MusicVolume == 0) break;
                    --Menu.this.DOOM.snd_MusicVolume;
                    break;
                }
                case 1: {
                    if (Menu.this.DOOM.snd_MusicVolume >= 15) break;
                    ++Menu.this.DOOM.snd_MusicVolume;
                }
            }
            Menu.this.DOOM.doomSound.SetMusicVolume(Menu.this.DOOM.snd_MusicVolume * 8);
        }
    }

    class M_SfxVol
    implements MenuRoutine {
        M_SfxVol() {
        }

        @Override
        public void invoke(int choice) {
            switch (choice) {
                case 0: {
                    if (Menu.this.DOOM.snd_SfxVolume == 0) break;
                    --Menu.this.DOOM.snd_SfxVolume;
                    break;
                }
                case 1: {
                    if (Menu.this.DOOM.snd_SfxVolume >= 15) break;
                    ++Menu.this.DOOM.snd_SfxVolume;
                }
            }
            Menu.this.DOOM.doomSound.SetSfxVolume(Menu.this.DOOM.snd_SfxVolume * 8);
        }
    }

    class M_Sound
    implements MenuRoutine {
        M_Sound() {
        }

        @Override
        public void invoke(int choice) {
            Menu.this.SetupNextMenu(Menu.this.SoundDef);
        }
    }

    class M_QuitResponse
    implements MenuRoutine {
        M_QuitResponse() {
        }

        @Override
        public void invoke(int ch) {
            if (ch != 121) {
                return;
            }
            if (!Menu.this.DOOM.netgame) {
                if (Menu.this.DOOM.isCommercial()) {
                    Menu.this.DOOM.doomSound.StartSound(null, quitsounds2[Menu.this.DOOM.gametic >> 2 & 7]);
                } else {
                    Menu.this.DOOM.doomSound.StartSound(null, quitsounds[Menu.this.DOOM.gametic >> 2 & 7]);
                }
            }
            Menu.this.DOOM.doomSystem.Quit();
        }
    }

    class M_QuickLoadResponse
    implements MenuRoutine {
        M_QuickLoadResponse() {
        }

        @Override
        public void invoke(int ch) {
            if (ch == 121) {
                Menu.this.LoadSelect.invoke(Menu.this.quickSaveSlot);
                Menu.this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchx);
            }
        }
    }

    class M_QuickSaveResponse
    implements MenuRoutine {
        M_QuickSaveResponse() {
        }

        @Override
        public void invoke(int ch) {
            if (ch == 121) {
                Menu.this.DoSave(Menu.this.quickSaveSlot);
                Menu.this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_swtchx);
            }
        }
    }

    class M_SaveGame
    implements MenuRoutine {
        M_SaveGame() {
        }

        @Override
        public void invoke(int choice) {
            if (!Menu.this.DOOM.usergame) {
                Menu.this.StartMessage("you can't save if you aren't playing!\n\npress a key.", null, false);
                return;
            }
            if (Menu.this.DOOM.gamestate != gamestate_t.GS_LEVEL) {
                return;
            }
            Menu.this.SetupNextMenu(Menu.this.SaveDef);
            Menu.this.ReadSaveStrings();
        }
    }

    class M_SaveSelect
    implements MenuRoutine {
        M_SaveSelect() {
        }

        @Override
        public void invoke(int choice) {
            Menu.this.saveStringEnter = true;
            Menu.this.saveSlot = choice;
            C2JUtils.strcpy(Menu.this.saveOldString, Menu.this.savegamestrings[choice]);
            if (C2JUtils.strcmp(Menu.this.savegamestrings[choice], "empty slot")) {
                Menu.this.savegamestrings[choice][0] = '\u0000';
            }
            Menu.this.saveCharIndex = C2JUtils.strlen(Menu.this.savegamestrings[choice]);
        }
    }

    public class M_DrawSave
    implements DrawRoutine {
        @Override
        public void invoke() {
            int i;
            Menu.this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, Menu.this.DOOM.wadLoader.CachePatchName("M_SAVEG"), Menu.this.DOOM.vs, 72, 28, new int[0]);
            for (i = 0; i < 6; ++i) {
                Menu.this.DrawSaveLoadBorder(Menu.this.LoadDef.x, Menu.this.LoadDef.y + 16 * i);
                Menu.this.WriteText(Menu.this.LoadDef.x, Menu.this.LoadDef.y + 16 * i, Menu.this.savegamestrings[i]);
            }
            if (Menu.this.saveStringEnter) {
                i = Menu.this.StringWidth(Menu.this.savegamestrings[Menu.this.saveSlot]);
                Menu.this.WriteText(Menu.this.LoadDef.x + i, Menu.this.LoadDef.y + 16 * Menu.this.saveSlot, "_");
            }
        }
    }
}

