/*
 * Decompiled with CFR 0.152.
 */
package m;

import awt.FullscreenOptions;
import doom.ConfigBase;
import doom.ConfigManager;
import g.Signals;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mochadoom.Engine;
import utils.QuoteType;
import v.graphics.Plotter;
import v.renderers.BppMode;
import v.renderers.SceneRendererMode;
import v.tables.GreyscaleFilter;

public enum Settings {
    mouse_sensitivity(ConfigBase.FILE_DOOM, 5),
    sfx_volume(ConfigBase.FILE_DOOM, 8),
    music_volume(ConfigBase.FILE_DOOM, 8),
    show_messages(ConfigBase.FILE_DOOM, 1),
    key_right(ConfigBase.FILE_DOOM, Signals.ScanCode.SC_RIGHT.ordinal()),
    key_left(ConfigBase.FILE_DOOM, Signals.ScanCode.SC_LEFT.ordinal()),
    key_up(ConfigBase.FILE_DOOM, Signals.ScanCode.SC_W.ordinal()),
    key_down(ConfigBase.FILE_DOOM, Signals.ScanCode.SC_S.ordinal()),
    key_strafeleft(ConfigBase.FILE_DOOM, Signals.ScanCode.SC_A.ordinal()),
    key_straferight(ConfigBase.FILE_DOOM, Signals.ScanCode.SC_D.ordinal()),
    key_fire(ConfigBase.FILE_DOOM, Signals.ScanCode.SC_LCTRL.ordinal()),
    key_use(ConfigBase.FILE_DOOM, Signals.ScanCode.SC_SPACE.ordinal()),
    key_strafe(ConfigBase.FILE_DOOM, Signals.ScanCode.SC_LALT.ordinal()),
    key_speed(ConfigBase.FILE_DOOM, Signals.ScanCode.SC_RSHIFT.ordinal()),
    use_mouse(ConfigBase.FILE_DOOM, 1),
    mouseb_fire(ConfigBase.FILE_DOOM, 0),
    mouseb_strafe(ConfigBase.FILE_DOOM, 1),
    mouseb_forward(ConfigBase.FILE_DOOM, 2),
    use_joystick(ConfigBase.FILE_DOOM, 0),
    joyb_fire(ConfigBase.FILE_DOOM, 0),
    joyb_strafe(ConfigBase.FILE_DOOM, 1),
    joyb_use(ConfigBase.FILE_DOOM, 3),
    joyb_speed(ConfigBase.FILE_DOOM, 2),
    screenblocks(ConfigBase.FILE_DOOM, 9),
    detaillevel(ConfigBase.FILE_DOOM, 0),
    snd_channels(ConfigBase.FILE_DOOM, 8),
    snd_musicdevice(ConfigBase.FILE_DOOM, 3),
    snd_sfxdevice(ConfigBase.FILE_DOOM, 3),
    snd_sbport(ConfigBase.FILE_DOOM, 0),
    snd_sbirq(ConfigBase.FILE_DOOM, 0),
    snd_sbdma(ConfigBase.FILE_DOOM, 0),
    snd_mport(ConfigBase.FILE_DOOM, 0),
    usegamma(ConfigBase.FILE_DOOM, 0),
    chatmacro0(ConfigBase.FILE_DOOM, "No"),
    chatmacro1(ConfigBase.FILE_DOOM, "I'm ready to kick butt!"),
    chatmacro2(ConfigBase.FILE_DOOM, "I'm OK."),
    chatmacro3(ConfigBase.FILE_DOOM, "I'm not looking too good!"),
    chatmacro4(ConfigBase.FILE_DOOM, "Help!"),
    chatmacro5(ConfigBase.FILE_DOOM, "You suck!"),
    chatmacro6(ConfigBase.FILE_DOOM, "Next time, scumbag..."),
    chatmacro7(ConfigBase.FILE_DOOM, "Come here!"),
    chatmacro8(ConfigBase.FILE_DOOM, "I'll take care of it."),
    chatmacro9(ConfigBase.FILE_DOOM, "Yes"),
    mb_used(ConfigBase.FILE_MOCHADOOM, 2),
    fullscreen(ConfigBase.FILE_MOCHADOOM, false),
    fullscreen_mode(ConfigBase.FILE_MOCHADOOM, FullscreenOptions.FullMode.Best),
    fullscreen_stretch(ConfigBase.FILE_MOCHADOOM, FullscreenOptions.StretchMode.Fit),
    fullscreen_interpolation(ConfigBase.FILE_MOCHADOOM, FullscreenOptions.InterpolationMode.Nearest),
    alwaysrun(ConfigBase.FILE_MOCHADOOM, false),
    vanilla_key_behavior(ConfigBase.FILE_MOCHADOOM, true),
    automap_plotter_style(ConfigBase.FILE_MOCHADOOM, Plotter.Style.Thin),
    enable_colormap_lump(ConfigBase.FILE_MOCHADOOM, true),
    color_depth(ConfigBase.FILE_MOCHADOOM, BppMode.Indexed),
    extend_plats_limit(ConfigBase.FILE_MOCHADOOM, true),
    extend_button_slots_limit(ConfigBase.FILE_MOCHADOOM, true),
    fix_blockmap(ConfigBase.FILE_MOCHADOOM, true),
    fix_gamma_ramp(ConfigBase.FILE_MOCHADOOM, false),
    fix_gamma_palette(ConfigBase.FILE_MOCHADOOM, false),
    fix_sky_change(ConfigBase.FILE_MOCHADOOM, false),
    fix_sky_palette(ConfigBase.FILE_MOCHADOOM, false),
    fix_medi_need(ConfigBase.FILE_MOCHADOOM, false),
    fix_ouch_face(ConfigBase.FILE_MOCHADOOM, false),
    line_of_sight(ConfigBase.FILE_MOCHADOOM, LOS.Vanilla),
    vestrobe(ConfigBase.FILE_MOCHADOOM, false),
    scale_screen_tiles(ConfigBase.FILE_MOCHADOOM, true),
    scale_melt(ConfigBase.FILE_MOCHADOOM, true),
    semi_translucent_fuzz(ConfigBase.FILE_MOCHADOOM, false),
    fuzz_mix(ConfigBase.FILE_MOCHADOOM, false),
    parallelism_realcolor_tint(ConfigBase.FILE_MOCHADOOM, Runtime.getRuntime().availableProcessors()),
    parallelism_patch_columns(ConfigBase.FILE_MOCHADOOM, 0),
    greyscale_filter(ConfigBase.FILE_MOCHADOOM, GreyscaleFilter.Luminance),
    scene_renderer_mode(ConfigBase.FILE_MOCHADOOM, SceneRendererMode.Serial),
    reconstruct_savegame_pointers(ConfigBase.FILE_MOCHADOOM, true);

    public static final Map<ConfigBase.Files, EnumSet<Settings>> SETTINGS_MAP;
    public final Class<?> valueType;
    public final Object defaultValue;
    private ConfigBase.Files configBase;

    private <T extends Enum<T>> Settings(ConfigBase.Files config, T defaultValue) {
        this.defaultValue = defaultValue;
        this.valueType = defaultValue.getClass();
        this.configBase = config;
    }

    private Settings(ConfigBase.Files config, String defaultValue) {
        this.defaultValue = defaultValue;
        this.valueType = String.class;
        this.configBase = config;
    }

    private Settings(ConfigBase.Files config, char defaultValue) {
        this.defaultValue = Character.valueOf(defaultValue);
        this.valueType = Character.class;
        this.configBase = config;
    }

    private Settings(ConfigBase.Files config, int defaultValue) {
        this.defaultValue = defaultValue;
        this.valueType = Integer.class;
        this.configBase = config;
    }

    private Settings(ConfigBase.Files config, long defaultValue) {
        this.defaultValue = defaultValue;
        this.valueType = Long.class;
        this.configBase = config;
    }

    private Settings(ConfigBase.Files config, double defaultValue) {
        this.defaultValue = defaultValue;
        this.valueType = Double.class;
        this.configBase = config;
    }

    private Settings(ConfigBase.Files config, boolean defaultValue) {
        this.defaultValue = defaultValue;
        this.valueType = Boolean.class;
        this.configBase = config;
    }

    public boolean is(Object obj) {
        return Engine.getConfig().equals(obj);
    }

    public ConfigManager.UpdateStatus hasChange(boolean b) {
        this.configBase.changed = this.configBase.changed || b;
        return b ? ConfigManager.UpdateStatus.UPDATED : ConfigManager.UpdateStatus.UNCHANGED;
    }

    public void rebase(ConfigBase.Files newConfig) {
        if (this.configBase == newConfig) {
            return;
        }
        SETTINGS_MAP.get(this.configBase).remove((Object)this);
        this.configBase = newConfig;
        this.updateConfig();
    }

    public Optional<QuoteType> quoteType() {
        if (this.valueType == String.class) {
            return Optional.of(QuoteType.DOUBLE);
        }
        if (this.valueType == Character.class) {
            return Optional.of(QuoteType.SINGLE);
        }
        return Optional.empty();
    }

    private void updateConfig() {
        SETTINGS_MAP.compute(this.configBase, (c, list) -> {
            if (list == null) {
                list = EnumSet.of(this);
            } else {
                list.add(this);
            }
            return list;
        });
    }

    static {
        SETTINGS_MAP = new HashMap<ConfigBase.Files, EnumSet<Settings>>();
        Arrays.stream(Settings.values()).forEach(Settings::updateConfig);
    }

    public static enum LOS {
        Vanilla,
        Boom;

    }
}

