/*
 * Decompiled with CFR 0.152.
 */
package mochadoom;

import awt.DoomWindow;
import awt.DoomWindowController;
import awt.EventBase;
import awt.EventHandler;
import doom.CVarManager;
import doom.CommandVariable;
import doom.ConfigManager;
import doom.DoomMain;
import g.Signals;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Engine {
    private static volatile Engine instance;
    public final CVarManager cvm;
    public final ConfigManager cm;
    public final DoomWindowController<?, EventHandler> windowController;
    private final DoomMain<?, ?> DOOM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws IOException {
        Class<Engine> clazz = Engine.class;
        synchronized (Engine.class) {
            Engine local = new Engine(argv);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            local.DOOM.setupLoop();
            return;
        }
    }

    private Engine(String ... argv) throws IOException {
        instance = this;
        this.cvm = new CVarManager(Arrays.asList(argv));
        this.cm = new ConfigManager();
        this.DOOM = new DoomMain();
        this.windowController = DoomWindow.createCanvasWindowController(this.DOOM.graphicSystem::getScreenImage, this.DOOM::PostEvent, this.DOOM.graphicSystem.getScreenWidth(), this.DOOM.graphicSystem.getScreenHeight());
        this.windowController.getObserver().addInterest(new EventBase.KeyStateInterest(obs -> {
            EventHandler.fullscreenChanges(this.windowController.getObserver(), this.windowController.switchFullscreen());
            return EventBase.KeyStateSatisfaction.WANTS_MORE_ATE;
        }, Signals.ScanCode.SC_LALT, Signals.ScanCode.SC_ENTER)).addInterest(new EventBase.KeyStateInterest(obs -> {
            if (!this.windowController.isFullscreen()) {
                if (this.DOOM.menuactive || this.DOOM.paused || this.DOOM.demoplayback) {
                    this.DOOM.mousecaptured = !this.DOOM.mousecaptured;
                    EventHandler.menuCaptureChanges(obs, this.DOOM.mousecaptured);
                } else {
                    this.DOOM.mousecaptured = true;
                    EventHandler.menuCaptureChanges(obs, true);
                }
            }
            return EventBase.KeyStateSatisfaction.WANTS_MORE_PASS;
        }, Signals.ScanCode.SC_LALT, new Signals.ScanCode[0])).addInterest(new EventBase.KeyStateInterest(obs -> {
            if (!this.windowController.isFullscreen() && !this.DOOM.mousecaptured && this.DOOM.menuactive) {
                this.DOOM.mousecaptured = true;
                EventHandler.menuCaptureChanges(obs, true);
            }
            return EventBase.KeyStateSatisfaction.WANTS_MORE_PASS;
        }, Signals.ScanCode.SC_ESCAPE, new Signals.ScanCode[0])).addInterest(new EventBase.KeyStateInterest(obs -> {
            if (!this.windowController.isFullscreen() && !this.DOOM.mousecaptured && this.DOOM.paused) {
                this.DOOM.mousecaptured = true;
                EventHandler.menuCaptureChanges(obs, true);
            }
            return EventBase.KeyStateSatisfaction.WANTS_MORE_PASS;
        }, Signals.ScanCode.SC_PAUSE, new Signals.ScanCode[0]));
    }

    public static void updateFrame() {
        Engine.instance.windowController.updateFrame();
    }

    public String getWindowTitle(double frames) {
        if (this.cvm.bool(CommandVariable.SHOWFPS)) {
            return String.format("%s - %s FPS: %.2f", new Object[]{"Mocha Doom Alpha 1.6", this.DOOM.bppMode, frames});
        }
        return String.format("%s - %s", new Object[]{"Mocha Doom Alpha 1.6", this.DOOM.bppMode});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Engine getEngine() {
        Engine local = instance;
        if (local != null) return local;
        Class<Engine> clazz = Engine.class;
        synchronized (Engine.class) {
            local = instance;
            if (local != null) return local;
            try {
                instance = local = new Engine(new String[0]);
            }
            catch (IOException ex) {
                Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, null, ex);
                throw new Error("This launch is DOOMed");
            }
            return local;
        }
    }

    public static CVarManager getCVM() {
        return Engine.getEngine().cvm;
    }

    public static ConfigManager getConfig() {
        return Engine.getEngine().cm;
    }
}

