/*
 * Decompiled with CFR 0.152.
 */
package n;

import doom.CommandVariable;
import doom.DoomMain;
import doom.doomcom_t;
import doom.doomdata_t;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.IllegalBlockingModeException;
import n.DoomSystemNetworking;
import w.DoomBuffer;

public class BasicNetworkInterface
implements DoomSystemNetworking {
    protected DoomMain<?, ?> DOOM;
    doomcom_t doomcom;
    int DOOMPORT;
    int RECVPORT;
    int SENDPORT;
    DatagramSocket insocket;
    DatagramSocket[] sendaddress;
    private final doomdata_t sendData;
    private final doomdata_t recvData;
    private final DatagramPacket recvPacket;
    private final DatagramPacket sendPacket;
    public PacketSend packetSend;
    private boolean first;
    public PacketGet packetGet;
    NetFunction netget;
    NetFunction netsend;
    private StringBuilder sb;

    public BasicNetworkInterface(DoomMain<?, ?> DOOM) {
        this.RECVPORT = this.DOOMPORT = 666;
        this.SENDPORT = this.DOOMPORT;
        this.sendaddress = new DatagramSocket[8];
        this.packetSend = new PacketSend();
        this.first = true;
        this.packetGet = new PacketGet();
        this.netget = this.packetGet;
        this.netsend = this.packetSend;
        this.sb = new StringBuilder();
        this.DOOM = DOOM;
        this.sendData = new doomdata_t();
        this.recvData = new doomdata_t();
        this.recvPacket = new DatagramPacket(this.recvData.cached(), this.recvData.cached().length);
        this.sendPacket = new DatagramPacket(this.sendData.cached(), this.sendData.cached().length);
    }

    public static int ntohl(int x) {
        return (x & 0xFF) << 24 | (x & 0xFF00) << 8 | (x & 0xFF0000) >>> 8 | (x & 0xFF000000) >>> 24;
    }

    public static short ntohs(short x) {
        return (short)((x & 0xFF) << 8 | (x & 0xFF00) >>> 8);
    }

    public static int htonl(int x) {
        return BasicNetworkInterface.ntohl(x);
    }

    public static short htons(short x) {
        return BasicNetworkInterface.ntohs(x);
    }

    public void sendSocketPacket(DatagramSocket ds, DatagramPacket dp) throws IOException {
        ds.send(dp);
    }

    public void socketGetPacket(DatagramSocket ds, DatagramPacket dp) throws IOException {
        ds.receive(dp);
    }

    @Override
    public void InitNetwork() {
        String[] hosts;
        this.doomcom = new doomcom_t();
        this.DOOM.setDoomCom(this.doomcom);
        if (!this.DOOM.cVarManager.with(CommandVariable.DUP, 0, c -> {
            this.doomcom.ticdup = (short)(c.charValue() - 48);
            if (this.doomcom.ticdup < 1) {
                this.doomcom.ticdup = 1;
            }
            if (this.doomcom.ticdup > 9) {
                this.doomcom.ticdup = (short)9;
            }
        })) {
            this.doomcom.ticdup = 1;
        }
        this.doomcom.extratics = this.DOOM.cVarManager.bool(CommandVariable.EXTRATIC) ? (short)1 : 0;
        this.DOOM.cVarManager.with(CommandVariable.PORT, 0, port -> {
            this.DOOMPORT = port;
            System.out.println("using alternate port " + this.DOOMPORT);
        });
        if (!this.DOOM.cVarManager.present(CommandVariable.NET)) {
            this.DOOM.netgame = false;
            this.doomcom.id = 305419896;
            this.doomcom.numnodes = 1;
            this.doomcom.numplayers = 1;
            this.doomcom.deathmatch = 0;
            this.doomcom.consoleplayer = 0;
            return;
        }
        this.DOOM.netgame = true;
        this.doomcom.consoleplayer = (short)(this.DOOM.cVarManager.get(CommandVariable.NET, Character.class, 0).get().charValue() - 49);
        this.SENDPORT = this.DOOMPORT;
        this.RECVPORT = this.SENDPORT++;
        if (this.doomcom.consoleplayer != 0) {
            ++this.RECVPORT;
        }
        this.doomcom.numnodes = 1;
        for (String host : hosts = this.DOOM.cVarManager.get(CommandVariable.NET, String[].class, 1).get()) {
            try {
                InetAddress addr = InetAddress.getByName(host);
                DatagramSocket ds = new DatagramSocket(null);
                ds.setReuseAddress(true);
                ds.connect(addr, this.SENDPORT);
                this.sendaddress[this.doomcom.numnodes] = ds;
            }
            catch (SocketException | UnknownHostException e) {
                e.printStackTrace();
            }
            this.doomcom.numnodes = (short)(this.doomcom.numnodes + 1);
        }
        this.doomcom.id = 305419896;
        this.doomcom.numplayers = this.doomcom.numnodes;
        try {
            this.insocket = new DatagramSocket(null);
            this.insocket.setReuseAddress(true);
            this.insocket.setSoTimeout(1);
            this.insocket.bind(new InetSocketAddress(this.RECVPORT));
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void NetCmd() {
        if (this.insocket == null) {
            return;
        }
        if (this.DOOM.doomcom.command == 1) {
            this.netsend.invoke();
        } else if (this.doomcom.command == 2) {
            this.netget.invoke();
        } else {
            this.DOOM.doomSystem.Error("Bad net cmd: %i\n", this.doomcom.command);
        }
    }

    public class PacketGet
    implements NetFunction {
        @Override
        public void invoke() {
            int i;
            block6: {
                try {
                    BasicNetworkInterface.this.socketGetPacket(BasicNetworkInterface.this.insocket, BasicNetworkInterface.this.recvPacket);
                }
                catch (SocketTimeoutException e) {
                    BasicNetworkInterface.this.doomcom.remotenode = (short)-1;
                    return;
                }
                catch (Exception e) {
                    if (e.getClass() == IllegalBlockingModeException.class) break block6;
                    BasicNetworkInterface.this.DOOM.doomSystem.Error("GetPacket: %s", e.getStackTrace());
                }
            }
            BasicNetworkInterface.this.recvData.unpack(BasicNetworkInterface.this.recvPacket.getData());
            InetAddress fromaddress = BasicNetworkInterface.this.recvPacket.getAddress();
            if (BasicNetworkInterface.this.first) {
                BasicNetworkInterface.this.sb.setLength(0);
                BasicNetworkInterface.this.sb.append("(").append(BasicNetworkInterface.this.DOOM.consoleplayer).append(") PacketRECV len=");
                BasicNetworkInterface.this.sb.append(BasicNetworkInterface.this.recvPacket.getLength());
                BasicNetworkInterface.this.sb.append(":p=[0x");
                BasicNetworkInterface.this.sb.append(Integer.toHexString(((BasicNetworkInterface)BasicNetworkInterface.this).recvData.checksum));
                BasicNetworkInterface.this.sb.append(" 0x");
                BasicNetworkInterface.this.sb.append(DoomBuffer.getBEInt(((BasicNetworkInterface)BasicNetworkInterface.this).recvData.retransmitfrom, ((BasicNetworkInterface)BasicNetworkInterface.this).recvData.starttic, ((BasicNetworkInterface)BasicNetworkInterface.this).recvData.player, ((BasicNetworkInterface)BasicNetworkInterface.this).recvData.numtics));
                BasicNetworkInterface.this.sb.append("numtics: ").append(((BasicNetworkInterface)BasicNetworkInterface.this).recvData.numtics);
                System.out.println(BasicNetworkInterface.this.sb.toString());
                BasicNetworkInterface.this.first = false;
            }
            for (i = 0; !(i >= BasicNetworkInterface.this.doomcom.numnodes || BasicNetworkInterface.this.sendaddress[i] != null && fromaddress.equals(BasicNetworkInterface.this.sendaddress[i].getInetAddress())); ++i) {
            }
            if (i == BasicNetworkInterface.this.doomcom.numnodes) {
                BasicNetworkInterface.this.doomcom.remotenode = (short)-1;
                return;
            }
            BasicNetworkInterface.this.doomcom.remotenode = (short)i;
            BasicNetworkInterface.this.doomcom.datalength = (short)BasicNetworkInterface.this.recvPacket.getLength();
            BasicNetworkInterface.this.DOOM.netbuffer.copyFrom(BasicNetworkInterface.this.recvData);
        }
    }

    public class PacketSend
    implements NetFunction {
        @Override
        public void invoke() {
            doomdata_t netbuffer = BasicNetworkInterface.this.DOOM.netbuffer;
            BasicNetworkInterface.this.sendData.copyFrom(netbuffer);
            byte[] bytes = BasicNetworkInterface.this.sendData.pack();
            BasicNetworkInterface.this.sendPacket.setData(bytes, 0, BasicNetworkInterface.this.doomcom.datalength);
            try {
                DatagramSocket sendsocket = BasicNetworkInterface.this.sendaddress[BasicNetworkInterface.this.doomcom.remotenode];
                BasicNetworkInterface.this.sendPacket.setSocketAddress(sendsocket.getRemoteSocketAddress());
                BasicNetworkInterface.this.sendSocketPacket(sendsocket, BasicNetworkInterface.this.sendPacket);
            }
            catch (Exception e) {
                e.printStackTrace();
                BasicNetworkInterface.this.DOOM.doomSystem.Error("SendPacket error: %s", e.getMessage());
            }
        }
    }

    static interface NetFunction {
        public void invoke();
    }
}

