/*
 * Decompiled with CFR 0.152.
 */
package p;

import data.mapthing_t;
import doom.DoomMain;
import m.BBox;
import m.Settings;
import mochadoom.Engine;
import p.ILevelLoader;
import p.mobj_t;
import rr.line_t;
import rr.node_t;
import rr.sector_t;
import rr.seg_t;
import rr.side_t;
import rr.subsector_t;
import rr.vertex_t;
import utils.C2JUtils;

public abstract class AbstractLevelLoader
implements ILevelLoader {
    final DoomMain<?, ?> DOOM;
    public int numvertexes;
    public vertex_t[] vertexes;
    public int numsegs;
    public seg_t[] segs;
    public int numsectors;
    public sector_t[] sectors;
    public int numsubsectors;
    public subsector_t[] subsectors;
    public int numnodes;
    public node_t[] nodes;
    public int numlines;
    public line_t[] lines;
    public int numsides;
    public side_t[] sides;
    public int bmapwidth;
    public int bmapheight;
    public int[] blockmap;
    protected int[] blockmaplump;
    public int bmaporgx;
    public int bmaporgy;
    public mobj_t[] blocklinks;
    public byte[] rejectmatrix;
    protected mapthing_t[] deathmatchstarts;
    protected int num_deathmatchstarts;
    protected int deathmatch_p;
    protected mapthing_t[] playerstarts = new mapthing_t[4];
    protected static final int BLOCK_SHIFT = 7;
    protected static final int BLOCK_MASK = 127;
    protected static final int BLOCK_MARGIN = 0;
    long total = 0L;
    protected static int[] POKE_REJECT = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    protected boolean[] used_lines;
    public static final boolean FIX_BLOCKMAP_512 = Engine.getConfig().equals(Settings.fix_blockmap, Boolean.TRUE);
    public int blockmapxneg = -257;
    public int blockmapyneg = -257;

    public AbstractLevelLoader(DoomMain<?, ?> DOOM) {
        this.DOOM = DOOM;
    }

    @Override
    public void SetThingPosition(mobj_t thing) {
        subsector_t ss;
        thing.subsector = ss = this.PointInSubsector(thing.x, thing.y);
        if (!C2JUtils.flags(thing.flags, 8L)) {
            sector_t sec = ss.sector;
            thing.sprev = null;
            thing.snext = sec.thinglist;
            if (sec.thinglist != null) {
                sec.thinglist.sprev = thing;
            }
            sec.thinglist = thing;
        }
        if (!C2JUtils.flags(thing.flags, 16L)) {
            int blockx = this.getSafeBlockX(thing.x - this.bmaporgx);
            int blocky = this.getSafeBlockY(thing.y - this.bmaporgy);
            if (blockx >= 0 && blockx < this.bmapwidth && blocky >= 0 && blocky < this.bmapheight) {
                mobj_t link = this.blocklinks[blocky * this.bmapwidth + blockx];
                thing.bprev = null;
                thing.bnext = link;
                if (link != null) {
                    link.bprev = thing;
                }
                this.blocklinks[blocky * this.bmapwidth + blockx] = thing;
            } else {
                thing.bprev = null;
                thing.bnext = null;
            }
        }
    }

    @Override
    public subsector_t PointInSubsector(int x, int y) {
        if (this.numnodes == 0) {
            return this.subsectors[0];
        }
        int nodenum = this.numnodes - 1;
        while (!C2JUtils.flags(nodenum, Integer.MIN_VALUE)) {
            node_t node = this.nodes[nodenum];
            int side = node.PointOnSide(x, y);
            nodenum = node.children[side];
        }
        return this.subsectors[nodenum & Integer.MAX_VALUE];
    }

    private void AddBlockLine(linelist_t[] lists, int[] count, boolean[] done, int blockno, int lineno) {
        long a = System.nanoTime();
        if (done[blockno]) {
            return;
        }
        linelist_t l = new linelist_t();
        l.num = lineno;
        l.next = lists[blockno];
        lists[blockno] = l;
        int n = blockno;
        count[n] = count[n] + 1;
        done[blockno] = true;
        long b = System.nanoTime();
        this.total += b - a;
    }

    protected final void CreateBlockMap() {
        int i;
        int map_minx = Integer.MAX_VALUE;
        int map_miny = Integer.MAX_VALUE;
        int map_maxx = Integer.MIN_VALUE;
        int map_maxy = Integer.MIN_VALUE;
        long a = System.nanoTime();
        for (i = 0; i < this.numvertexes; ++i) {
            int t = this.vertexes[i].x;
            if (t < map_minx) {
                map_minx = t;
            } else if (t > map_maxx) {
                map_maxx = t;
            }
            t = this.vertexes[i].y;
            if (t < map_miny) {
                map_miny = t;
                continue;
            }
            if (t <= map_maxy) continue;
            map_maxy = t;
        }
        int xorg = (map_minx >>= 16) - 0;
        int yorg = (map_miny >>= 16) - 0;
        int ncols = (map_maxx >>= 16) + 0 - xorg + 1 + 127 >> 7;
        int nrows = (map_maxy >>= 16) + 0 - yorg + 1 + 127 >> 7;
        int NBlocks = ncols * nrows;
        linelist_t[] blocklists = new linelist_t[NBlocks];
        int[] blockcount = new int[NBlocks];
        boolean[] blockdone = new boolean[NBlocks];
        i = 0;
        while (i < NBlocks) {
            blocklists[i] = new linelist_t();
            blocklists[i].num = -1;
            blocklists[i].next = null;
            int n = i++;
            blockcount[n] = blockcount[n] + 1;
        }
        for (i = 0; i < this.numlines; ++i) {
            int j;
            int x1 = this.lines[i].v1x >> 16;
            int y1 = this.lines[i].v1y >> 16;
            int x2 = this.lines[i].v2x >> 16;
            int y2 = this.lines[i].v2y >> 16;
            int dx = x2 - x1;
            int dy = y2 - y1;
            boolean vert = dx == 0;
            boolean horiz = dy == 0;
            boolean spos = (dx ^ dy) > 0;
            boolean sneg = (dx ^ dy) < 0;
            int minx = x1 > x2 ? x2 : x1;
            int maxx = x1 > x2 ? x1 : x2;
            int miny = y1 > y2 ? y2 : y1;
            int maxy = y1 > y2 ? y1 : y2;
            C2JUtils.memset(blockdone, false, NBlocks);
            int bx = x1 - xorg >> 7;
            int by = y1 - yorg >> 7;
            this.AddBlockLine(blocklists, blockcount, blockdone, by * ncols + bx, i);
            bx = x2 - xorg >> 7;
            by = y2 - yorg >> 7;
            this.AddBlockLine(blocklists, blockcount, blockdone, by * ncols + bx, i);
            if (!vert) {
                for (j = 0; j < ncols; ++j) {
                    int x = xorg + (j << 7);
                    int y = dy * (x - x1) / dx + y1;
                    int yb = y - yorg >> 7;
                    int yp = y - yorg & 0x7F;
                    if (yb < 0 || yb > nrows - 1 || x < minx || x > maxx) continue;
                    this.AddBlockLine(blocklists, blockcount, blockdone, ncols * yb + j, i);
                    if (yp == 0) {
                        if (sneg) {
                            if (yb > 0 && miny < y) {
                                this.AddBlockLine(blocklists, blockcount, blockdone, ncols * (yb - 1) + j, i);
                            }
                            if (j <= 0 || minx >= x) continue;
                            this.AddBlockLine(blocklists, blockcount, blockdone, ncols * yb + j - 1, i);
                            continue;
                        }
                        if (spos) {
                            if (yb <= 0 || j <= 0 || minx >= x) continue;
                            this.AddBlockLine(blocklists, blockcount, blockdone, ncols * (yb - 1) + j - 1, i);
                            continue;
                        }
                        if (!horiz || j <= 0 || minx >= x) continue;
                        this.AddBlockLine(blocklists, blockcount, blockdone, ncols * yb + j - 1, i);
                        continue;
                    }
                    if (j <= 0 || minx >= x) continue;
                    this.AddBlockLine(blocklists, blockcount, blockdone, ncols * yb + j - 1, i);
                }
            }
            if (horiz) continue;
            for (j = 0; j < nrows; ++j) {
                int y = yorg + (j << 7);
                int x = dx * (y - y1) / dy + x1;
                int xb = x - xorg >> 7;
                int xp = x - xorg & 0x7F;
                if (xb < 0 || xb > ncols - 1 || y < miny || y > maxy) continue;
                this.AddBlockLine(blocklists, blockcount, blockdone, ncols * j + xb, i);
                if (xp == 0) {
                    if (sneg) {
                        if (j > 0 && miny < y) {
                            this.AddBlockLine(blocklists, blockcount, blockdone, ncols * (j - 1) + xb, i);
                        }
                        if (xb <= 0 || minx >= x) continue;
                        this.AddBlockLine(blocklists, blockcount, blockdone, ncols * j + xb - 1, i);
                        continue;
                    }
                    if (vert) {
                        if (j <= 0 || miny >= y) continue;
                        this.AddBlockLine(blocklists, blockcount, blockdone, ncols * (j - 1) + xb, i);
                        continue;
                    }
                    if (!spos || xb <= 0 || j <= 0 || miny >= y) continue;
                    this.AddBlockLine(blocklists, blockcount, blockdone, ncols * (j - 1) + xb - 1, i);
                    continue;
                }
                if (j <= 0 || miny >= y) continue;
                this.AddBlockLine(blocklists, blockcount, blockdone, ncols * (j - 1) + xb, i);
            }
        }
        C2JUtils.memset(blockdone, false, NBlocks);
        int linetotal = 0;
        for (i = 0; i < NBlocks; ++i) {
            this.AddBlockLine(blocklists, blockcount, blockdone, i, 0);
            linetotal += blockcount[i];
        }
        this.blockmaplump = new int[4 + NBlocks + linetotal];
        this.blockmaplump[0] = this.bmaporgx = xorg << 16;
        this.blockmaplump[1] = this.bmaporgy = yorg << 16;
        this.blockmaplump[2] = this.bmapwidth = ncols;
        this.blockmaplump[3] = this.bmapheight = nrows;
        for (i = 0; i < NBlocks; ++i) {
            linelist_t bl = blocklists[i];
            int n = (i != 0 ? this.blockmaplump[4 + i - 1] : 4 + NBlocks) + (i != 0 ? blockcount[i - 1] : 0);
            this.blockmaplump[4 + i] = n;
            int offs = n;
            while (bl != null) {
                linelist_t tmp = bl.next;
                this.blockmaplump[offs++] = bl.num;
                bl = tmp;
            }
        }
        long b = System.nanoTime();
        System.err.printf("Blockmap generated in %f sec\n", (double)(b - a) / 1.0E9);
        System.err.printf("Time spend in AddBlockLine : %f sec\n", (double)this.total / 1.0E9);
    }

    protected boolean VerifyBlockMap(int count) {
        int p_maxoffs = count;
        for (int y = 0; y < this.bmapheight; ++y) {
            for (int x = 0; x < this.bmapwidth; ++x) {
                int p_list;
                int offset = y * this.bmapwidth + x;
                int blockoffset = offset + 4;
                if (blockoffset >= p_maxoffs) {
                    System.err.printf("P_VerifyBlockMap: block offset overflow\n", new Object[0]);
                    return false;
                }
                offset = this.blockmaplump[blockoffset];
                if (offset < 4 || offset >= count) {
                    System.err.printf("P_VerifyBlockMap: list offset overflow\n", new Object[0]);
                    return false;
                }
                int tmplist = p_list = offset;
                while (true) {
                    if (tmplist >= p_maxoffs) {
                        System.err.printf("P_VerifyBlockMap: open blocklist\n", new Object[0]);
                        return false;
                    }
                    if (this.blockmaplump[tmplist] == -1) break;
                    ++tmplist;
                }
                tmplist = p_list;
                while (this.blockmaplump[tmplist] != -1) {
                    if (this.blockmaplump[tmplist] < 0 || this.blockmaplump[tmplist] >= this.numlines) {
                        System.err.printf("P_VerifyBlockMap: index >= numlines\n", new Object[0]);
                        return false;
                    }
                    ++tmplist;
                }
            }
        }
        return true;
    }

    protected void AddLineToSector(line_t li, sector_t sector) {
        int[] bbox = sector.blockbox;
        sector.lines[sector.linecount++] = li;
        BBox.AddToBox(bbox, li.v1.x, li.v1.y);
        BBox.AddToBox(bbox, li.v2.x, li.v2.y);
    }

    protected float rejectDensity() {
        int tcount = 0;
        for (int i = 0; i < this.numsectors; ++i) {
            for (int j = 0; j < this.numsectors; ++j) {
                int pnum = i * this.numsectors + j;
                int bytenum = pnum >> 3;
                int bitnum = 1 << (pnum & 7);
                if (C2JUtils.flags(this.rejectmatrix[bytenum], bitnum)) continue;
                ++tcount;
            }
        }
        float tabledensity = (float)tcount / (float)(this.numsectors * this.numsectors);
        return tabledensity;
    }

    protected void pokeIntoReject(int x, int y) {
        int pnum = y * this.numsectors + x;
        int bytenum = pnum >> 3;
        int bitnum = pnum & 7;
        int n = bytenum;
        this.rejectmatrix[n] = (byte)(this.rejectmatrix[n] | POKE_REJECT[bitnum]);
        System.out.println(this.rejectDensity());
    }

    protected void retrieveFromReject(int x, int y, boolean value) {
        int pnum = y * this.numsectors + x;
        int bytenum = pnum >> 3;
        int bitnum = pnum & 7;
        int n = bytenum;
        this.rejectmatrix[n] = (byte)(this.rejectmatrix[n] | POKE_REJECT[bitnum]);
        System.out.println(this.rejectDensity());
    }

    protected final int[] getMapBoundingBox(boolean playable) {
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        for (int i = 0; i < this.lines.length; ++i) {
            if (!playable && !this.used_lines[i]) continue;
            if (this.lines[i].v1x > maxx) {
                maxx = this.lines[i].v1x;
            }
            if (this.lines[i].v1x < minx) {
                minx = this.lines[i].v1x;
            }
            if (this.lines[i].v1y > maxy) {
                maxy = this.lines[i].v1y;
            }
            if (this.lines[i].v1y < miny) {
                miny = this.lines[i].v1y;
            }
            if (this.lines[i].v2x > maxx) {
                maxx = this.lines[i].v2x;
            }
            if (this.lines[i].v2x < minx) {
                minx = this.lines[i].v2x;
            }
            if (this.lines[i].v2y > maxy) {
                maxy = this.lines[i].v2y;
            }
            if (this.lines[i].v2y >= miny) continue;
            miny = this.lines[i].v2y;
        }
        System.err.printf("Map bounding %d %d %d %d\n", minx >> 16, miny >> 16, maxx >> 16, maxy >> 16);
        int orgx = -524288 + 128 * (minx / 128);
        int orgy = -524288 + 128 * (miny / 128);
        int bckx = 524288 + maxx - orgx;
        int bcky = 524288 + maxy - orgy;
        System.err.printf("%d %d %d %d\n", orgx >> 16, orgy >> 16, 1 + (bckx >> 23), 1 + (bcky >> 23));
        return new int[]{orgx, orgy, bckx, bcky};
    }

    protected void LoadReject(int lumpnum) {
        byte[] tmpreject = new byte[]{};
        try {
            tmpreject = this.DOOM.wadLoader.CacheLumpNumAsRawBytes(lumpnum, 50);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rejectmatrix = new byte[(int)Math.ceil((double)(this.numsectors * this.numsectors) / 8.0)];
        System.arraycopy(tmpreject, 0, this.rejectmatrix, 0, Math.min(tmpreject.length, this.rejectmatrix.length));
        if (tmpreject.length < this.rejectmatrix.length) {
            System.err.printf("BROKEN REJECT MAP! Length %d expected %d\n", tmpreject.length, this.rejectmatrix.length);
        }
    }

    public final int getSafeBlockX(int blockx) {
        return FIX_BLOCKMAP_512 && blockx <= this.blockmapxneg ? blockx & 0x1FF : (blockx >>= 23);
    }

    public final int getSafeBlockX(long blockx) {
        return (int)(FIX_BLOCKMAP_512 && blockx <= (long)this.blockmapxneg ? blockx & 0x1FFL : (blockx >>= 23));
    }

    public final int getSafeBlockY(int blocky) {
        return FIX_BLOCKMAP_512 && blocky <= this.blockmapyneg ? blocky & 0x1FF : (blocky >>= 23);
    }

    public final int getSafeBlockY(long blocky) {
        return (int)(FIX_BLOCKMAP_512 && blocky <= (long)this.blockmapyneg ? blocky & 0x1FFL : (blocky >>= 23));
    }

    public void InitTagLists() {
        int j;
        int i = this.numsectors;
        while (--i >= 0) {
            this.sectors[i].firsttag = -1;
        }
        i = this.numsectors;
        while (--i >= 0) {
            j = this.sectors[i].tag % this.numsectors;
            this.sectors[i].nexttag = this.sectors[j].firsttag;
            this.sectors[j].firsttag = i;
        }
        i = this.numlines;
        while (--i >= 0) {
            this.lines[i].firsttag = -1;
        }
        i = this.numlines;
        while (--i >= 0) {
            j = this.lines[i].tag % this.numlines;
            this.lines[i].nexttag = this.lines[j].firsttag;
            this.lines[j].firsttag = i;
        }
    }

    protected class linelist_t {
        public int num;
        public linelist_t next;

        protected linelist_t() {
        }
    }
}

