/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import automap.IAutoMap;
import data.sounds;
import defines.skill_t;
import doom.DoomMain;
import doom.player_t;
import hu.IHeadsUp;
import i.IDoomSystem;
import java.util.function.Predicate;
import p.AbstractLevelLoader;
import p.Actions.ActionsAttacks;
import p.Actions.ActionsEnemies;
import p.Actions.ActionsThinkers;
import p.ThinkerList;
import p.UnifiedGameMap;
import p.intercept_t;
import p.mobj_t;
import rr.SceneRenderer;
import rr.line_t;
import rr.sector_t;
import rr.subsector_t;
import s.ISoundOrigin;
import st.IDoomStatusBar;
import utils.C2JUtils;
import utils.TraitFactory;

public interface ActionTrait
extends TraitFactory.Trait,
ThinkerList {
    public static final TraitFactory.KeyChain ACTION_KEY_CHAIN = new TraitFactory.KeyChain();
    public static final TraitFactory.ContextKey<SlideMove> KEY_SLIDEMOVE = ACTION_KEY_CHAIN.newKey(ActionTrait.class, SlideMove::new);
    public static final TraitFactory.ContextKey<Spechits> KEY_SPECHITS = ACTION_KEY_CHAIN.newKey(ActionTrait.class, Spechits::new);
    public static final TraitFactory.ContextKey<Movement> KEY_MOVEMENT = ACTION_KEY_CHAIN.newKey(ActionTrait.class, Movement::new);

    public AbstractLevelLoader levelLoader();

    public IHeadsUp headsUp();

    public IDoomSystem doomSystem();

    public IDoomStatusBar statusBar();

    public IAutoMap<?, ?> autoMap();

    public SceneRenderer<?, ?> sceneRenderer();

    public UnifiedGameMap.Specials getSpecials();

    public UnifiedGameMap.Switches getSwitches();

    public ActionsThinkers getThinkers();

    public ActionsEnemies getEnemies();

    public ActionsAttacks getAttacks();

    public void StopSound(ISoundOrigin var1);

    public void StartSound(ISoundOrigin var1, sounds.sfxenum_t var2);

    public void StartSound(ISoundOrigin var1, int var2);

    public player_t getPlayer(int var1);

    public skill_t getGameSkill();

    public mobj_t createMobj();

    public int LevelTime();

    public int P_Random();

    public int ConsolePlayerNumber();

    public int MapNumber();

    public boolean PlayerInGame(int var1);

    public boolean IsFastParm();

    public boolean IsPaused();

    public boolean IsNetGame();

    public boolean IsDemoPlayback();

    public boolean IsDeathMatch();

    public boolean IsAutoMapActive();

    public boolean IsMenuActive();

    public boolean CheckThing(mobj_t var1);

    public boolean StompThing(mobj_t var1);

    default public void SetThingPosition(mobj_t mobj) {
        this.levelLoader().SetThingPosition(mobj);
    }

    public DoomMain<?, ?> DOOM();

    default public void LineOpening(line_t linedef) {
        Movement ma = this.contextRequire(KEY_MOVEMENT);
        if (linedef.sidenum[1] == '\uffff') {
            ma.openrange = 0;
            return;
        }
        sector_t front = linedef.frontsector;
        sector_t back = linedef.backsector;
        ma.opentop = front.ceilingheight < back.ceilingheight ? front.ceilingheight : back.ceilingheight;
        if (front.floorheight > back.floorheight) {
            ma.openbottom = front.floorheight;
            ma.lowfloor = back.floorheight;
        } else {
            ma.openbottom = back.floorheight;
            ma.lowfloor = front.floorheight;
        }
        ma.openrange = ma.opentop - ma.openbottom;
    }

    default public boolean BlockThingsIterator(int x, int y, Predicate<mobj_t> func) {
        AbstractLevelLoader ll = this.levelLoader();
        if (x < 0 || y < 0 || x >= ll.bmapwidth || y >= ll.bmapheight) {
            return true;
        }
        mobj_t mobj = ll.blocklinks[y * ll.bmapwidth + x];
        while (mobj != null) {
            if (!func.test(mobj)) {
                return false;
            }
            mobj = (mobj_t)mobj.bnext;
        }
        return true;
    }

    default public boolean BlockLinesIterator(int x, int y, Predicate<line_t> func) {
        int lineinblock;
        AbstractLevelLoader ll = this.levelLoader();
        SceneRenderer<?, ?> sr = this.sceneRenderer();
        if (x < 0 || y < 0 || x >= ll.bmapwidth || y >= ll.bmapheight) {
            return true;
        }
        int offset = y * ll.bmapwidth + x;
        offset = ll.blockmap[offset];
        int validcount = sr.getValidCount();
        int list = offset;
        while ((lineinblock = ll.blockmap[list]) != -1) {
            line_t ld = ll.lines[lineinblock];
            if (ld.validcount != validcount) {
                ld.validcount = validcount;
                if (!func.test(ld)) {
                    return false;
                }
            }
            ++list;
        }
        return true;
    }

    default public void ResizeSpechits() {
        Spechits spechits = this.contextRequire(KEY_SPECHITS);
        spechits.spechit = C2JUtils.resize(spechits.spechit[0], spechits.spechit, spechits.spechit.length * 2);
    }

    default public boolean CheckLine(line_t ld) {
        Spechits spechits = this.contextRequire(KEY_SPECHITS);
        Movement ma = this.contextRequire(KEY_MOVEMENT);
        if (ma.tmbbox[3] <= ld.bbox[2] || ma.tmbbox[2] >= ld.bbox[3] || ma.tmbbox[0] <= ld.bbox[1] || ma.tmbbox[1] >= ld.bbox[0]) {
            return true;
        }
        if (ld.BoxOnLineSide(ma.tmbbox) != -1) {
            return true;
        }
        if (ld.backsector == null) {
            return false;
        }
        if (!C2JUtils.eval(ma.tmthing.flags & 0x10000L)) {
            if (C2JUtils.eval(ld.flags & 1)) {
                return false;
            }
            if (ma.tmthing.player == null && C2JUtils.eval(ld.flags & 2)) {
                return false;
            }
        }
        this.LineOpening(ld);
        if (ma.opentop < ma.tmceilingz) {
            ma.tmceilingz = ma.opentop;
            ma.ceilingline = ld;
        }
        if (ma.openbottom > ma.tmfloorz) {
            ma.tmfloorz = ma.openbottom;
        }
        if (ma.lowfloor < ma.tmdropoffz) {
            ma.tmdropoffz = ma.lowfloor;
        }
        if (ld.special != 0) {
            spechits.spechit[spechits.numspechit] = ld;
            ++spechits.numspechit;
            if (spechits.numspechit >= spechits.spechit.length) {
                this.ResizeSpechits();
            }
        }
        return true;
    }

    default public boolean CheckPosition(mobj_t thing, int x, int y) {
        int by;
        int bx;
        AbstractLevelLoader ll = this.levelLoader();
        Spechits spechits = this.contextRequire(KEY_SPECHITS);
        Movement ma = this.contextRequire(KEY_MOVEMENT);
        ma.tmthing = thing;
        ma.tmflags = thing.flags;
        ma.tmx = x;
        ma.tmy = y;
        ma.tmbbox[0] = y + ma.tmthing.radius;
        ma.tmbbox[1] = y - ma.tmthing.radius;
        ma.tmbbox[3] = x + ma.tmthing.radius;
        ma.tmbbox[2] = x - ma.tmthing.radius;
        subsector_t newsubsec = this.levelLoader().PointInSubsector(x, y);
        ma.ceilingline = null;
        ma.tmfloorz = ma.tmdropoffz = newsubsec.sector.floorheight;
        ma.tmceilingz = newsubsec.sector.ceilingheight;
        this.sceneRenderer().increaseValidCount(1);
        spechits.numspechit = 0;
        if (C2JUtils.eval(ma.tmflags & 0x1000L)) {
            return true;
        }
        int xl = ll.getSafeBlockX(ma.tmbbox[2] - ll.bmaporgx - 0x200000);
        int xh = ll.getSafeBlockX(ma.tmbbox[3] - ll.bmaporgx + 0x200000);
        int yl = ll.getSafeBlockY(ma.tmbbox[1] - ll.bmaporgy - 0x200000);
        int yh = ll.getSafeBlockY(ma.tmbbox[0] - ll.bmaporgy + 0x200000);
        for (bx = xl; bx <= xh; ++bx) {
            for (by = yl; by <= yh; ++by) {
                if (this.BlockThingsIterator(bx, by, this::CheckThing)) continue;
                return false;
            }
        }
        xl = ll.getSafeBlockX(ma.tmbbox[2] - ll.bmaporgx);
        xh = ll.getSafeBlockX(ma.tmbbox[3] - ll.bmaporgx);
        yl = ll.getSafeBlockY(ma.tmbbox[1] - ll.bmaporgy);
        yh = ll.getSafeBlockY(ma.tmbbox[0] - ll.bmaporgy);
        if (AbstractLevelLoader.FIX_BLOCKMAP_512) {
            if (xl <= ll.blockmapxneg) {
                xl = 0x1FF & xl;
            }
            if (xh <= ll.blockmapxneg) {
                xh = 0x1FF & xh;
            }
            if (yl <= ll.blockmapyneg) {
                yl = 0x1FF & yl;
            }
            if (yh <= ll.blockmapyneg) {
                yh = 0x1FF & yh;
            }
        }
        for (bx = xl; bx <= xh; ++bx) {
            for (by = yl; by <= yh; ++by) {
                if (this.BlockLinesIterator(bx, by, this::CheckLine)) continue;
                return false;
            }
        }
        return true;
    }

    default public boolean ThingHeightClip(mobj_t thing) {
        Movement ma = this.contextRequire(KEY_MOVEMENT);
        boolean onfloor = thing.z == thing.floorz;
        this.CheckPosition(thing, thing.x, thing.y);
        thing.floorz = ma.tmfloorz;
        thing.ceilingz = ma.tmceilingz;
        if (onfloor) {
            thing.z = thing.floorz;
        } else if (thing.z + thing.height > thing.ceilingz) {
            thing.z = thing.ceilingz - thing.height;
        }
        return thing.ceilingz - thing.floorz >= thing.height;
    }

    default public boolean isblocking(intercept_t in, line_t li) {
        SlideMove slideMove = this.contextRequire(KEY_SLIDEMOVE);
        if (in.frac < slideMove.bestslidefrac) {
            slideMove.secondslidefrac = slideMove.bestslidefrac;
            slideMove.secondslideline = slideMove.bestslideline;
            slideMove.bestslidefrac = in.frac;
            slideMove.bestslideline = li;
        }
        return false;
    }

    public static final class Movement {
        public boolean floatok;
        public int tmfloorz;
        public int tmceilingz;
        public int tmdropoffz;
        public line_t ceilingline;
        int[] tmbbox = new int[4];
        mobj_t tmthing;
        long tmflags;
        int tmx;
        int tmy;
        int opentop;
        int openbottom;
        int openrange;
        int lowfloor;
    }

    public static final class Spechits {
        line_t[] spechit = new line_t[8];
        int numspechit;
        mobj_t usething;
    }

    public static final class SlideMove {
        mobj_t slidemo;
        int bestslidefrac;
        int secondslidefrac;
        line_t bestslideline;
        line_t secondslideline;
        int tmxmove;
        int tmymove;
    }
}

