/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Defines;
import data.Tables;
import data.info;
import data.mobjtype_t;
import defines.statenum_t;
import m.fixed_t;
import p.AbstractLevelLoader;
import p.Actions.ActionTrait;
import p.Actions.ActionsAim;
import p.Actions.ActionsMobj;
import p.Actions.ActionsSectors;
import p.Actions.ActionsShootEvents;
import p.Actions.ActionsSight;
import p.intercept_t;
import p.mobj_t;
import rr.line_t;
import utils.C2JUtils;
import utils.TraitFactory;

public interface ActionsAttacks
extends ActionsAim,
ActionsMobj,
ActionsSight,
ActionsShootEvents {
    public static final TraitFactory.ContextKey<Attacks> KEY_ATTACKS = ACTION_KEY_CHAIN.newKey(ActionsAttacks.class, Attacks::new);

    default public void P_GunShot(mobj_t mo, boolean accurate) {
        ActionsSectors.Spawn targ = (ActionsSectors.Spawn)this.contextRequire(KEY_SPAWN);
        int damage = 5 * (this.P_Random() % 3 + 1);
        long angle = mo.angle;
        if (!accurate) {
            angle += (long)(this.P_Random() - this.P_Random() << 18);
        }
        this.LineAttack(mo, angle, Defines.MISSILERANGE, targ.bulletslope, damage);
    }

    default public void LineAttack(mobj_t t1, long angle, int distance, int slope, int damage) {
        ActionsSectors.Spawn targ = (ActionsSectors.Spawn)this.contextRequire(KEY_SPAWN);
        targ.shootthing = t1;
        targ.la_damage = damage;
        int x2 = t1.x + (distance >> 16) * Tables.finecosine(angle);
        int y2 = t1.y + (distance >> 16) * Tables.finesine(angle);
        targ.shootz = t1.z + (t1.height >> 1) + 524288;
        targ.attackrange = distance;
        targ.aimslope = slope;
        this.PathTraverse(t1.x, t1.y, x2, y2, Defines.PT_ADDLINES | Defines.PT_ADDTHINGS, this::ShootTraverse);
    }

    default public void RadiusAttack(mobj_t spot, mobj_t source, int damage) {
        AbstractLevelLoader ll = this.levelLoader();
        Attacks att = this.contextRequire(KEY_ATTACKS);
        int dist = damage + 0x200000 << 16;
        int yh = ll.getSafeBlockY(spot.y + dist - ll.bmaporgy);
        int yl = ll.getSafeBlockY(spot.y - dist - ll.bmaporgy);
        int xh = ll.getSafeBlockX(spot.x + dist - ll.bmaporgx);
        int xl = ll.getSafeBlockX(spot.x - dist - ll.bmaporgx);
        att.bombspot = spot;
        att.bombsource = source;
        att.bombdamage = damage;
        for (int y = yl; y <= yh; ++y) {
            for (int x = xl; x <= xh; ++x) {
                this.BlockThingsIterator(x, y, this::RadiusAttack);
            }
        }
    }

    default public boolean VileCheck(mobj_t thing) {
        Attacks att = this.contextRequire(KEY_ATTACKS);
        if (!C2JUtils.eval(thing.flags & 0x100000L)) {
            return true;
        }
        if (thing.mobj_tics != -1L) {
            return true;
        }
        if (thing.info.raisestate == statenum_t.S_NULL) {
            return true;
        }
        int maxdist = thing.info.radius + info.mobjinfo[mobjtype_t.MT_VILE.ordinal()].radius;
        if (Math.abs(thing.x - att.vileTryX) > maxdist || Math.abs(thing.y - att.vileTryY) > maxdist) {
            return true;
        }
        att.vileCorpseHit = thing;
        att.vileCorpseHit.momy = 0;
        att.vileCorpseHit.momx = 0;
        att.vileCorpseHit.height <<= 2;
        boolean check = this.CheckPosition(att.vileCorpseHit, att.vileCorpseHit.x, att.vileCorpseHit.y);
        att.vileCorpseHit.height >>= 2;
        return !check;
    }

    default public boolean RadiusAttack(mobj_t thing) {
        int dy;
        Attacks att = this.contextRequire(KEY_ATTACKS);
        if (!C2JUtils.eval(thing.flags & 4L)) {
            return true;
        }
        if (thing.type == mobjtype_t.MT_CYBORG || thing.type == mobjtype_t.MT_SPIDER) {
            return true;
        }
        int dx = Math.abs(thing.x - att.bombspot.x);
        int dist = dx > (dy = Math.abs(thing.y - att.bombspot.y)) ? dx : dy;
        if ((dist = dist - thing.radius >> 16) < 0) {
            dist = 0;
        }
        if (dist >= att.bombdamage) {
            return true;
        }
        if (this.CheckSight(thing, att.bombspot)) {
            this.DamageMobj(thing, att.bombspot, att.bombsource, att.bombdamage - dist);
        }
        return true;
    }

    default public boolean ShootTraverse(intercept_t in) {
        ActionsSectors.Spawn targ = (ActionsSectors.Spawn)this.contextRequire(KEY_SPAWN);
        ActionTrait.Movement mov = (ActionTrait.Movement)this.contextRequire(KEY_MOVEMENT);
        if (in.isaline) {
            int slope;
            line_t li = (line_t)in.d();
            if (li.special != 0) {
                this.ShootSpecialLine(targ.shootthing, li);
            }
            if (!C2JUtils.eval(li.flags & 4)) {
                return this.gotoHitLine(in, li);
            }
            this.LineOpening(li);
            int dist = fixed_t.FixedMul(targ.attackrange, in.frac);
            if (li.frontsector.floorheight != li.backsector.floorheight && (slope = fixed_t.FixedDiv(mov.openbottom - targ.shootz, dist)) > targ.aimslope) {
                return this.gotoHitLine(in, li);
            }
            if (li.frontsector.ceilingheight != li.backsector.ceilingheight && (slope = fixed_t.FixedDiv(mov.opentop - targ.shootz, dist)) < targ.aimslope) {
                return this.gotoHitLine(in, li);
            }
            return true;
        }
        mobj_t th = (mobj_t)in.d();
        if (th == targ.shootthing) {
            return true;
        }
        if (!C2JUtils.eval(th.flags & 4L)) {
            return true;
        }
        int dist = fixed_t.FixedMul(targ.attackrange, in.frac);
        int thingtopslope = fixed_t.FixedDiv(th.z + th.height - targ.shootz, dist);
        if (thingtopslope < targ.aimslope) {
            return true;
        }
        int thingbottomslope = fixed_t.FixedDiv(th.z - targ.shootz, dist);
        if (thingbottomslope > targ.aimslope) {
            return true;
        }
        int frac = in.frac - fixed_t.FixedDiv(655360, targ.attackrange);
        int x = targ.trace.x + fixed_t.FixedMul(targ.trace.dx, frac);
        int y = targ.trace.y + fixed_t.FixedMul(targ.trace.dy, frac);
        int z = targ.shootz + fixed_t.FixedMul(targ.aimslope, fixed_t.FixedMul(frac, targ.attackrange));
        if (C2JUtils.eval(((mobj_t)in.d()).flags & 0x80000L)) {
            this.SpawnPuff(x, y, z);
        } else {
            this.SpawnBlood(x, y, z, targ.la_damage);
        }
        if (targ.la_damage != 0) {
            this.DamageMobj(th, targ.shootthing, targ.shootthing, targ.la_damage);
        }
        return false;
    }

    public static final class Attacks {
        public mobj_t bombsource;
        public mobj_t bombspot;
        public int bombdamage;
        public mobj_t vileCorpseHit;
        public mobj_t vileObj;
        public int vileTryX;
        public int vileTryY;
    }
}

