/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.sounds;
import defines.card_t;
import doom.player_t;
import doom.thinker_t;
import p.Actions.ActionsMoveEvents;
import p.Actions.ActionsUseEvents;
import p.ActiveStates;
import p.mobj_t;
import p.plat_t;
import p.result_e;
import p.vldoor_e;
import p.vldoor_t;
import rr.line_t;
import rr.sector_t;
import s.ISoundOrigin;
import utils.C2JUtils;

public interface ActionsDoors
extends ActionsMoveEvents,
ActionsUseEvents {
    public result_e MovePlane(sector_t var1, int var2, int var3, boolean var4, int var5, int var6);

    @Override
    public void RemoveThinker(thinker_t var1);

    public int FindSectorFromLineTag(line_t var1, int var2);

    default public void VerticalDoor(vldoor_t door) {
        block0 : switch (door.direction) {
            case 0: {
                if (C2JUtils.eval(--door.topcountdown)) break;
                switch (door.type) {
                    case blazeRaise: {
                        door.direction = -1;
                        this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_bdcls);
                        break block0;
                    }
                    case normal: {
                        door.direction = -1;
                        this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_dorcls);
                        break block0;
                    }
                    case close30ThenOpen: {
                        door.direction = 1;
                        this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_doropn);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (C2JUtils.eval(--door.topcountdown)) break;
                switch (door.type) {
                    case raiseIn5Mins: {
                        door.direction = 1;
                        door.type = vldoor_e.normal;
                        this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_doropn);
                        break block0;
                    }
                }
                break;
            }
            case -1: {
                result_e res = this.MovePlane(door.sector, door.speed, door.sector.floorheight, false, 1, door.direction);
                if (res == result_e.pastdest) {
                    switch (door.type) {
                        case blazeRaise: 
                        case blazeClose: {
                            door.sector.specialdata = null;
                            this.RemoveThinker(door);
                            this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_bdcls);
                            break block0;
                        }
                        case normal: 
                        case close: {
                            door.sector.specialdata = null;
                            this.RemoveThinker(door);
                            break block0;
                        }
                        case close30ThenOpen: {
                            door.direction = 0;
                            door.topcountdown = 1050;
                            break block0;
                        }
                    }
                    break;
                }
                if (res != result_e.crushed) break;
                switch (door.type) {
                    case blazeClose: 
                    case close: {
                        break block0;
                    }
                }
                door.direction = 1;
                this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_doropn);
                break;
            }
            case 1: {
                result_e res = this.MovePlane(door.sector, door.speed, door.topheight, false, 1, door.direction);
                if (res != result_e.pastdest) break;
                switch (door.type) {
                    case blazeRaise: 
                    case normal: {
                        door.direction = 0;
                        door.topcountdown = door.topwait;
                        break block0;
                    }
                    case close30ThenOpen: 
                    case blazeOpen: 
                    case open: {
                        door.sector.specialdata = null;
                        this.RemoveThinker(door);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    @Override
    default public boolean DoLockedDoor(line_t line, vldoor_e type, mobj_t thing) {
        player_t p = thing.player;
        if (p == null) {
            return false;
        }
        switch (line.special) {
            case 99: 
            case 133: {
                if (p.cards[card_t.it_bluecard.ordinal()] || p.cards[card_t.it_blueskull.ordinal()]) break;
                p.message = "You need a blue key to activate this object";
                this.StartSound(null, sounds.sfxenum_t.sfx_oof);
                return false;
            }
            case 134: 
            case 135: {
                if (p.cards[card_t.it_redcard.ordinal()] || p.cards[card_t.it_redskull.ordinal()]) break;
                p.message = "You need a red key to activate this object";
                this.StartSound(null, sounds.sfxenum_t.sfx_oof);
                return false;
            }
            case 136: 
            case 137: {
                if (p.cards[card_t.it_yellowcard.ordinal()] || p.cards[card_t.it_yellowskull.ordinal()]) break;
                p.message = "You need a yellow key to activate this object";
                this.StartSound(null, sounds.sfxenum_t.sfx_oof);
                return false;
            }
        }
        return this.DoDoor(line, type);
    }

    @Override
    default public boolean DoDoor(line_t line, vldoor_e type) {
        boolean rtn = false;
        int secnum = -1;
        while ((secnum = this.FindSectorFromLineTag(line, secnum)) >= 0) {
            sector_t sec = this.levelLoader().sectors[secnum];
            if (sec.specialdata != null) continue;
            rtn = true;
            vldoor_t door = new vldoor_t();
            sec.specialdata = door;
            door.thinkerFunction = ActiveStates.T_VerticalDoor;
            this.AddThinker(door);
            door.sector = sec;
            door.type = type;
            door.topwait = 150;
            door.speed = 131072;
            switch (type) {
                case blazeClose: {
                    door.topheight = sec.FindLowestCeilingSurrounding();
                    door.topheight -= 262144;
                    door.direction = -1;
                    door.speed = 524288;
                    this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_bdcls);
                    break;
                }
                case close: {
                    door.topheight = sec.FindLowestCeilingSurrounding();
                    door.topheight -= 262144;
                    door.direction = -1;
                    this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_dorcls);
                    break;
                }
                case close30ThenOpen: {
                    door.topheight = sec.ceilingheight;
                    door.direction = -1;
                    this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_dorcls);
                    break;
                }
                case blazeRaise: 
                case blazeOpen: {
                    door.direction = 1;
                    door.topheight = sec.FindLowestCeilingSurrounding();
                    door.topheight -= 262144;
                    door.speed = 524288;
                    if (door.topheight == sec.ceilingheight) break;
                    this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_bdopn);
                    break;
                }
                case normal: 
                case open: {
                    door.direction = 1;
                    door.topheight = sec.FindLowestCeilingSurrounding();
                    door.topheight -= 262144;
                    if (door.topheight == sec.ceilingheight) break;
                    this.StartSound((ISoundOrigin)door.sector.soundorg, sounds.sfxenum_t.sfx_doropn);
                }
            }
        }
        return rtn;
    }

    @Override
    default public void VerticalDoor(line_t line, mobj_t thing) {
        vldoor_t door;
        int side = 0;
        player_t player = thing.player;
        switch (line.special) {
            case 26: 
            case 32: {
                if (player == null) {
                    return;
                }
                if (player.cards[card_t.it_bluecard.ordinal()] || player.cards[card_t.it_blueskull.ordinal()]) break;
                player.message = "You need a blue key to open this door";
                this.StartSound(null, sounds.sfxenum_t.sfx_oof);
                return;
            }
            case 27: 
            case 34: {
                if (player == null) {
                    return;
                }
                if (player.cards[card_t.it_yellowcard.ordinal()] || player.cards[card_t.it_yellowskull.ordinal()]) break;
                player.message = "You need a yellow key to open this door";
                this.StartSound(null, sounds.sfxenum_t.sfx_oof);
                return;
            }
            case 28: 
            case 33: {
                if (player == null) {
                    return;
                }
                if (player.cards[card_t.it_redcard.ordinal()] || player.cards[card_t.it_redskull.ordinal()]) break;
                player.message = "You need a red key to open this door";
                this.StartSound(null, sounds.sfxenum_t.sfx_oof);
                return;
            }
        }
        sector_t sec = this.levelLoader().sides[line.sidenum[side ^ 1]].sector;
        if (sec.specialdata != null) {
            door = sec.specialdata instanceof plat_t ? ((plat_t)sec.specialdata).asVlDoor(this.levelLoader().sectors) : (vldoor_t)sec.specialdata;
            switch (line.special) {
                case 1: 
                case 26: 
                case 27: 
                case 28: 
                case 117: {
                    if (door.direction == -1) {
                        door.direction = 1;
                    } else {
                        if (thing.player == null) {
                            return;
                        }
                        door.direction = -1;
                    }
                    return;
                }
            }
        }
        switch (line.special) {
            case 117: 
            case 118: {
                this.StartSound((ISoundOrigin)sec.soundorg, sounds.sfxenum_t.sfx_bdopn);
                break;
            }
            case 1: 
            case 31: {
                this.StartSound((ISoundOrigin)sec.soundorg, sounds.sfxenum_t.sfx_doropn);
                break;
            }
            default: {
                this.StartSound((ISoundOrigin)sec.soundorg, sounds.sfxenum_t.sfx_doropn);
            }
        }
        door = new vldoor_t();
        sec.specialdata = door;
        door.thinkerFunction = ActiveStates.T_VerticalDoor;
        this.AddThinker(door);
        door.sector = sec;
        door.direction = 1;
        door.speed = 131072;
        door.topwait = 150;
        switch (line.special) {
            case 1: 
            case 26: 
            case 27: 
            case 28: {
                door.type = vldoor_e.normal;
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                door.type = vldoor_e.open;
                line.special = 0;
                break;
            }
            case 117: {
                door.type = vldoor_e.blazeRaise;
                door.speed = 524288;
                break;
            }
            case 118: {
                door.type = vldoor_e.blazeOpen;
                line.special = 0;
                door.speed = 524288;
            }
        }
        door.topheight = sec.FindLowestCeilingSurrounding();
        door.topheight -= 262144;
    }

    default public void SpawnDoorCloseIn30(sector_t sector) {
        vldoor_t door = new vldoor_t();
        this.AddThinker(door);
        sector.specialdata = door;
        sector.special = 0;
        door.thinkerFunction = ActiveStates.T_VerticalDoor;
        door.sector = sector;
        door.direction = 0;
        door.type = vldoor_e.normal;
        door.speed = 131072;
        door.topcountdown = 1050;
    }

    default public void SpawnDoorRaiseIn5Mins(sector_t sector, int secnum) {
        vldoor_t door = new vldoor_t();
        this.AddThinker(door);
        sector.specialdata = door;
        sector.special = 0;
        door.thinkerFunction = ActiveStates.T_VerticalDoor;
        door.sector = sector;
        door.direction = 2;
        door.type = vldoor_e.raiseIn5Mins;
        door.speed = 131072;
        door.topheight = sector.FindLowestCeilingSurrounding();
        door.topheight -= 262144;
        door.topwait = 150;
        door.topcountdown = 10500;
    }
}

