/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.sounds;
import p.Actions.ActionsPlats;
import p.ActiveStates;
import p.floor_e;
import p.floormove_t;
import p.plat_e;
import p.plat_t;
import p.plattype_e;
import p.result_e;
import p.stair_e;
import rr.line_t;
import rr.sector_t;
import rr.side_t;
import s.ISoundOrigin;
import utils.C2JUtils;

public interface ActionsFloors
extends ActionsPlats {
    public static final int FLOORSPEED = 65536;

    public result_e MovePlane(sector_t var1, int var2, int var3, boolean var4, int var5, int var6);

    public boolean twoSided(int var1, int var2);

    public side_t getSide(int var1, int var2, int var3);

    public sector_t getSector(int var1, int var2, int var3);

    default public void MoveFloor(floormove_t floor) {
        result_e res = this.MovePlane(floor.sector, floor.speed, floor.floordestheight, floor.crush, 0, floor.direction);
        if (!C2JUtils.eval(this.LevelTime() & 7)) {
            this.StartSound((ISoundOrigin)floor.sector.soundorg, sounds.sfxenum_t.sfx_stnmov);
        }
        if (res == result_e.pastdest) {
            floor.sector.specialdata = null;
            if (floor.direction == 1) {
                switch (floor.type) {
                    case donutRaise: {
                        floor.sector.special = (short)floor.newspecial;
                        floor.sector.floorpic = floor.texture;
                    }
                }
            } else if (floor.direction == -1) {
                switch (floor.type) {
                    case lowerAndChange: {
                        floor.sector.special = (short)floor.newspecial;
                        floor.sector.floorpic = floor.texture;
                    }
                }
            }
            this.RemoveThinker(floor);
            this.StartSound((ISoundOrigin)floor.sector.soundorg, sounds.sfxenum_t.sfx_pstop);
        }
    }

    @Override
    default public boolean DoFloor(line_t line, floor_e floortype) {
        int secnum = -1;
        boolean rtn = false;
        while ((secnum = this.FindSectorFromLineTag(line, secnum)) >= 0) {
            sector_t sec = this.levelLoader().sectors[secnum];
            if (sec.specialdata != null) continue;
            rtn = true;
            floormove_t floor = new floormove_t();
            sec.specialdata = floor;
            floor.thinkerFunction = ActiveStates.T_MoveFloor;
            this.AddThinker(floor);
            floor.type = floortype;
            floor.crush = false;
            block0 : switch (floortype) {
                case lowerFloor: {
                    floor.direction = -1;
                    floor.sector = sec;
                    floor.speed = 65536;
                    floor.floordestheight = sec.FindHighestFloorSurrounding();
                    break;
                }
                case lowerFloorToLowest: {
                    floor.direction = -1;
                    floor.sector = sec;
                    floor.speed = 65536;
                    floor.floordestheight = sec.FindLowestFloorSurrounding();
                    break;
                }
                case turboLower: {
                    floor.direction = -1;
                    floor.sector = sec;
                    floor.speed = 262144;
                    floor.floordestheight = sec.FindHighestFloorSurrounding();
                    if (floor.floordestheight == sec.floorheight) break;
                    floor.floordestheight += 524288;
                    break;
                }
                case raiseFloorCrush: {
                    floor.crush = true;
                }
                case raiseFloor: {
                    floor.direction = 1;
                    floor.sector = sec;
                    floor.speed = 65536;
                    floor.floordestheight = sec.FindLowestCeilingSurrounding();
                    if (floor.floordestheight > sec.ceilingheight) {
                        floor.floordestheight = sec.ceilingheight;
                    }
                    floor.floordestheight = floor.floordestheight - 524288 * C2JUtils.eval(floortype == floor_e.raiseFloorCrush);
                    break;
                }
                case raiseFloorTurbo: {
                    floor.direction = 1;
                    floor.sector = sec;
                    floor.speed = 262144;
                    floor.floordestheight = sec.FindNextHighestFloor(sec.floorheight);
                    break;
                }
                case raiseFloorToNearest: {
                    floor.direction = 1;
                    floor.sector = sec;
                    floor.speed = 65536;
                    floor.floordestheight = sec.FindNextHighestFloor(sec.floorheight);
                    break;
                }
                case raiseFloor24: {
                    floor.direction = 1;
                    floor.sector = sec;
                    floor.speed = 65536;
                    floor.floordestheight = floor.sector.floorheight + 0x180000;
                    break;
                }
                case raiseFloor512: {
                    floor.direction = 1;
                    floor.sector = sec;
                    floor.speed = 65536;
                    floor.floordestheight = floor.sector.floorheight + 0x2000000;
                    break;
                }
                case raiseFloor24AndChange: {
                    floor.direction = 1;
                    floor.sector = sec;
                    floor.speed = 65536;
                    floor.floordestheight = floor.sector.floorheight + 0x180000;
                    sec.floorpic = line.frontsector.floorpic;
                    sec.special = line.frontsector.special;
                    break;
                }
                case raiseToTexture: {
                    int minsize = Integer.MAX_VALUE;
                    floor.direction = 1;
                    floor.sector = sec;
                    floor.speed = 65536;
                    for (int i = 0; i < sec.linecount; ++i) {
                        if (!this.twoSided(secnum, i)) continue;
                        for (int s = 0; s < 2; ++s) {
                            side_t side = this.getSide(secnum, i, s);
                            if (side.bottomtexture < 0 || this.DOOM().textureManager.getTextureheight(side.bottomtexture) >= minsize) continue;
                            minsize = this.DOOM().textureManager.getTextureheight(side.bottomtexture);
                        }
                    }
                    floor.floordestheight = floor.sector.floorheight + minsize;
                    break;
                }
                case lowerAndChange: {
                    floor.direction = -1;
                    floor.sector = sec;
                    floor.speed = 65536;
                    floor.floordestheight = sec.FindLowestFloorSurrounding();
                    floor.texture = sec.floorpic;
                    for (int i = 0; i < sec.linecount; ++i) {
                        if (!this.twoSided(secnum, i)) continue;
                        if (this.getSide((int)secnum, (int)i, (int)0).sector.id == secnum) {
                            sec = this.getSector(secnum, i, 1);
                            if (sec.floorheight != floor.floordestheight) continue;
                            floor.texture = sec.floorpic;
                            floor.newspecial = sec.special;
                            break block0;
                        }
                        sec = this.getSector(secnum, i, 0);
                        if (sec.floorheight != floor.floordestheight) continue;
                        floor.texture = sec.floorpic;
                        floor.newspecial = sec.special;
                        break block0;
                    }
                    break;
                }
            }
        }
        return rtn;
    }

    @Override
    default public boolean BuildStairs(line_t line, stair_e type) {
        int stairsize = 0;
        int speed = 0;
        int secnum = -1;
        boolean rtn = false;
        while ((secnum = this.FindSectorFromLineTag(line, secnum)) >= 0) {
            boolean ok;
            int height;
            sector_t sec = this.levelLoader().sectors[secnum];
            if (sec.specialdata != null) continue;
            rtn = true;
            floormove_t floor = new floormove_t();
            sec.specialdata = floor;
            floor.thinkerFunction = ActiveStates.T_MoveFloor;
            this.AddThinker(floor);
            floor.direction = 1;
            floor.sector = sec;
            switch (type) {
                case build8: {
                    speed = 16384;
                    stairsize = 524288;
                    break;
                }
                case turbo16: {
                    speed = 262144;
                    stairsize = 0x100000;
                }
            }
            floor.speed = speed;
            floor.floordestheight = height = sec.floorheight + stairsize;
            short texture = sec.floorpic;
            block5: do {
                ok = false;
                for (int i = 0; i < sec.linecount; ++i) {
                    if (!C2JUtils.eval(sec.lines[i].flags & 4)) continue;
                    sector_t tsec = sec.lines[i].frontsector;
                    int newsecnum = tsec.id;
                    if (secnum != newsecnum) continue;
                    tsec = sec.lines[i].backsector;
                    newsecnum = tsec.id;
                    if (tsec.floorpic != texture) continue;
                    height += stairsize;
                    if (tsec.specialdata != null) continue;
                    sec = tsec;
                    secnum = newsecnum;
                    floor = new floormove_t();
                    sec.specialdata = floor;
                    floor.thinkerFunction = ActiveStates.T_MoveFloor;
                    this.AddThinker(floor);
                    floor.direction = 1;
                    floor.sector = sec;
                    floor.speed = speed;
                    floor.floordestheight = height;
                    ok = true;
                    continue block5;
                }
            } while (ok);
        }
        return rtn;
    }

    default public void PlatRaise(plat_t plat) {
        block0 : switch (plat.status) {
            case up: {
                result_e res = this.MovePlane(plat.sector, plat.speed, plat.high, plat.crush, 0, 1);
                if (!(plat.type != plattype_e.raiseAndChange && plat.type != plattype_e.raiseToNearestAndChange || C2JUtils.eval(this.LevelTime() & 7))) {
                    this.StartSound((ISoundOrigin)plat.sector.soundorg, sounds.sfxenum_t.sfx_stnmov);
                }
                if (res == result_e.crushed && !plat.crush) {
                    plat.count = plat.wait;
                    plat.status = plat_e.down;
                    this.StartSound((ISoundOrigin)plat.sector.soundorg, sounds.sfxenum_t.sfx_pstart);
                    break;
                }
                if (res != result_e.pastdest) break;
                plat.count = plat.wait;
                plat.status = plat_e.waiting;
                this.StartSound((ISoundOrigin)plat.sector.soundorg, sounds.sfxenum_t.sfx_pstop);
                switch (plat.type) {
                    case blazeDWUS: 
                    case downWaitUpStay: {
                        this.RemoveActivePlat(plat);
                        break block0;
                    }
                    case raiseAndChange: 
                    case raiseToNearestAndChange: {
                        this.RemoveActivePlat(plat);
                        break block0;
                    }
                }
                break;
            }
            case down: {
                result_e res = this.MovePlane(plat.sector, plat.speed, plat.low, false, 0, -1);
                if (res != result_e.pastdest) break;
                plat.count = plat.wait;
                plat.status = plat_e.waiting;
                this.StartSound((ISoundOrigin)plat.sector.soundorg, sounds.sfxenum_t.sfx_pstop);
                break;
            }
            case waiting: {
                if (--plat.count != 0) break;
                plat.status = plat.sector.floorheight == plat.low ? plat_e.up : plat_e.down;
                this.StartSound((ISoundOrigin)plat.sector.soundorg, sounds.sfxenum_t.sfx_pstart);
            }
        }
    }
}

