/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Defines;
import java.util.function.Predicate;
import m.fixed_t;
import p.AbstractLevelLoader;
import p.Actions.ActionsSectors;
import p.MapUtils;
import p.divline_t;
import p.intercept_t;
import p.mobj_t;
import rr.line_t;
import utils.C2JUtils;
import utils.GenericCopy;
import utils.TraitFactory;

public interface ActionsPathTraverse
extends ActionsSectors {
    public static final TraitFactory.ContextKey<Traverse> KEY_TRAVERSE = ACTION_KEY_CHAIN.newKey(ActionsPathTraverse.class, Traverse::new);

    @Override
    default public boolean PathTraverse(int x1, int y1, int x2, int y2, int flags, Predicate<intercept_t> trav) {
        int xstep;
        int mapystep;
        int ystep;
        int partial;
        int mapxstep;
        AbstractLevelLoader ll = this.levelLoader();
        ActionsSectors.Spawn sp = (ActionsSectors.Spawn)this.contextRequire(KEY_SPAWN);
        Traverse tr = this.contextRequire(KEY_TRAVERSE);
        tr.earlyout = C2JUtils.eval(flags & Defines.PT_EARLYOUT);
        this.sceneRenderer().increaseValidCount(1);
        tr.intercept_p = 0;
        if ((x1 - ll.bmaporgx & 0x7FFFFF) == 0) {
            x1 += 65536;
        }
        if ((y1 - ll.bmaporgy & 0x7FFFFF) == 0) {
            y1 += 65536;
        }
        sp.trace.x = x1;
        sp.trace.y = y1;
        sp.trace.dx = x2 - x1;
        sp.trace.dy = y2 - y1;
        long _x1 = (long)x1 - (long)ll.bmaporgx;
        long _y1 = (long)y1 - (long)ll.bmaporgy;
        int xt1 = (int)(_x1 >> 23);
        int yt1 = (int)(_y1 >> 23);
        int mapx1 = (int)(_x1 >> 7);
        int mapy1 = (int)(_y1 >> 7);
        long _x2 = (long)x2 - (long)ll.bmaporgx;
        long _y2 = (long)y2 - (long)ll.bmaporgy;
        int xt2 = (int)(_x2 >> 23);
        int yt2 = (int)(_y2 >> 23);
        x1 -= ll.bmaporgx;
        y1 -= ll.bmaporgy;
        x2 -= ll.bmaporgx;
        y2 -= ll.bmaporgy;
        if (xt2 > xt1) {
            mapxstep = 1;
            partial = 65536 - (mapx1 & 0xFFFF);
            ystep = fixed_t.FixedDiv(y2 - y1, Math.abs(x2 - x1));
        } else if (xt2 < xt1) {
            mapxstep = -1;
            partial = mapx1 & 0xFFFF;
            ystep = fixed_t.FixedDiv(y2 - y1, Math.abs(x2 - x1));
        } else {
            mapxstep = 0;
            partial = 65536;
            ystep = 0x1000000;
        }
        int yintercept = mapy1 + fixed_t.FixedMul(partial, ystep);
        if (yt2 > yt1) {
            mapystep = 1;
            partial = 65536 - (mapy1 & 0xFFFF);
            xstep = fixed_t.FixedDiv(x2 - x1, Math.abs(y2 - y1));
        } else if (yt2 < yt1) {
            mapystep = -1;
            partial = mapy1 & 0xFFFF;
            xstep = fixed_t.FixedDiv(x2 - x1, Math.abs(y2 - y1));
        } else {
            mapystep = 0;
            partial = 65536;
            xstep = 0x1000000;
        }
        int xintercept = mapx1 + fixed_t.FixedMul(partial, xstep);
        int mapx = xt1;
        int mapy = yt1;
        for (int count = 0; count < 64; ++count) {
            boolean changeY;
            if (C2JUtils.eval(flags & Defines.PT_ADDLINES) && !this.BlockLinesIterator(mapx, mapy, this::AddLineIntercepts)) {
                return false;
            }
            if (C2JUtils.eval(flags & Defines.PT_ADDTHINGS) && !this.BlockThingsIterator(mapx, mapy, this::AddThingIntercepts)) {
                return false;
            }
            if (mapx == xt2 && mapy == yt2) break;
            boolean changeX = yintercept >> 16 == mapy;
            boolean bl = changeY = xintercept >> 16 == mapx;
            if (changeX) {
                yintercept += ystep;
                mapx += mapxstep;
                continue;
            }
            if (!changeY) continue;
            xintercept += xstep;
            mapy += mapystep;
        }
        return this.TraverseIntercept(trav, 65536);
    }

    default public boolean AddLineIntercepts(line_t ld) {
        boolean s2;
        boolean s1;
        ActionsSectors.Spawn sp = (ActionsSectors.Spawn)this.contextRequire(KEY_SPAWN);
        Traverse tr = this.contextRequire(KEY_TRAVERSE);
        if (sp.trace.dx > 0x100000 || sp.trace.dy > 0x100000 || sp.trace.dx < -1048576 || sp.trace.dy < -1048576) {
            s1 = sp.trace.PointOnDivlineSide(ld.v1x, ld.v1y);
            s2 = sp.trace.PointOnDivlineSide(ld.v2x, ld.v2y);
        } else {
            s1 = ld.PointOnLineSide(sp.trace.x, sp.trace.y);
            s2 = ld.PointOnLineSide(sp.trace.x + sp.trace.dx, sp.trace.y + sp.trace.dy);
        }
        if (s1 == s2) {
            return true;
        }
        tr.addLineDivLine.MakeDivline(ld);
        int frac = MapUtils.InterceptVector(sp.trace, tr.addLineDivLine);
        if (frac < 0) {
            return true;
        }
        if (tr.earlyout && frac < 65536 && ld.backsector == null) {
            return false;
        }
        if (tr.intercept_p >= tr.intercepts.length) {
            tr.ResizeIntercepts();
        }
        tr.intercepts[tr.intercept_p].frac = frac;
        tr.intercepts[tr.intercept_p].isaline = true;
        tr.intercepts[tr.intercept_p].line = ld;
        ++tr.intercept_p;
        return true;
    }

    default public boolean AddThingIntercepts(mobj_t thing) {
        int y2;
        int x2;
        int y1;
        int x1;
        boolean tracepositive;
        ActionsSectors.Spawn sp = (ActionsSectors.Spawn)this.contextRequire(KEY_SPAWN);
        Traverse tr = this.contextRequire(KEY_TRAVERSE);
        boolean bl = tracepositive = (sp.trace.dx ^ sp.trace.dy) > 0;
        if (tracepositive) {
            x1 = thing.x - thing.radius;
            y1 = thing.y + thing.radius;
            x2 = thing.x + thing.radius;
            y2 = thing.y - thing.radius;
        } else {
            x1 = thing.x - thing.radius;
            y1 = thing.y - thing.radius;
            x2 = thing.x + thing.radius;
            y2 = thing.y + thing.radius;
        }
        boolean s1 = sp.trace.PointOnDivlineSide(x1, y1);
        boolean s2 = sp.trace.PointOnDivlineSide(x2, y2);
        if (s1 == s2) {
            return true;
        }
        tr.thingInterceptDivLine.x = x1;
        tr.thingInterceptDivLine.y = y1;
        tr.thingInterceptDivLine.dx = x2 - x1;
        tr.thingInterceptDivLine.dy = y2 - y1;
        int frac = MapUtils.InterceptVector(sp.trace, tr.thingInterceptDivLine);
        if (frac < 0) {
            return true;
        }
        if (tr.intercept_p >= tr.intercepts.length) {
            tr.ResizeIntercepts();
        }
        tr.intercepts[tr.intercept_p].frac = frac;
        tr.intercepts[tr.intercept_p].isaline = false;
        tr.intercepts[tr.intercept_p].thing = thing;
        ++tr.intercept_p;
        return true;
    }

    default public boolean TraverseIntercept(Predicate<intercept_t> func, int maxfrac) {
        Traverse tr = this.contextRequire(KEY_TRAVERSE);
        intercept_t in = null;
        int count = tr.intercept_p;
        while (count-- > 0) {
            int dist = Integer.MAX_VALUE;
            for (int scan = 0; scan < tr.intercept_p; ++scan) {
                if (tr.intercepts[scan].frac >= dist) continue;
                dist = tr.intercepts[scan].frac;
                in = tr.intercepts[scan];
            }
            if (dist > maxfrac) {
                return true;
            }
            if (!func.test(in)) {
                return false;
            }
            in.frac = Integer.MAX_VALUE;
        }
        return true;
    }

    public static final class Traverse {
        divline_t addLineDivLine = new divline_t();
        divline_t thingInterceptDivLine = new divline_t();
        boolean earlyout;
        int intercept_p;
        intercept_t[] intercepts = (intercept_t[])GenericCopy.malloc(intercept_t::new, intercept_t[]::new, 128);

        void ResizeIntercepts() {
            this.intercepts = C2JUtils.resize(this.intercepts[0], this.intercepts, this.intercepts.length * 2);
        }
    }
}

