/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.sounds;
import doom.thinker_t;
import java.util.logging.Level;
import java.util.logging.Logger;
import m.Settings;
import mochadoom.Engine;
import mochadoom.Loggers;
import p.AbstractLevelLoader;
import p.Actions.ActionsMoveEvents;
import p.Actions.ActionsUseEvents;
import p.ActiveStates;
import p.plat_e;
import p.plat_t;
import p.plattype_e;
import rr.line_t;
import rr.sector_t;
import s.ISoundOrigin;
import utils.C2JUtils;
import utils.TraitFactory;

public interface ActionsPlats
extends ActionsMoveEvents,
ActionsUseEvents {
    public static final TraitFactory.ContextKey<Plats> KEY_PLATS = ACTION_KEY_CHAIN.newKey(ActionsPlats.class, Plats::new);

    public int FindSectorFromLineTag(line_t var1, int var2);

    @Override
    public void RemoveThinker(thinker_t var1);

    @Override
    default public boolean DoPlat(line_t line, plattype_e type, int amount) {
        AbstractLevelLoader ll = this.levelLoader();
        int secnum = -1;
        boolean rtn = false;
        switch (type) {
            case perpetualRaise: {
                this.ActivateInStasis(line.tag);
                break;
            }
        }
        while ((secnum = this.FindSectorFromLineTag(line, secnum)) >= 0) {
            sector_t sec = ll.sectors[secnum];
            if (sec.specialdata != null) continue;
            rtn = true;
            plat_t plat = new plat_t();
            plat.type = type;
            plat.sector = sec;
            plat.sector.specialdata = plat;
            plat.thinkerFunction = ActiveStates.T_PlatRaise;
            this.AddThinker(plat);
            plat.crush = false;
            plat.tag = line.tag;
            switch (type) {
                case raiseToNearestAndChange: {
                    plat.speed = 32768;
                    sec.floorpic = ll.sides[line.sidenum[0]].sector.floorpic;
                    plat.high = sec.FindNextHighestFloor(sec.floorheight);
                    plat.wait = 0;
                    plat.status = plat_e.up;
                    sec.special = 0;
                    this.StartSound((ISoundOrigin)sec.soundorg, sounds.sfxenum_t.sfx_stnmov);
                    break;
                }
                case raiseAndChange: {
                    plat.speed = 32768;
                    sec.floorpic = ll.sides[line.sidenum[0]].sector.floorpic;
                    plat.high = sec.floorheight + amount * 65536;
                    plat.wait = 0;
                    plat.status = plat_e.up;
                    this.StartSound((ISoundOrigin)sec.soundorg, sounds.sfxenum_t.sfx_stnmov);
                    break;
                }
                case downWaitUpStay: {
                    plat.speed = 262144;
                    plat.low = sec.FindLowestFloorSurrounding();
                    if (plat.low > sec.floorheight) {
                        plat.low = sec.floorheight;
                    }
                    plat.high = sec.floorheight;
                    plat.wait = 105;
                    plat.status = plat_e.down;
                    this.StartSound((ISoundOrigin)sec.soundorg, sounds.sfxenum_t.sfx_pstart);
                    break;
                }
                case blazeDWUS: {
                    plat.speed = 524288;
                    plat.low = sec.FindLowestFloorSurrounding();
                    if (plat.low > sec.floorheight) {
                        plat.low = sec.floorheight;
                    }
                    plat.high = sec.floorheight;
                    plat.wait = 105;
                    plat.status = plat_e.down;
                    this.StartSound((ISoundOrigin)sec.soundorg, sounds.sfxenum_t.sfx_pstart);
                    break;
                }
                case perpetualRaise: {
                    plat.speed = 65536;
                    plat.low = sec.FindLowestFloorSurrounding();
                    if (plat.low > sec.floorheight) {
                        plat.low = sec.floorheight;
                    }
                    plat.high = sec.FindHighestFloorSurrounding();
                    if (plat.high < sec.floorheight) {
                        plat.high = sec.floorheight;
                    }
                    plat.wait = 105;
                    plat.status = plat_e.values()[this.P_Random() & 1];
                    this.StartSound((ISoundOrigin)sec.soundorg, sounds.sfxenum_t.sfx_pstart);
                }
            }
            this.AddActivePlat(plat);
        }
        return rtn;
    }

    default public void ActivateInStasis(int tag) {
        Plats plats = this.contextRequire(KEY_PLATS);
        for (plat_t activeplat : plats.activeplats) {
            if (activeplat == null || activeplat.tag != tag || activeplat.status != plat_e.in_stasis) continue;
            activeplat.status = activeplat.oldstatus;
            activeplat.thinkerFunction = ActiveStates.T_PlatRaise;
        }
    }

    @Override
    default public void StopPlat(line_t line) {
        Plats plats = this.contextRequire(KEY_PLATS);
        for (plat_t activeplat : plats.activeplats) {
            if (activeplat == null || activeplat.status == plat_e.in_stasis || activeplat.tag != line.tag) continue;
            activeplat.oldstatus = activeplat.status;
            activeplat.status = plat_e.in_stasis;
            activeplat.thinkerFunction = null;
        }
    }

    default public void AddActivePlat(plat_t plat) {
        Plats plats = this.contextRequire(KEY_PLATS);
        for (int i = 0; i < plats.activeplats.length; ++i) {
            if (plats.activeplats[i] != null) continue;
            plats.activeplats[i] = plat;
            return;
        }
        if (Engine.getConfig().equals(Settings.extend_plats_limit, Boolean.TRUE)) {
            plats.activeplats = C2JUtils.resizeNoAutoInit(plats.activeplats, 2 * plats.activeplats.length);
            this.AddActivePlat(plat);
        } else {
            Plats.LOGGER.log(Level.SEVERE, "P_AddActivePlat: no more plats!");
            System.exit(1);
        }
    }

    default public void RemoveActivePlat(plat_t plat) {
        Plats plats = this.contextRequire(KEY_PLATS);
        for (int i = 0; i < plats.activeplats.length; ++i) {
            if (plat != plats.activeplats[i]) continue;
            plats.activeplats[i].sector.specialdata = null;
            this.RemoveThinker(plats.activeplats[i]);
            plats.activeplats[i] = null;
            return;
        }
        Plats.LOGGER.log(Level.SEVERE, "P_RemoveActivePlat: can't find plat!");
        System.exit(1);
    }

    default public void ClearPlatsBeforeLoading() {
        Plats plats = this.contextRequire(KEY_PLATS);
        for (int i = 0; i < plats.activeplats.length; ++i) {
            plats.activeplats[i] = null;
        }
    }

    public static final class Plats {
        static final Logger LOGGER = Loggers.getLogger(ActionsPlats.class.getName());
        plat_t[] activeplats = new plat_t[30];
    }
}

